/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.CommonTypes;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.PeekingIterator;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Handle;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.impldep.org.objectweb.asm.commons.CodeSizeEvaluator;
import org.gradle.model.internal.asm.MethodVisitorScope;

@NonNullApi
class LambdaSerializationTransformer
extends ClassVisitor {
    private static final int MAX_CODE_SIZE = 65536;
    private static final Type SERIALIZED_LAMBDA_TYPE = Type.getType(SerializedLambda.class);
    private static final String RETURN_OBJECT_FROM_SERIALIZED_LAMBDA = Type.getMethodDescriptor((Type)CommonTypes.OBJECT_TYPE, (Type[])new Type[]{SERIALIZED_LAMBDA_TYPE});
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)CommonTypes.STRING_TYPE, (Type[])new Type[0]);
    private static final String RETURN_BOOLEAN_FROM_OBJECT = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{CommonTypes.OBJECT_TYPE});
    private static final String RETURN_OBJECT_FROM_INT = Type.getMethodDescriptor((Type)CommonTypes.OBJECT_TYPE, (Type[])new Type[]{Type.INT_TYPE});
    private static final String LAMBDA_METAFACTORY_TYPE = Type.getType(LambdaMetafactory.class).getInternalName();
    private static final String LAMBDA_METAFACTORY_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), CommonTypes.STRING_TYPE, Type.getType(MethodType.class), Type.getType(Object[].class)});
    private static final String DESERIALIZE_LAMBDA = "$deserializeLambda$";
    private static final String RENAMED_DESERIALIZE_LAMBDA = "$renamedDeserializeLambda$";
    private final List<LambdaFactoryDetails> lambdaFactories = new ArrayList<LambdaFactoryDetails>();
    private String className;
    private boolean hasDeserializeLambda;
    private boolean isInterface;

    protected LambdaSerializationTransformer(ClassVisitor classVisitor) {
        super(589824, classVisitor);
    }

    public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.isInterface = (access & 0x200) != 0;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        if (name.equals(DESERIALIZE_LAMBDA) && descriptor.equals(RETURN_OBJECT_FROM_SERIALIZED_LAMBDA)) {
            this.hasDeserializeLambda = true;
            return super.visitMethod(access, RENAMED_DESERIALIZE_LAMBDA, descriptor, signature, exceptions);
        }
        return new LambdaFactoryCallRewriter(super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    public void visitEnd() {
        if (!this.lambdaFactories.isEmpty() || this.hasDeserializeLambda) {
            this.generateLambdaDeserializeMethod();
        }
        super.visitEnd();
    }

    private void generateLambdaDeserializeMethod() {
        PeekingIterator factoriesIterator = Iterators.peekingIterator(this.lambdaFactories.iterator());
        int nextSplitMethodIndex = 0;
        String currentSplitMethodName = DESERIALIZE_LAMBDA;
        do {
            String nextSplitMethodName = String.format("$deserializeLambda%d$", nextSplitMethodIndex);
            this.generateSplitLambdaDeserializeMethod(currentSplitMethodName, nextSplitMethodName, (PeekingIterator<LambdaFactoryDetails>)factoriesIterator);
            currentSplitMethodName = nextSplitMethodName;
            ++nextSplitMethodIndex;
        } while (factoriesIterator.hasNext());
    }

    private void generateSplitLambdaDeserializeMethod(String methodName, final String nextSplitMethodName, final PeekingIterator<LambdaFactoryDetails> factoriesIterator) {
        final CodeSizeEvaluator sizeEvaluator = new CodeSizeEvaluator(this.visitStaticPrivateMethod(methodName, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA));
        new MethodVisitorScope((MethodVisitor)sizeEvaluator){
            {
                super(methodVisitor);
                Label next = null;
                while (factoriesIterator.hasNext()) {
                    LambdaFactoryDetails factory = (LambdaFactoryDetails)factoriesIterator.peek();
                    Type[] argumentTypes = Type.getArgumentTypes((String)factory.descriptor);
                    int codeSizeSoFar = sizeEvaluator.getMaxSize();
                    if (codeSizeSoFar + LambdaSerializationTransformer.this.getEstimatedSingleLambdaHandlingCodeLength(argumentTypes) + LambdaSerializationTransformer.this.getEstimatedEpilogueLength() >= 65536) {
                        if (codeSizeSoFar != 0) break;
                        throw new InvalidUserCodeException("Cannot generate the deserialization method for class " + LambdaSerializationTransformer.this.className + " because lambda implementation " + factory.name + " has too many captured arguments (" + argumentTypes.length + ")");
                    }
                    factoriesIterator.next();
                    if (next != null) {
                        this.visitLabel(next);
                        this._F_SAME();
                    }
                    next = new Label();
                    Handle implHandle = (Handle)factory.bootstrapMethodArguments.get(1);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getImplMethodName", RETURN_STRING);
                    this._LDC(implHandle.getName());
                    this._INVOKEVIRTUAL(CommonTypes.OBJECT_TYPE, "equals", RETURN_BOOLEAN_FROM_OBJECT);
                    this._IFEQ(next);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getImplMethodSignature", RETURN_STRING);
                    this._LDC(implHandle.getDesc());
                    this._INVOKEVIRTUAL(CommonTypes.OBJECT_TYPE, "equals", RETURN_BOOLEAN_FROM_OBJECT);
                    this._IFEQ(next);
                    for (int i = 0; i < argumentTypes.length; ++i) {
                        this._ALOAD(0);
                        this._LDC(i);
                        this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getCapturedArg", RETURN_OBJECT_FROM_INT);
                        this._UNBOX(argumentTypes[i]);
                    }
                    this._INVOKEDYNAMIC(factory.name, factory.descriptor, factory.bootstrapMethodHandle, factory.bootstrapMethodArguments);
                    this._ARETURN();
                }
                if (next != null) {
                    this.visitLabel(next);
                    this._F_SAME();
                }
                if (factoriesIterator.hasNext()) {
                    this._ALOAD(0);
                    this._INVOKESTATIC(LambdaSerializationTransformer.this.className, nextSplitMethodName, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA, LambdaSerializationTransformer.this.isInterface);
                } else if (LambdaSerializationTransformer.this.hasDeserializeLambda) {
                    this._ALOAD(0);
                    this._INVOKESTATIC(LambdaSerializationTransformer.this.className, LambdaSerializationTransformer.RENAMED_DESERIALIZE_LAMBDA, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA, LambdaSerializationTransformer.this.isInterface);
                } else {
                    this._ACONST_NULL();
                }
                this._ARETURN();
                this.visitMaxs(0, 0);
                this.visitEnd();
            }
        };
    }

    int getEstimatedDeserializationPrologueLength() {
        return 0;
    }

    int getEstimatedEpilogueLength() {
        return this.hasDeserializeLambda ? 5 : 2;
    }

    int getEstimatedSingleLambdaHandlingCodeLength(Type[] arguments) {
        int nonArgumentCodeSize = 42;
        int argumentHandlingLength = 0;
        for (Type arg : arguments) {
            argumentHandlingLength += LambdaSerializationTransformer.getEstimatedArgumentHandlingCodeLength(arg);
        }
        return nonArgumentCodeSize + argumentHandlingLength;
    }

    private static int getEstimatedArgumentHandlingCodeLength(Type argument) {
        int loadSize = 7;
        int unboxingSize = LambdaSerializationTransformer.isPrimitiveArgument(argument) ? 6 : 3;
        return loadSize + unboxingSize;
    }

    private static boolean isPrimitiveArgument(Type argument) {
        switch (argument.getSort()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private MethodVisitor visitStaticPrivateMethod(String name, String descriptor) {
        return super.visitMethod(4106, name, descriptor, null, CommonTypes.NO_EXCEPTIONS);
    }

    private void addSerializedLambda(LambdaFactoryDetails lambdaFactoryDetails) {
        this.lambdaFactories.add(lambdaFactoryDetails);
    }

    @NonNullApi
    private static class LambdaFactoryDetails {
        final String name;
        final String descriptor;
        final Handle bootstrapMethodHandle;
        final List<?> bootstrapMethodArguments;

        public LambdaFactoryDetails(String name, String descriptor, Handle bootstrapMethodHandle, List<?> bootstrapMethodArguments) {
            this.name = name;
            this.descriptor = descriptor;
            this.bootstrapMethodHandle = bootstrapMethodHandle;
            this.bootstrapMethodArguments = bootstrapMethodArguments;
        }
    }

    @NonNullApi
    private class LambdaFactoryCallRewriter
    extends MethodVisitorScope {
        public LambdaFactoryCallRewriter(MethodVisitor methodVisitor) {
            super(methodVisitor);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (bootstrapMethodHandle.getOwner().equals(LAMBDA_METAFACTORY_TYPE) && bootstrapMethodHandle.getName().equals("metafactory")) {
                Handle altMethod = new Handle(6, LAMBDA_METAFACTORY_TYPE, "altMetafactory", LAMBDA_METAFACTORY_METHOD_DESCRIPTOR, false);
                ArrayList<Integer> args = new ArrayList<Integer>(bootstrapMethodArguments.length + 1);
                Collections.addAll(args, bootstrapMethodArguments);
                args.add(1);
                super.visitInvokeDynamicInsn(name, descriptor, altMethod, args.toArray());
                LambdaSerializationTransformer.this.addSerializedLambda(new LambdaFactoryDetails(name, descriptor, altMethod, args));
            } else {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }
    }
}

