/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskReference;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.util.Path;

public class IncludedRootBuild
implements IncludedBuildInternal {
    private final CompositeBuildParticipantBuildState rootBuild;

    public IncludedRootBuild(CompositeBuildParticipantBuildState rootBuild) {
        this.rootBuild = rootBuild;
    }

    public CompositeBuildParticipantBuildState getRootBuild() {
        return this.rootBuild;
    }

    @Override
    public String getName() {
        return this.rootBuild.getProjects().getRootProject().getName();
    }

    @Override
    public File getProjectDir() {
        return this.rootBuild.getBuildRootDir();
    }

    @Override
    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
        return new IncludedRootBuildTaskReference(this.rootBuild, path);
    }

    @Override
    public BuildState getTarget() {
        return this.rootBuild;
    }

    private static class IncludedRootBuildTaskReference
    implements TaskReference,
    TaskDependencyContainer {
        private final String taskPath;
        private final CompositeBuildParticipantBuildState rootBuildState;

        public IncludedRootBuildTaskReference(CompositeBuildParticipantBuildState rootBuildState, String taskPath) {
            this.rootBuildState = rootBuildState;
            this.taskPath = taskPath;
        }

        @Override
        public String getName() {
            return Path.path(this.taskPath).getName();
        }

        public BuildIdentifier getBuildIdentifier() {
            return this.rootBuildState.getBuildIdentifier();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.resolveTask());
        }

        private Task resolveTask() {
            this.rootBuildState.ensureProjectsConfigured();
            return this.rootBuildState.getMutableModel().getRootProject().getTasks().getByPath(this.taskPath);
        }
    }
}

