/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.services;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.file.FileEvents;
import net.rubygrapefruit.platform.file.FileSystems;
import net.rubygrapefruit.platform.file.Files;
import net.rubygrapefruit.platform.file.PosixFiles;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import net.rubygrapefruit.platform.memory.Memory;
import net.rubygrapefruit.platform.terminal.Terminals;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.temp.GradleUserHomeTemporaryFileProvider;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.NativeCapabilities;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.FallbackConsoleDetector;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleDetector;
import org.gradle.internal.nativeintegration.console.TestOverrideConsoleDetector;
import org.gradle.internal.nativeintegration.console.WindowsConsoleDetector;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.FileSystemServices;
import org.gradle.internal.nativeintegration.filesystem.services.JdkFallbackHelper;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.jansi.JansiBootPathConfigurer;
import org.gradle.internal.nativeintegration.jna.UnsupportedEnvironment;
import org.gradle.internal.nativeintegration.network.HostnameLookup;
import org.gradle.internal.nativeintegration.processenvironment.NativePlatformBackedProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeServices
extends DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeServices.class);
    private static final NativeServices INSTANCE = new NativeServices();
    public static final String NATIVE_DIR_OVERRIDE = "org.gradle.native.dir";
    private boolean initialized;
    private boolean useNativeIntegrations;
    private File userHomeDir;
    private File nativeBaseDir;
    private final EnumSet<NativeFeatures> initializedFeatures = EnumSet.noneOf(NativeFeatures.class);
    private final EnumSet<NativeFeatures> enabledFeatures = EnumSet.noneOf(NativeFeatures.class);

    public static void initializeOnDaemon(File userHomeDir) {
        INSTANCE.initialize(userHomeDir, EnumSet.allOf(NativeFeatures.class));
    }

    public static void initializeOnClient(File userHomeDir) {
        INSTANCE.initialize(userHomeDir, EnumSet.of(NativeFeatures.JANSI));
    }

    public static void initializeOnWorker(File userHomeDir) {
        INSTANCE.initialize(userHomeDir, EnumSet.noneOf(NativeFeatures.class));
    }

    private void initialize(File userHomeDir, EnumSet<NativeFeatures> requestedFeatures) {
        if (!this.initialized) {
            try {
                this.initializeNativeIntegrations(userHomeDir);
                this.initialized = true;
                this.initializeFeatures(requestedFeatures);
            }
            catch (RuntimeException e) {
                throw new ServiceCreationException("Could not initialize native services.", e);
            }
        }
    }

    private void initializeNativeIntegrations(File userHomeDir) {
        this.userHomeDir = userHomeDir;
        this.useNativeIntegrations = NativeServices.isNativeIntegrationsEnabled();
        this.nativeBaseDir = NativeServices.getNativeServicesDir(userHomeDir).getAbsoluteFile();
        if (this.useNativeIntegrations) {
            try {
                Native.init(this.nativeBaseDir);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform is not available.", (Throwable)ex);
                this.useNativeIntegrations = false;
            }
            catch (NativeException ex) {
                if (ex.getCause() instanceof UnsatisfiedLinkError && ex.getCause().getMessage().toLowerCase().contains("already loaded in another classloader")) {
                    LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                    this.useNativeIntegrations = false;
                }
                if (ex.getMessage().equals("Could not extract native JNI library.") && ex.getCause().getMessage().contains("native-platform.dll (The process cannot access the file because it is being used by another process)")) {
                    LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                    this.useNativeIntegrations = false;
                }
                throw ex;
            }
            LOGGER.info("Initialized native services in: {}", (Object)this.nativeBaseDir);
        }
    }

    private void initializeFeatures(EnumSet<NativeFeatures> requestedFeatures) {
        if (NativeServices.isNativeIntegrationsEnabled()) {
            for (NativeFeatures requestedFeature : requestedFeatures) {
                if (!this.initializedFeatures.add(requestedFeature) || !requestedFeature.initialize(this.nativeBaseDir, this.useNativeIntegrations)) continue;
                this.enabledFeatures.add(requestedFeature);
            }
        }
    }

    private static boolean isNativeIntegrationsEnabled() {
        return "true".equalsIgnoreCase(System.getProperty("org.gradle.native", "true"));
    }

    private boolean isFeatureEnabled(NativeFeatures feature) {
        return this.enabledFeatures.contains((Object)feature);
    }

    private static File getNativeServicesDir(File userHomeDir) {
        String overrideProperty = NativeServices.getNativeDirOverride();
        if (overrideProperty == null) {
            return new File(userHomeDir, "native");
        }
        return new File(overrideProperty);
    }

    private static String getNativeDirOverride() {
        return System.getProperty(NATIVE_DIR_OVERRIDE, System.getenv(NATIVE_DIR_OVERRIDE));
    }

    public static synchronized NativeServices getInstance() {
        if (!NativeServices.INSTANCE.initialized) {
            throw new IllegalStateException("Cannot get an instance of NativeServices without first calling initialize().");
        }
        return INSTANCE;
    }

    private NativeServices() {
        this.addProvider(new FileSystemServices());
        this.register((Action<? super ServiceRegistration>)new Action<ServiceRegistration>(){

            @Override
            public void execute(ServiceRegistration registration) {
                registration.add(GradleUserHomeTemporaryFileProvider.class);
            }
        });
    }

    @Override
    public void close() {
    }

    protected GradleUserHomeDirProvider createGradleUserHomeDirProvider() {
        return new GradleUserHomeDirProvider(){

            @Override
            public File getGradleUserHomeDirectory() {
                return NativeServices.this.userHomeDir;
            }
        };
    }

    protected OperatingSystem createOperatingSystem() {
        return OperatingSystem.current();
    }

    protected Jvm createJvm() {
        return Jvm.current();
    }

    protected ProcessEnvironment createProcessEnvironment(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                Process process = Native.get(Process.class);
                return new NativePlatformBackedProcessEnvironment(process);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform process integration is not available. Continuing with fallback.");
            }
        }
        return new UnsupportedEnvironment();
    }

    protected ConsoleDetector createConsoleDetector(OperatingSystem operatingSystem) {
        return new TestOverrideConsoleDetector(this.backingConsoleDetector(operatingSystem));
    }

    private ConsoleDetector backingConsoleDetector(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                Terminals terminals = Native.get(Terminals.class);
                return new NativePlatformConsoleDetector(terminals);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform terminal integration is not available. Continuing with fallback.");
            }
            catch (NativeException ex) {
                LOGGER.debug("Unable to load from native-platform backed ConsoleDetector. Continuing with fallback. Failure: {}", (Object)NativeServices.format(ex));
            }
            try {
                if (operatingSystem.isWindows()) {
                    return new WindowsConsoleDetector();
                }
            }
            catch (LinkageError e) {
                LOGGER.debug("Unable to load native library. Continuing with fallback. Failure: {}", (Object)NativeServices.format(e));
            }
        }
        return new FallbackConsoleDetector();
    }

    protected WindowsRegistry createWindowsRegistry(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations && operatingSystem.isWindows()) {
            return Native.get(WindowsRegistry.class);
        }
        return this.notAvailable(WindowsRegistry.class);
    }

    protected SystemInfo createSystemInfo() {
        if (this.useNativeIntegrations) {
            try {
                return Native.get(SystemInfo.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform system info is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(SystemInfo.class);
    }

    protected Memory createMemory() {
        if (this.useNativeIntegrations) {
            try {
                return Native.get(Memory.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform memory integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(Memory.class);
    }

    protected ProcessLauncher createProcessLauncher() {
        if (this.useNativeIntegrations) {
            try {
                return Native.get(ProcessLauncher.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform process launcher is not available. Continuing with fallback.");
            }
        }
        return new DefaultProcessLauncher();
    }

    protected PosixFiles createPosixFiles() {
        if (this.useNativeIntegrations) {
            try {
                return Native.get(PosixFiles.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(UnavailablePosixFiles.class);
    }

    protected HostnameLookup createHostnameLookup() {
        String hostname;
        if (this.useNativeIntegrations) {
            try {
                String hostname2 = Native.get(SystemInfo.class).getHostname();
                return new FixedHostname(hostname2);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return new FixedHostname(hostname);
    }

    protected FileMetadataAccessor createFileMetadataAccessor(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return new NativePlatformBackedFileMetadataAccessor(Native.get(Files.class));
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform files integration is not available. Continuing with fallback.");
            }
        }
        if (JavaVersion.current().isJava7Compatible()) {
            return JdkFallbackHelper.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.NioFileMetadataAccessor", NativeServices.class.getClassLoader(), FallbackFileMetadataAccessor.class);
        }
        return new FallbackFileMetadataAccessor();
    }

    protected NativeCapabilities createNativeCapabilities() {
        return new NativeCapabilities(){

            @Override
            public boolean useNativeIntegrations() {
                return NativeServices.this.useNativeIntegrations;
            }

            @Override
            public boolean useFileSystemWatching() {
                return NativeServices.this.isFeatureEnabled(NativeFeatures.FILE_SYSTEM_WATCHING);
            }
        };
    }

    protected FileSystems createFileSystems() {
        if (this.useNativeIntegrations) {
            try {
                return Native.get(FileSystems.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform file systems information is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(FileSystems.class);
    }

    private <T> T notAvailable(Class<T> type) {
        return Cast.uncheckedNonnullCast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new BrokenService(type.getSimpleName())));
    }

    private static String format(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(throwable.toString());
        for (Throwable current = throwable.getCause(); current != null; current = current.getCause()) {
            builder.append(SystemProperties.getInstance().getLineSeparator());
            builder.append("caused by: ");
            builder.append(current);
        }
        return builder.toString();
    }

    private static class FixedHostname
    implements HostnameLookup {
        private final String hostname;

        public FixedHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }
    }

    private static class BrokenService
    implements InvocationHandler {
        private final String type;

        private BrokenService(String type) {
            this.type = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new NativeIntegrationUnavailableException(String.format("%s is not supported on this operating system.", this.type));
        }
    }

    public static enum NativeFeatures {
        FILE_SYSTEM_WATCHING{

            @Override
            public boolean initialize(File nativeBaseDir, boolean useNativeIntegrations) {
                if (useNativeIntegrations) {
                    try {
                        FileEvents.init(nativeBaseDir);
                        LOGGER.info("Initialized file system watching services in: {}", (Object)nativeBaseDir);
                        return true;
                    }
                    catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                        LOGGER.debug("Native file system watching is not available for this operating system.", (Throwable)ex);
                        return false;
                    }
                }
                return false;
            }
        }
        ,
        JANSI{

            @Override
            public boolean initialize(File nativeBaseDir, boolean canUseNativeIntegrations) {
                JANSI_BOOT_PATH_CONFIGURER.configure(nativeBaseDir);
                LOGGER.info("Initialized jansi services in: {}", (Object)nativeBaseDir);
                return true;
            }
        };

        private static final JansiBootPathConfigurer JANSI_BOOT_PATH_CONFIGURER;

        public abstract boolean initialize(File var1, boolean var2);

        static {
            JANSI_BOOT_PATH_CONFIGURER = new JansiBootPathConfigurer();
        }
    }
}

