/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.snapshot.impl.StringValueSnapshot;

public class CoercingStringValueSnapshot
extends StringValueSnapshot {
    private final NamedObjectInstantiator instantiator;

    public CoercingStringValueSnapshot(String value, NamedObjectInstantiator instantiator2) {
        super(value);
        this.instantiator = instantiator2;
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        if (type.isInstance(this.getValue())) {
            return type.cast(this);
        }
        if (type.isEnum()) {
            return type.cast(Enum.valueOf((Class)Cast.uncheckedNonnullCast(type.asSubclass(Enum.class)), (String)this.getValue()));
        }
        if (Named.class.isAssignableFrom(type)) {
            return type.cast(this.instantiator.named(type.asSubclass(Named.class), (String)this.getValue()));
        }
        if (Integer.class.equals(type)) {
            return type.cast(Integer.parseInt((String)this.getValue()));
        }
        return null;
    }
}

