/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import java.util.Locale;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.gc.DefaultGarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionInfo;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

public class DaemonHealthStats
implements Stoppable {
    private final DaemonRunningStats runningStats;
    private final ManagedScheduledExecutor scheduler;
    private final GarbageCollectionInfo gcInfo;
    private GarbageCollectionMonitor gcMonitor;

    public DaemonHealthStats(DaemonRunningStats runningStats, GarbageCollectorMonitoringStrategy strategy, ExecutorFactory executorFactory) {
        this.runningStats = runningStats;
        this.scheduler = executorFactory.createScheduled("Daemon health stats", 1);
        this.gcInfo = new GarbageCollectionInfo();
        this.gcMonitor = new DefaultGarbageCollectionMonitor(strategy, this.scheduler);
    }

    @VisibleForTesting
    DaemonHealthStats(DaemonRunningStats runningStats, GarbageCollectionInfo gcInfo, GarbageCollectionMonitor gcMonitor) {
        this.runningStats = runningStats;
        this.scheduler = null;
        this.gcInfo = gcInfo;
        this.gcMonitor = gcMonitor;
    }

    @VisibleForTesting
    public GarbageCollectionMonitor getGcMonitor() {
        return this.gcMonitor;
    }

    @Override
    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    public GarbageCollectionStats getHeapStats() {
        return this.gcMonitor.getHeapStats();
    }

    public GarbageCollectionStats getNonHeapStats() {
        return this.gcMonitor.getNonHeapStats();
    }

    public String getHealthInfo() {
        GarbageCollectionStats nonHeapStats;
        StringBuilder message = new StringBuilder();
        message.append(String.format("[uptime: %s, performance: %s%%", this.runningStats.getPrettyUpTime(), this.getCurrentPerformance()));
        GarbageCollectionStats heapStats = this.gcMonitor.getHeapStats();
        if (heapStats.isValid()) {
            message.append(String.format(Locale.ENGLISH, ", GC rate: %.2f/s", heapStats.getGcRate()));
            message.append(String.format(", heap usage: %s%% of %s", heapStats.getUsedPercent(), NumberUtil.formatBytes(heapStats.getMaxSizeInBytes())));
        }
        if ((nonHeapStats = this.gcMonitor.getNonHeapStats()).isValid()) {
            message.append(String.format(", non-heap usage: %s%% of %s", nonHeapStats.getUsedPercent(), NumberUtil.formatBytes(nonHeapStats.getMaxSizeInBytes())));
        }
        message.append("]");
        return message.toString();
    }

    private int getCurrentPerformance() {
        long collectionTime = this.gcInfo.getCollectionTime();
        long allBuildsTime = this.runningStats.getAllBuildsTime();
        if (collectionTime > 0L && collectionTime < allBuildsTime) {
            return 100 - NumberUtil.percentOf(collectionTime, allBuildsTime);
        }
        return 100;
    }
}

