/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;

public class ApiRequirementNativeDependencyResolver
implements NativeDependencyResolver {
    private final NativeDependencyResolver delegate;

    public ApiRequirementNativeDependencyResolver(NativeDependencyResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public void resolve(NativeBinaryResolveResult nativeBinaryResolveResult) {
        for (NativeBinaryRequirementResolveResult resolution : nativeBinaryResolveResult.getAllResolutions()) {
            String linkage = this.getLinkage(resolution);
            if (!"api".equals(linkage)) continue;
            resolution.setRequirement(new ApiAdaptedNativeLibraryRequirement(resolution.getRequirement()));
        }
        this.delegate.resolve(nativeBinaryResolveResult);
        for (NativeBinaryRequirementResolveResult resolution : nativeBinaryResolveResult.getAllResolutions()) {
            if (!(resolution.getRequirement() instanceof ApiAdaptedNativeLibraryRequirement)) continue;
            ApiAdaptedNativeLibraryRequirement adaptedRequirement = (ApiAdaptedNativeLibraryRequirement)resolution.getRequirement();
            resolution.setRequirement(adaptedRequirement.getOriginal());
            resolution.setNativeDependencySet(new ApiNativeDependencySet(resolution.getNativeDependencySet()));
        }
    }

    private String getLinkage(NativeBinaryRequirementResolveResult resolution) {
        if (resolution.getRequirement() == null) {
            return null;
        }
        return resolution.getRequirement().getLinkage();
    }

    private static class ApiNativeDependencySet
    implements NativeDependencySet {
        private final NativeDependencySet delegate;

        public ApiNativeDependencySet(NativeDependencySet delegate) {
            this.delegate = delegate;
        }

        @Override
        public FileCollection getIncludeRoots() {
            return this.delegate.getIncludeRoots();
        }

        @Override
        public FileCollection getLinkFiles() {
            return FileCollectionFactory.empty(this.delegate.getLinkFiles().toString());
        }

        @Override
        public FileCollection getRuntimeFiles() {
            return FileCollectionFactory.empty(this.delegate.getRuntimeFiles().toString());
        }
    }

    private static class ApiAdaptedNativeLibraryRequirement
    implements NativeLibraryRequirement {
        private final NativeLibraryRequirement original;

        public ApiAdaptedNativeLibraryRequirement(NativeLibraryRequirement original) {
            this.original = original;
        }

        public NativeLibraryRequirement getOriginal() {
            return this.original;
        }

        @Override
        public NativeLibraryRequirement withProjectPath(String projectPath) {
            return new ApiAdaptedNativeLibraryRequirement(this.original.withProjectPath(projectPath));
        }

        @Override
        public String getProjectPath() {
            return this.original.getProjectPath();
        }

        @Override
        public String getLibraryName() {
            return this.original.getLibraryName();
        }

        @Override
        public String getLinkage() {
            return null;
        }
    }
}

