/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.internal.jacoco.DefaultJacocoCoverageReport;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoCoverageReport;
import org.gradle.testing.jacoco.tasks.JacocoReport;

@Incubating
public abstract class JacocoReportAggregationPlugin
implements Plugin<Project> {
    public static final String JACOCO_AGGREGATION_CONFIGURATION_NAME = "jacocoAggregation";

    @Inject
    protected abstract JvmPluginServices getEcosystemUtilities();

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        project.getPluginManager().apply("jvm-ecosystem");
        project.getPluginManager().apply("jacoco");
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        Configuration jacocoAggregation = (Configuration)configurations.dependencyScope(JACOCO_AGGREGATION_CONFIGURATION_NAME).get();
        jacocoAggregation.setDescription("Collects project dependencies for purposes of JaCoCo coverage report aggregation");
        jacocoAggregation.setVisible(false);
        Configuration codeCoverageResultsConf = (Configuration)configurations.resolvable("aggregateCodeCoverageReportResults").get();
        codeCoverageResultsConf.setDescription("Resolvable configuration used to gather files for the JaCoCo coverage report aggregation via ArtifactViews, not intended to be used directly");
        codeCoverageResultsConf.extendsFrom(jacocoAggregation);
        codeCoverageResultsConf.setVisible(false);
        project.getPlugins().withType(JavaBasePlugin.class, plugin -> this.getEcosystemUtilities().configureAsRuntimeClasspath(codeCoverageResultsConf));
        ObjectFactory objects = project.getObjects();
        ArtifactView sourceDirectories = codeCoverageResultsConf.getIncoming().artifactView(view -> {
            view.withVariantReselection();
            view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
            this.getEcosystemUtilities().configureAsSources((HasConfigurableAttributes<?>)view);
        });
        ArtifactView classDirectories = codeCoverageResultsConf.getIncoming().artifactView(view -> {
            view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
            view.attributes(attributes -> attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, objects.named(LibraryElements.class, "classes")));
        });
        ReportingExtension reporting = project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(JacocoCoverageReport.class, DefaultJacocoCoverageReport.class);
        reporting.getReports().withType(JacocoCoverageReport.class).all(report2 -> report2.getReportTask().configure(task -> {
            ArtifactView executionData = codeCoverageResultsConf.getIncoming().artifactView(view -> {
                view.withVariantReselection();
                view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
                view.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.class, "verification"));
                    attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, report2.getTestType().map(tt -> objects.named(TestSuiteType.class, (String)tt)));
                    attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, objects.named(VerificationType.class, "jacoco-coverage"));
                    attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, "binary");
                });
            });
            this.configureReportTaskInputs((JacocoReport)task, classDirectories, sourceDirectories, executionData);
        }));
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            jacocoAggregation.getDependencies().add(project.getDependencyFactory().create(project));
            TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer<TestSuite> testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "CodeCoverageReport", JacocoCoverageReport.class, report2 -> report2.getTestType().convention(testSuite.getTestType())));
        });
    }

    private void configureReportTaskInputs(JacocoReport task, ArtifactView classDirectories, ArtifactView sourceDirectories, ArtifactView executionData) {
        task.getExecutionData().from(executionData.getFiles());
        task.getClassDirectories().from(classDirectories.getFiles());
        task.getSourceDirectories().from(sourceDirectories.getFiles());
    }
}

