/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.NonGradleCauseExceptionsHolder;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.AbstractConditionalExecution;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.ConditionalExecutionQueue;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.WorkerSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.ClassLoaderStructureProvider;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.DefaultClassLoaderWorkerSpec;
import org.gradle.workers.internal.DefaultProcessWorkerSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerSpec;
import org.gradle.workers.internal.FixedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.ForkedWorkerRequirement;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerExecutionQueueFactory;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

public class DefaultWorkerExecutor
implements WorkerExecutor {
    private final ConditionalExecutionQueue<DefaultWorkResult> executionQueue;
    private final WorkerFactory daemonWorkerFactory;
    private final WorkerFactory isolatedClassloaderWorkerFactory;
    private final WorkerFactory noIsolationWorkerFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClassLoaderStructureProvider classLoaderStructureProvider;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final Instantiator instantiator;
    private final IsolationScheme<WorkAction<?>, WorkParameters> isolationScheme = new IsolationScheme((Class)Cast.uncheckedCast(WorkAction.class), WorkParameters.class, WorkParameters.None.class);
    private final CachedClasspathTransformer classpathTransformer;
    private final File baseDir;

    public DefaultWorkerExecutor(WorkerFactory daemonWorkerFactory, WorkerFactory isolatedClassloaderWorkerFactory, WorkerFactory noIsolationWorkerFactory, JavaForkOptionsFactory forkOptionsFactory, WorkerThreadRegistry workerThreadRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, WorkerDirectoryProvider workerDirectoryProvider, WorkerExecutionQueueFactory workerExecutionQueueFactory, ClassLoaderStructureProvider classLoaderStructureProvider, ActionExecutionSpecFactory actionExecutionSpecFactory, Instantiator instantiator2, CachedClasspathTransformer classpathTransformer, File baseDir) {
        this.daemonWorkerFactory = daemonWorkerFactory;
        this.isolatedClassloaderWorkerFactory = isolatedClassloaderWorkerFactory;
        this.noIsolationWorkerFactory = noIsolationWorkerFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.executionQueue = workerExecutionQueueFactory.create();
        this.workerThreadRegistry = workerThreadRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.classLoaderStructureProvider = classLoaderStructureProvider;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        this.instantiator = instantiator2;
        this.classpathTransformer = classpathTransformer;
        this.baseDir = baseDir;
    }

    @Override
    public WorkQueue noIsolation() {
        return this.noIsolation(Actions.doNothing());
    }

    @Override
    public WorkQueue classLoaderIsolation() {
        return this.classLoaderIsolation(Actions.doNothing());
    }

    @Override
    public WorkQueue processIsolation() {
        return this.processIsolation(Actions.doNothing());
    }

    @Override
    public WorkQueue noIsolation(Action<? super WorkerSpec> action) {
        DefaultWorkerSpec spec = this.instantiator.newInstance(DefaultWorkerSpec.class, new Object[0]);
        action.execute(spec);
        return this.instantiator.newInstance(DefaultWorkQueue.class, this, spec, this.noIsolationWorkerFactory);
    }

    @Override
    public WorkQueue classLoaderIsolation(Action<? super ClassLoaderWorkerSpec> action) {
        DefaultClassLoaderWorkerSpec spec = this.instantiator.newInstance(DefaultClassLoaderWorkerSpec.class, new Object[0]);
        action.execute(spec);
        return this.instantiator.newInstance(DefaultWorkQueue.class, this, spec, this.isolatedClassloaderWorkerFactory);
    }

    @Override
    public WorkQueue processIsolation(Action<? super ProcessWorkerSpec> action) {
        DefaultProcessWorkerSpec spec = this.instantiator.newInstance(DefaultProcessWorkerSpec.class, this.forkOptionsFactory.newDecoratedJavaForkOptions());
        File defaultWorkingDir = spec.getForkOptions().getWorkingDir();
        File workingDirectory = this.workerDirectoryProvider.getWorkingDirectory();
        action.execute(spec);
        if (!defaultWorkingDir.equals(spec.getForkOptions().getWorkingDir())) {
            throw new IllegalArgumentException("Setting the working directory of a worker is not supported.");
        }
        spec.getForkOptions().setWorkingDir(workingDirectory);
        return this.instantiator.newInstance(DefaultWorkQueue.class, this, spec, this.daemonWorkerFactory);
    }

    private <T extends WorkParameters> AsyncWorkCompletion submitWork(Class<? extends WorkAction<T>> workActionClass, Action<? super T> parameterAction, WorkerSpec workerSpec, WorkerFactory workerFactory) {
        IsolatedParametersActionExecutionSpec<WorkParameters> spec;
        WorkParameters parameters;
        Class parameterType = this.isolationScheme.parameterTypeFor(workActionClass);
        WorkParameters workParameters = parameters = parameterType == null ? null : (WorkParameters)this.instantiator.newInstance(parameterType, new Object[0]);
        if (parameters != null) {
            parameterAction.execute(parameters);
        }
        String description = workActionClass.getName();
        WorkerRequirement workerRequirement = this.getWorkerRequirement(workActionClass, workerSpec, parameters);
        try {
            spec = this.actionExecutionSpecFactory.newIsolatedSpec(description, workActionClass, parameters, workerRequirement, false);
        }
        catch (Throwable t) {
            throw new WorkExecutionException(description, t);
        }
        return this.submitWork(spec, workerFactory, workerRequirement);
    }

    private AsyncWorkCompletion submitWork(IsolatedParametersActionExecutionSpec<?> spec, WorkerFactory workerFactory, WorkerRequirement workerRequirement) {
        this.checkIsManagedThread();
        BuildOperationRef currentBuildOperation = this.buildOperationExecutor.getCurrentOperation();
        WorkItemExecution execution = new WorkItemExecution(spec.getDisplayName(), () -> {
            try {
                BuildOperationAwareWorker worker = workerFactory.getWorker(workerRequirement);
                return worker.execute(spec, currentBuildOperation);
            }
            catch (Throwable t) {
                throw new WorkExecutionException(spec.getDisplayName(), t);
            }
        });
        this.executionQueue.submit(execution);
        this.asyncWorkTracker.registerWork(currentBuildOperation, execution);
        return execution;
    }

    private void checkIsManagedThread() {
        if (!this.workerThreadRegistry.isWorkerThread()) {
            throw new IllegalStateException("An attempt was made to submit work from a thread not managed by Gradle.  Work may only be submitted from a Gradle-managed thread.");
        }
    }

    @Override
    public void await() throws WorkerExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (this.asyncWorkTracker.hasUncompletedWork(currentOperation)) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, AsyncWorkTracker.ProjectLockRetention.RETAIN_PROJECT_LOCKS);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private void await(List<AsyncWorkCompletion> workItems) throws WorkExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (CollectionUtils.any(workItems, workItem -> !workItem.isComplete())) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, workItems, AsyncWorkTracker.ProjectLockRetention.RETAIN_PROJECT_LOCKS);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private WorkerExecutionException workerExecutionException(List<? extends Throwable> failures) {
        if (failures.size() == 1) {
            throw new WorkerExecutionException("There was a failure while executing work items", failures);
        }
        throw new WorkerExecutionException("There were multiple failures while executing work items", failures);
    }

    WorkerRequirement getWorkerRequirement(Class<?> executionClass, WorkerSpec configuration, WorkParameters parameters) {
        if (configuration instanceof ProcessWorkerSpec) {
            DaemonForkOptionsBuilder builder = new DaemonForkOptionsBuilder(this.forkOptionsFactory).keepAliveMode(KeepAliveMode.SESSION);
            ProcessWorkerSpec processConfiguration = (ProcessWorkerSpec)configuration;
            JavaForkOptionsInternal forkOptions = this.forkOptionsFactory.newJavaForkOptions();
            processConfiguration.getForkOptions().copyTo(forkOptions);
            forkOptions.setWorkingDir(this.workerDirectoryProvider.getWorkingDirectory());
            ClassPath isolatedFromChanges = this.classpathTransformer.transform(DefaultClassPath.of(processConfiguration.getClasspath()), CachedClasspathTransformer.StandardTransform.None);
            builder.javaForkOptions(forkOptions).withClassLoaderStructure(this.classLoaderStructureProvider.getWorkerProcessClassLoaderStructure(isolatedFromChanges.getAsFiles(), this.getParamClasses(executionClass, parameters)));
            return new ForkedWorkerRequirement(this.baseDir, builder.build());
        }
        if (configuration instanceof ClassLoaderWorkerSpec) {
            ClassLoaderWorkerSpec classLoaderConfiguration = (ClassLoaderWorkerSpec)configuration;
            ClassPath isolatedFromChanges = this.classpathTransformer.transform(DefaultClassPath.of(classLoaderConfiguration.getClasspath()), CachedClasspathTransformer.StandardTransform.None);
            return new IsolatedClassLoaderWorkerRequirement(this.baseDir, this.classLoaderStructureProvider.getInProcessClassLoaderStructure(isolatedFromChanges.getAsFiles(), this.getParamClasses(executionClass, parameters)));
        }
        return new FixedClassLoaderWorkerRequirement(this.baseDir, Thread.currentThread().getContextClassLoader());
    }

    private Class<?>[] getParamClasses(Class<?> actionClass, WorkParameters parameters) {
        if (parameters != null) {
            return new Class[]{actionClass, parameters.getClass()};
        }
        return new Class[]{actionClass};
    }

    @NotThreadSafe
    static class DefaultWorkQueue
    implements WorkQueue {
        private final DefaultWorkerExecutor workerExecutor;
        private final WorkerSpec spec;
        private final WorkerFactory workerFactory;
        private final List<AsyncWorkCompletion> workItems = Lists.newArrayList();

        public DefaultWorkQueue(DefaultWorkerExecutor workerExecutor, WorkerSpec spec, WorkerFactory workerFactory) {
            this.workerExecutor = workerExecutor;
            this.spec = spec;
            this.workerFactory = workerFactory;
        }

        @Override
        public <T extends WorkParameters> void submit(Class<? extends WorkAction<T>> workActionClass, Action<? super T> parameterAction) {
            this.workItems.add(this.workerExecutor.submitWork(workActionClass, parameterAction, this.spec, this.workerFactory));
        }

        @Override
        public void await() throws WorkerExecutionException {
            this.workerExecutor.await(this.workItems);
        }
    }

    private static class WorkItemExecution
    extends AbstractConditionalExecution<DefaultWorkResult>
    implements AsyncWorkCompletion {
        private final String description;

        public WorkItemExecution(String description, Callable<DefaultWorkResult> callable) {
            super(callable);
            this.description = description;
        }

        @Override
        public void waitForCompletion() {
            DefaultWorkResult result2 = (DefaultWorkResult)this.await();
            if (!result2.isSuccess()) {
                throw new WorkExecutionException(this.description, result2.getException());
            }
        }
    }

    @Contextual
    private static class WorkExecutionException
    extends RuntimeException
    implements NonGradleCauseExceptionsHolder {
        WorkExecutionException(String description, Throwable cause) {
            super(WorkExecutionException.toMessage(description), cause);
        }

        private static String toMessage(String description) {
            return "A failure occurred while executing " + description;
        }

        @Override
        public boolean hasCause(Class<?> type) {
            return type.isInstance(this.getCause());
        }
    }
}

