/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.CountingOutputStream;
import com.intellij.internal.statistic.eventLog.FileData;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BV\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\f0\t\u0012\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\f0\t\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0007H\u0014J\b\u0010'\u001a\u00020$H\u0016J\u0006\u0010(\u001a\u00020$J\b\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020*J\u0006\u0010-\u001a\u00020$R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006."}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFileWriter;", "Ljava/lang/AutoCloseable;", "dir", "Ljava/nio/file/Path;", "maxFileSize", "", "maxFileAge", "", "logFilePathProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Ljava/io/File;", "logFilesSupplier", "Ljava/util/function/Supplier;", "", "(Ljava/nio/file/Path;IJLkotlin/jvm/functions/Function1;Ljava/util/function/Supplier;)V", "maxFileSizeInBytes", "(Ljava/nio/file/Path;ILkotlin/jvm/functions/Function1;J)V", "closed", "", "currentFileData", "Lcom/intellij/internal/statistic/eventLog/FileData;", "getCurrentFileData", "()Lcom/intellij/internal/statistic/eventLog/FileData;", "currentFileData$delegate", "Lkotlin/Lazy;", "lastCriticalFailureTimestamp", "lock", "", "oldestExistingFile", "getOldestExistingFile", "()J", "setOldestExistingFile", "(J)V", "cleanUp", "", "cleanUpOldFiles", "oldestAcceptable", "close", "flush", "getActiveLogName", "", "log", "text", "rollOver", "intellij.platform.statistics"})
public class EventLogFileWriter
implements AutoCloseable {
    @NotNull
    private final Path dir;
    private final int maxFileSizeInBytes;
    @NotNull
    private final Function1<Path, File> logFilePathProvider;
    private final long maxFileAge;
    @NotNull
    private final Object lock;
    @NotNull
    private final Lazy currentFileData$delegate;
    private boolean closed;
    private long oldestExistingFile;
    @NotNull
    private Supplier<List<File>> logFilesSupplier;
    private long lastCriticalFailureTimestamp;

    public EventLogFileWriter(@NotNull Path dir, int maxFileSizeInBytes, @NotNull Function1<? super Path, ? extends File> logFilePathProvider2, long maxFileAge) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(logFilePathProvider2, (String)"logFilePathProvider");
        this.dir = dir;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.logFilePathProvider = logFilePathProvider2;
        this.maxFileAge = maxFileAge;
        this.lock = new Object();
        this.currentFileData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FileData>(this){
            final /* synthetic */ EventLogFileWriter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FileData invoke() {
                return new FileData(EventLogFileWriter.access$getDir$p(this.this$0), (Function1<? super Path, ? extends File>)EventLogFileWriter.access$getLogFilePathProvider$p(this.this$0));
            }
        }));
        this.oldestExistingFile = -1L;
        this.logFilesSupplier = () -> EventLogFileWriter.logFilesSupplier$lambda$0(this);
        this.lastCriticalFailureTimestamp = -1L;
    }

    public /* synthetic */ EventLogFileWriter(Path path, int n, Function1 function1, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            l = 60480000L;
        }
        this(path, n, (Function1<? super Path, ? extends File>)function1, l);
    }

    private final FileData getCurrentFileData() {
        Lazy lazy = this.currentFileData$delegate;
        return (FileData)lazy.getValue();
    }

    protected final long getOldestExistingFile() {
        return this.oldestExistingFile;
    }

    protected final void setOldestExistingFile(long l) {
        this.oldestExistingFile = l;
    }

    @TestOnly
    public EventLogFileWriter(@NotNull Path dir, int maxFileSize, long maxFileAge, @NotNull Function1<? super Path, ? extends File> logFilePathProvider2, @NotNull Supplier<List<File>> logFilesSupplier) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(logFilePathProvider2, (String)"logFilePathProvider");
        Intrinsics.checkNotNullParameter(logFilesSupplier, (String)"logFilesSupplier");
        this(dir, maxFileSize, logFilePathProvider2, maxFileAge);
        this.logFilesSupplier = logFilesSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getActiveLogName() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.getCurrentFileData().getLogFile().exists()) {
                this.rollOver();
            }
            String string = this.getCurrentFileData().getLogFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = this.lock;
        synchronized (object) {
            block7: {
                boolean bl = false;
                try {
                    if (this.closed) {
                        throw new IllegalStateException("Attempt to use closed FUS log");
                    }
                    CountingOutputStream outputStream = this.getCurrentFileData().getCountingOutputStream();
                    byte[] byArray = text.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    outputStream.write(byArray);
                    outputStream.write(10);
                    if (outputStream.getBytesWritten() > (long)this.maxFileSizeInBytes) {
                        this.rollOver();
                        this.cleanUpOldFiles();
                    }
                }
                catch (IOException e) {
                    long currentTimeMillis = System.currentTimeMillis();
                    if (this.lastCriticalFailureTimestamp == -1L || currentTimeMillis - this.lastCriticalFailureTimestamp >= 10000L) break block7;
                    System.err.println("Failed to write to FUS log");
                    this.lastCriticalFailureTimestamp = currentTimeMillis;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollOver() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.getCurrentFileData().close();
            this.getCurrentFileData().initialize();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                this.getCurrentFileData().close();
                this.closed = true;
            }
            catch (IOException e) {
                System.err.println("Failed to close FUS log");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    protected void cleanUpOldFiles() {
        long oldestAcceptable = System.currentTimeMillis() - this.maxFileAge;
        if (this.oldestExistingFile != -1L && oldestAcceptable < this.oldestExistingFile) {
            return;
        }
        this.cleanUpOldFiles(oldestAcceptable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpOldFiles(long oldestAcceptable) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            List<File> list = this.logFilesSupplier.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            List<File> logs = list;
            if (logs.isEmpty()) {
                return;
            }
            String activeLog = this.getActiveLogName();
            long oldestFile = -1L;
            for (File file : logs) {
                if (StringUtil.equals((CharSequence)file.getName(), (CharSequence)activeLog)) continue;
                long lastModified = file.lastModified();
                if (lastModified < oldestAcceptable) {
                    if (file.delete()) continue;
                    System.err.println("Failed deleting old FUS file " + file);
                    continue;
                }
                if (lastModified >= oldestFile && oldestFile != -1L) continue;
                oldestFile = lastModified;
            }
            this.oldestExistingFile = oldestFile;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanUp() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.getCurrentFileData().close();
            List<File> list = this.logFilesSupplier.get();
            Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
            List<File> files = list;
            for (File file : files) {
                if (file.delete()) continue;
                System.err.println("Failed deleting old FUS file " + file);
            }
            this.rollOver();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.getCurrentFileData().getCountingOutputStream().flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final List logFilesSupplier$lambda$0(EventLogFileWriter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] files = this$0.dir.toFile().listFiles();
        return files == null || files.length == 0 ? CollectionsKt.emptyList() : ArraysKt.toList((Object[])files);
    }

    public static final /* synthetic */ Path access$getDir$p(EventLogFileWriter $this) {
        return $this.dir;
    }

    public static final /* synthetic */ Function1 access$getLogFilePathProvider$p(EventLogFileWriter $this) {
        return $this.logFilePathProvider;
    }
}

