/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.fus;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/MachineIdManager;", "", "()V", "IOREG_COMMAND_TIMEOUT_MS", "", "linuxMachineIdPaths", "", "", "macMachineIdPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getAnonymizedMachineId", "purpose", "salt", "getLinuxMachineId", "getMacOsMachineId", "getMachineId", "intellij.platform.statistics"})
public final class MachineIdManager {
    @NotNull
    public static final MachineIdManager INSTANCE = new MachineIdManager();
    private static final int IOREG_COMMAND_TIMEOUT_MS = 2000;
    private static final Pattern macMachineIdPattern = Pattern.compile("\"IOPlatformUUID\"\\s*=\\s*\"(?<machineId>.*)\"");
    @NotNull
    private static final List<String> linuxMachineIdPaths;

    private MachineIdManager() {
    }

    @Nullable
    public final String getAnonymizedMachineId(@NotNull String purpose, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        if (((CharSequence)purpose).length() == 0) {
            throw new IllegalArgumentException("Argument [purpose] should not be empty.");
        }
        String string = this.getMachineId();
        if (string == null) {
            return null;
        }
        String machineId = string;
        String string2 = System.getProperty("user.name") + purpose + salt;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return EventLogConfiguration.Companion.hashSha256(byArray, machineId);
    }

    private final String getMachineId() {
        String string;
        try {
            string = SystemInfo.isWindows ? Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Cryptography", (String)"MachineGuid") : (SystemInfo.isMac ? this.getMacOsMachineId() : (SystemInfo.isLinux ? this.getLinuxMachineId() : null));
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    private final String getLinuxMachineId() {
        for (String machineIdPath : linuxMachineIdPaths) {
            try {
                String machineId = Files.readString(Paths.get(machineIdPath, new String[0]));
                CharSequence charSequence = machineId;
                if (charSequence == null || charSequence.length() == 0) continue;
                Intrinsics.checkNotNull((Object)machineId);
                return ((Object)StringsKt.trim((CharSequence)machineId)).toString();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private final String getMacOsMachineId() {
        Matcher matcher;
        String[] stringArray = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)2000);
        if (processOutput.getExitCode() == 0 && (matcher = macMachineIdPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)processOutput.getStdout(), (long)1000L))).find()) {
            return matcher.group("machineId");
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"/etc/machine-id", "/var/lib/dbus/machine-id"};
        linuxMachineIdPaths = CollectionsKt.listOf((Object[])objectArray);
    }
}

