/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.license;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.LicensingFacade;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.license.QodanaLicenseChecker;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.Utils_time_loggerKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\b\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"EAP_LICENSE_DURATION", "", "checkCommunityLicense", "", "checkCommunityProductCode", "checkLicense", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "checkUltimateLicense", "isEapLicensing", "", "printLicenseInfo", "licenseType", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nlicenseCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 licenseCheck.kt\norg/jetbrains/qodana/license/LicenseCheckKt\n+ 2 QodanaLicenseChecker.kt\norg/jetbrains/qodana/license/QodanaLicenseChecker\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n110#2:101\n213#2:102\n111#2:103\n30#2:104\n112#2,3:105\n32#2:108\n131#2:109\n213#2:110\n132#2:111\n133#2,11:114\n174#2,14:125\n41#2:139\n107#2:140\n188#2,22:141\n145#2,8:163\n153#2,9:172\n162#2,2:183\n31#2:185\n164#2,3:186\n155#2:190\n117#2:191\n33#2:192\n118#2:193\n33#2:194\n124#2:195\n215#2:196\n125#2,4:197\n119#2,3:201\n37#3,2:112\n10#4:171\n179#5,2:181\n1#6:189\n1855#7,2:204\n*S KotlinDebug\n*F\n+ 1 licenseCheck.kt\norg/jetbrains/qodana/license/LicenseCheckKt\n*L\n38#1:101\n38#1:102\n38#1:103\n38#1:104\n38#1:105,3\n38#1:108\n38#1:109\n38#1:110\n38#1:111\n38#1:114,11\n38#1:125,14\n38#1:139\n38#1:140\n38#1:141,22\n38#1:163,8\n38#1:172,9\n38#1:183,2\n38#1:185\n38#1:186,3\n38#1:190\n38#1:191\n38#1:192\n38#1:193\n38#1:194\n38#1:195\n38#1:196\n38#1:197,4\n38#1:201,3\n38#1:112,2\n38#1:171\n38#1:181,2\n38#1:189\n69#1:204,2\n*E\n"})
public final class LicenseCheckKt {
    private static final int EAP_LICENSE_DURATION = 60;

    @NotNull
    public static final QodanaLicenseType checkLicense() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            LicenseCheckKt.checkCommunityProductCode();
            LicenseCheckKt.checkCommunityLicense();
            return QodanaLicenseType.COMMUNITY;
        }
        return LicenseCheckKt.checkUltimateLicense();
    }

    private static final void checkCommunityProductCode() {
        ApplicationInfo.getInstance().getFullVersion();
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String productCode = string;
        if (QodanaKt.getCOMMUNITY_PRODUCT_CODES().contains(productCode)) {
            return;
        }
        Utils_time_loggerKt.dumpThreads("Community plan on non-community linter", "license-check-thread-dump-" + System.currentTimeMillis() + ".txt");
    }

    /*
     * WARNING - void declaration
     */
    private static final QodanaLicenseType checkUltimateLicense() {
        QodanaLicenseType qodanaLicenseType;
        block31: {
            Object object;
            Object object2;
            QodanaLicenseChecker this_$iv = QodanaLicenseChecker.INSTANCE;
            boolean $i$f$getLicenseType = false;
            QodanaLicenseChecker this_$iv$iv = this_$iv;
            boolean $i$f$runCatchingOrNone = false;
            try {
                QodanaLicenseType qodanaLicenseType2;
                block32: {
                    Object object3;
                    block36: {
                        block35: {
                            boolean bl = false;
                            object3 = LicensingFacade.getInstance();
                            if (object3 == null) break block35;
                            QodanaLicenseChecker this_$iv$iv2 = QodanaLicenseChecker.INSTANCE;
                            boolean $i$f$getPRODUCT_CODE = false;
                            if ((object3 = object3.getConfirmationStamp("QDL")) != null) break block36;
                        }
                        qodanaLicenseType = QodanaLicenseType.NONE;
                        break block31;
                    }
                    Object object4 = object3;
                    Intrinsics.checkNotNull((Object)object4);
                    Object cstamp$iv = object4;
                    QodanaLicenseChecker this_$iv$iv3 = QodanaLicenseChecker.INSTANCE;
                    boolean $i$f$getKEY_PREFIX22 = false;
                    if (StringsKt.startsWith$default((String)cstamp$iv, (String)"key:", (boolean)false, (int)2, null)) {
                        this_$iv$iv3 = QodanaLicenseChecker.INSTANCE;
                        Object $i$f$getKEY_PREFIX22 = cstamp$iv;
                        QodanaLicenseChecker this_$iv$iv232 = QodanaLicenseChecker.INSTANCE;
                        boolean $i$f$getKEY_PREFIX3 = false;
                        int this_$iv$iv232 = "key:".length();
                        String string = ((String)$i$f$getKEY_PREFIX22).substring(this_$iv$iv232);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        $i$f$getKEY_PREFIX22 = string;
                        boolean $i$f$getLicenseType2 = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        boolean $i$f$runCatchingOrNone2 = false;
                        try {
                            boolean bl;
                            X509Certificate x509Certificate;
                            byte[] intermediateCertsBytes$iv$iv$iv;
                            Signature signature;
                            Signature sig$iv$iv;
                            String signatureBase64$iv$iv;
                            String licensePartBase64$iv$iv;
                            block33: {
                                void this_$iv$iv$iv;
                                void key$iv$iv;
                                boolean bl2 = false;
                                String[] stringArray = new String[]{"-"};
                                Collection $this$toTypedArray$iv$iv$iv = StringsKt.split$default((CharSequence)((CharSequence)key$iv$iv), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv$iv$iv = $this$toTypedArray$iv$iv$iv;
                                String[] licenseParts$iv$iv = thisCollection$iv$iv$iv.toArray(new String[0]);
                                if (licenseParts$iv$iv.length != 4) {
                                    qodanaLicenseType2 = QodanaLicenseType.NONE;
                                    break block32;
                                }
                                licensePartBase64$iv$iv = licenseParts$iv$iv[1];
                                signatureBase64$iv$iv = licenseParts$iv$iv[2];
                                String certBase64$iv$iv = licenseParts$iv$iv[3];
                                String string2 = "rsa".toUpperCase();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase()");
                                sig$iv$iv = Signature.getInstance("SHA1with" + string2);
                                QodanaLicenseChecker qodanaLicenseChecker = QodanaLicenseChecker.INSTANCE;
                                Base64.Decoder decoder = Base64.getMimeDecoder();
                                byte[] byArray = certBase64$iv$iv.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                byte[] byArray2 = decoder.decode(byArray);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
                                byte[] byArray3 = byArray2;
                                Collection collection = SetsKt.emptySet();
                                boolean bl3 = false;
                                signature = sig$iv$iv;
                                boolean $i$f$createCertificate = false;
                                void var24_41 = this_$iv$iv$iv;
                                try {
                                    void certBytes$iv$iv$iv;
                                    Object $this$createCertificate_u24lambda_u244$iv$iv$iv = var24_41;
                                    boolean bl4 = false;
                                    CertificateFactory x509factory$iv$iv$iv = CertificateFactory.getInstance("X.509");
                                    Certificate certificate = x509factory$iv$iv$iv.generateCertificate(new ByteArrayInputStream((byte[])certBytes$iv$iv$iv));
                                    Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                                    X509Certificate cert$iv$iv$iv = (X509Certificate)certificate;
                                    Collection allCerts$iv$iv$iv = new HashSet();
                                    allCerts$iv$iv$iv.add(cert$iv$iv$iv);
                                    for (byte[] byArray4 : intermediateCertsBytes$iv$iv$iv) {
                                        allCerts$iv$iv$iv.add(x509factory$iv$iv$iv.generateCertificate(new ByteArrayInputStream(byArray4)));
                                    }
                                    X509CertSelector selector$iv$iv$iv = new X509CertSelector();
                                    selector$iv$iv$iv.setCertificate(cert$iv$iv$iv);
                                    void this_$iv$iv$iv$iv = $this$createCertificate_u24lambda_u244$iv$iv$iv;
                                    boolean $i$f$getROOT_CERTIFICATES = false;
                                    List list2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Sequence<? extends String>>, Continuation<? super Unit>, Object>(null){
                                        int label;
                                        private /* synthetic */ Object L$0;

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    $this$sequence = (SequenceScope)this.L$0;
                                                    this.L$0 = $this$sequence;
                                                    this.label = 1;
                                                    v0 = $this$sequence.yield((Object)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(null){
                                                        int label;
                                                        private /* synthetic */ Object L$0;

                                                        /*
                                                         * Unable to fully structure code
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 1;
                                                                    v0 = $this$sequence.yield((Object)"-----BEGIN CERTIFICATE-----", (Continuation)this);
                                                                    if (v0 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl16
                                                                }
                                                                case 1: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v0 = $result;
lbl16:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 2;
                                                                    v1 = $this$sequence.yield((Object)"MIIFOzCCAyOgAwIBAgIJANJssYOyg3nhMA0GCSqGSIb3DQEBCwUAMBgxFjAUBgNV", (Continuation)this);
                                                                    if (v1 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl26
                                                                }
                                                                case 2: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v1 = $result;
lbl26:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 3;
                                                                    v2 = $this$sequence.yield((Object)"BAMMDUpldFByb2ZpbGUgQ0EwHhcNMTUxMDAyMTEwMDU2WhcNNDUxMDI0MTEwMDU2", (Continuation)this);
                                                                    if (v2 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl36
                                                                }
                                                                case 3: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v2 = $result;
lbl36:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 4;
                                                                    v3 = $this$sequence.yield((Object)"WjAYMRYwFAYDVQQDDA1KZXRQcm9maWxlIENBMIICIjANBgkqhkiG9w0BAQEFAAOC", (Continuation)this);
                                                                    if (v3 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl46
                                                                }
                                                                case 4: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v3 = $result;
lbl46:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 5;
                                                                    v4 = $this$sequence.yield((Object)"Ag8AMIICCgKCAgEA0tQuEA8784NabB1+T2XBhpB+2P1qjewHiSajAV8dfIeWJOYG", (Continuation)this);
                                                                    if (v4 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl56
                                                                }
                                                                case 5: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v4 = $result;
lbl56:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 6;
                                                                    v5 = $this$sequence.yield((Object)"y+ShXiuedj8rL8VCdU+yH7Ux/6IvTcT3nwM/E/3rjJIgLnbZNerFm15Eez+XpWBl", (Continuation)this);
                                                                    if (v5 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl66
                                                                }
                                                                case 6: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v5 = $result;
lbl66:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 7;
                                                                    v6 = $this$sequence.yield((Object)"m5fDBJhEGhPc89Y31GpTzW0vCLmhJ44XwvYPntWxYISUrqeR3zoUQrCEp1C6mXNX", (Continuation)this);
                                                                    if (v6 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl76
                                                                }
                                                                case 7: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v6 = $result;
lbl76:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 8;
                                                                    v7 = $this$sequence.yield((Object)"EpqIGIVbJ6JVa/YI+pwbfuP51o0ZtF2rzvgfPzKtkpYQ7m7KgA8g8ktRXyNrz8bo", (Continuation)this);
                                                                    if (v7 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl86
                                                                }
                                                                case 8: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v7 = $result;
lbl86:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 9;
                                                                    v8 = $this$sequence.yield((Object)"iwg7RRPeqs4uL/RK8d2KLpgLqcAB9WDpcEQzPWegbDrFO1F3z4UVNH6hrMfOLGVA", (Continuation)this);
                                                                    if (v8 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl96
                                                                }
                                                                case 9: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v8 = $result;
lbl96:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 10;
                                                                    v9 = $this$sequence.yield((Object)"xoiQhNFhZj6RumBXlPS0rmCOCkUkWrDr3l6Z3spUVgoeea+QdX682j6t7JnakaOw", (Continuation)this);
                                                                    if (v9 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl106
                                                                }
                                                                case 10: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v9 = $result;
lbl106:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 11;
                                                                    v10 = $this$sequence.yield((Object)"jzwY777SrZoi9mFFpLVhfb4haq4IWyKSHR3/0BlWXgcgI6w6LXm+V+ZgLVDON52F", (Continuation)this);
                                                                    if (v10 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl116
                                                                }
                                                                case 11: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v10 = $result;
lbl116:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 12;
                                                                    v11 = $this$sequence.yield((Object)"LcxnfftaBJz2yclEwBohq38rYEpb+28+JBvHJYqcZRaldHYLjjmb8XXvf2MyFeXr", (Continuation)this);
                                                                    if (v11 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl126
                                                                }
                                                                case 12: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v11 = $result;
lbl126:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 13;
                                                                    v12 = $this$sequence.yield((Object)"SopYkdzCvzmiEJAewrEbPUaTllogUQmnv7Rv9sZ9jfdJ/cEn8e7GSGjHIbnjV2ZM", (Continuation)this);
                                                                    if (v12 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl136
                                                                }
                                                                case 13: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v12 = $result;
lbl136:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 14;
                                                                    v13 = $this$sequence.yield((Object)"Q9vTpWjvsT/cqatbxzdBo/iEg5i9yohOC9aBfpIHPXFw+fEj7VLvktxZY6qThYXR", (Continuation)this);
                                                                    if (v13 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl146
                                                                }
                                                                case 14: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v13 = $result;
lbl146:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 15;
                                                                    v14 = $this$sequence.yield((Object)"Rus1WErPgxDzVpNp+4gXovAYOxsZak5oTV74ynv1aQ93HSndGkKUE/qA/JECAwEA", (Continuation)this);
                                                                    if (v14 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl156
                                                                }
                                                                case 15: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v14 = $result;
lbl156:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 16;
                                                                    v15 = $this$sequence.yield((Object)"AaOBhzCBhDAdBgNVHQ4EFgQUo562SGdCEjZBvW3gubSgUouX8bMwSAYDVR0jBEEw", (Continuation)this);
                                                                    if (v15 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl166
                                                                }
                                                                case 16: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v15 = $result;
lbl166:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 17;
                                                                    v16 = $this$sequence.yield((Object)"P4AUo562SGdCEjZBvW3gubSgUouX8bOhHKQaMBgxFjAUBgNVBAMMDUpldFByb2Zp", (Continuation)this);
                                                                    if (v16 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl176
                                                                }
                                                                case 17: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v16 = $result;
lbl176:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 18;
                                                                    v17 = $this$sequence.yield((Object)"bGUgQ0GCCQDSbLGDsoN54TAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq", (Continuation)this);
                                                                    if (v17 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl186
                                                                }
                                                                case 18: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v17 = $result;
lbl186:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 19;
                                                                    v18 = $this$sequence.yield((Object)"hkiG9w0BAQsFAAOCAgEAjrPAZ4xC7sNiSSqh69s3KJD3Ti4etaxcrSnD7r9rJYpK", (Continuation)this);
                                                                    if (v18 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl196
                                                                }
                                                                case 19: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v18 = $result;
lbl196:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 20;
                                                                    v19 = $this$sequence.yield((Object)"BMviCKZRKFbLv+iaF5JK5QWuWdlgA37ol7mLeoF7aIA9b60Ag2OpgRICRG79QY7o", (Continuation)this);
                                                                    if (v19 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl206
                                                                }
                                                                case 20: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v19 = $result;
lbl206:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 21;
                                                                    v20 = $this$sequence.yield((Object)"uLviF/yRMqm6yno7NYkGLd61e5Huu+BfT459MWG9RVkG/DY0sGfkyTHJS5xrjBV6", (Continuation)this);
                                                                    if (v20 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl216
                                                                }
                                                                case 21: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v20 = $result;
lbl216:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 22;
                                                                    v21 = $this$sequence.yield((Object)"hjLG0lf3orwqOlqSNRmhvn9sMzwAP3ILLM5VJC5jNF1zAk0jrqKz64vuA8PLJZlL", (Continuation)this);
                                                                    if (v21 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl226
                                                                }
                                                                case 22: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v21 = $result;
lbl226:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 23;
                                                                    v22 = $this$sequence.yield((Object)"S9TZJIYwdesCGfnN2AETvzf3qxLcGTF038zKOHUMnjZuFW1ba/12fDK5GJ4i5y+n", (Continuation)this);
                                                                    if (v22 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl236
                                                                }
                                                                case 23: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v22 = $result;
lbl236:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 24;
                                                                    v23 = $this$sequence.yield((Object)"fDWVZVUDYOPUixEZ1cwzmf9Tx3hR8tRjMWQmHixcNC8XEkVfztID5XeHtDeQ+uPk", (Continuation)this);
                                                                    if (v23 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl246
                                                                }
                                                                case 24: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v23 = $result;
lbl246:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 25;
                                                                    v24 = $this$sequence.yield((Object)"X+jTDXbRb+77BP6n41briXhm57AwUI3TqqJFvoiFyx5JvVWG3ZqlVaeU/U9e0gxn", (Continuation)this);
                                                                    if (v24 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl256
                                                                }
                                                                case 25: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v24 = $result;
lbl256:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 26;
                                                                    v25 = $this$sequence.yield((Object)"8qyR+ZA3BGbtUSDDs8LDnE67URzK+L+q0F2BC758lSPNB2qsJeQ63bYyzf0du3wB", (Continuation)this);
                                                                    if (v25 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl266
                                                                }
                                                                case 26: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v25 = $result;
lbl266:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 27;
                                                                    v26 = $this$sequence.yield((Object)"/gb2+xJijAvscU3KgNpkxfGklvJD/oDUIqZQAnNcHe7QEf8iG2WqaMJIyXZlW3me", (Continuation)this);
                                                                    if (v26 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl276
                                                                }
                                                                case 27: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v26 = $result;
lbl276:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 28;
                                                                    v27 = $this$sequence.yield((Object)"0rn+cgvxHPt6N4EBh5GgNZR4l0eaFEV+fxVsydOQYo1RIyFMXtafFBqQl6DDxujl", (Continuation)this);
                                                                    if (v27 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl286
                                                                }
                                                                case 28: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v27 = $result;
lbl286:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 29;
                                                                    v28 = $this$sequence.yield((Object)"FeU3FZ+Bcp12t7dlM4E0/sS1XdL47CfGVj4Bp+/VbF862HmkAbd7shs7sDQkHbU=", (Continuation)this);
                                                                    if (v28 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl296
                                                                }
                                                                case 29: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v28 = $result;
lbl296:
                                                                    // 2 sources

                                                                    this.L$0 = null;
                                                                    this.label = 30;
                                                                    v29 = $this$sequence.yield((Object)"-----END CERTIFICATE-----", (Continuation)this);
                                                                    if (v29 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl305
                                                                }
                                                                case 30: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v29 = $result;
lbl305:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                            var3_3.L$0 = value2;
                                                            return (Continuation)var3_3;
                                                        }

                                                        @Nullable
                                                        public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    })), (Continuation)this);
                                                    if (v0 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl16
                                                }
                                                case 1: {
                                                    $this$sequence = (SequenceScope)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl16:
                                                    // 2 sources

                                                    this.L$0 = null;
                                                    this.label = 2;
                                                    v1 = $this$sequence.yield((Object)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(null){
                                                        int label;
                                                        private /* synthetic */ Object L$0;

                                                        /*
                                                         * Unable to fully structure code
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 1;
                                                                    v0 = $this$sequence.yield((Object)"-----BEGIN CERTIFICATE-----", (Continuation)this);
                                                                    if (v0 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl16
                                                                }
                                                                case 1: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v0 = $result;
lbl16:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 2;
                                                                    v1 = $this$sequence.yield((Object)"MIIFTDCCAzSgAwIBAgIJAMCrW9HV+hjZMA0GCSqGSIb3DQEBCwUAMB0xGzAZBgNV", (Continuation)this);
                                                                    if (v1 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl26
                                                                }
                                                                case 2: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v1 = $result;
lbl26:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 3;
                                                                    v2 = $this$sequence.yield((Object)"BAMMEkxpY2Vuc2UgU2VydmVycyBDQTAgFw0xNjEwMTIxNDMwNTRaGA8yMTE2MTIy", (Continuation)this);
                                                                    if (v2 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl36
                                                                }
                                                                case 3: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v2 = $result;
lbl36:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 4;
                                                                    v3 = $this$sequence.yield((Object)"NzE0MzA1NFowHTEbMBkGA1UEAwwSTGljZW5zZSBTZXJ2ZXJzIENBMIICIjANBgkq", (Continuation)this);
                                                                    if (v3 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl46
                                                                }
                                                                case 4: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v3 = $result;
lbl46:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 5;
                                                                    v4 = $this$sequence.yield((Object)"hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAoT7LvHj3JKK2pgc5f02z+xEiJDcvlBi6", (Continuation)this);
                                                                    if (v4 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl56
                                                                }
                                                                case 5: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v4 = $result;
lbl56:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 6;
                                                                    v5 = $this$sequence.yield((Object)"fIwrg/504UaMx3xWXAE5CEPelFty+QPRJnTNnSxqKQQmg2s/5tMJpL9lzGwXaV7a", (Continuation)this);
                                                                    if (v5 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl66
                                                                }
                                                                case 6: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v5 = $result;
lbl66:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 7;
                                                                    v6 = $this$sequence.yield((Object)"rrcsEDbzV4el5mIXUnk77Bm/QVv48s63iQqUjVmvjQt9SWG2J7+h6X3ICRvF1sQB", (Continuation)this);
                                                                    if (v6 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl76
                                                                }
                                                                case 7: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v6 = $result;
lbl76:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 8;
                                                                    v7 = $this$sequence.yield((Object)"yeat/cO7tkpz1aXXbvbAws7/3dXLTgAZTAmBXWNEZHVUTcwSg2IziYxL8HRFOH0+", (Continuation)this);
                                                                    if (v7 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl86
                                                                }
                                                                case 8: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v7 = $result;
lbl86:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 9;
                                                                    v8 = $this$sequence.yield((Object)"GMBhHqa0ySmF1UTnTV4atIXrvjpABsoUvGxw+qOO2qnwe6ENEFWFz1a7pryVOHXg", (Continuation)this);
                                                                    if (v8 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl96
                                                                }
                                                                case 9: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v8 = $result;
lbl96:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 10;
                                                                    v9 = $this$sequence.yield((Object)"P+4JyPkI1hdAhAqT2kOKbTHvlXDMUaxAPlriOVw+vaIjIVlNHpBGhqTj1aqfJpLj", (Continuation)this);
                                                                    if (v9 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl106
                                                                }
                                                                case 10: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v9 = $result;
lbl106:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 11;
                                                                    v10 = $this$sequence.yield((Object)"qfDFcuqQSI4O1W5tVPRNFrjr74nDwLDZnOF+oSy4E1/WhL85FfP3IeQAIHdswNMJ", (Continuation)this);
                                                                    if (v10 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl116
                                                                }
                                                                case 11: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v10 = $result;
lbl116:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 12;
                                                                    v11 = $this$sequence.yield((Object)"y+RdkPZCfXzSUhBKRtiM+yjpIn5RBY+8z+9yeGocoxPf7l0or3YF4GUpud202zgy", (Continuation)this);
                                                                    if (v11 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl126
                                                                }
                                                                case 12: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v11 = $result;
lbl126:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 13;
                                                                    v12 = $this$sequence.yield((Object)"Y3sJqEsZksB750M0hx+vMMC9GD5nkzm9BykJS25hZOSsRNhX9InPWYYIi6mFm8QA", (Continuation)this);
                                                                    if (v12 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl136
                                                                }
                                                                case 13: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v12 = $result;
lbl136:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 14;
                                                                    v13 = $this$sequence.yield((Object)"2Dnv8wxAwt2tDNgqa0v/N8OxHglPcK/VO9kXrUBtwCIfZigO//N3hqzfRNbTv/ZO", (Continuation)this);
                                                                    if (v13 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl146
                                                                }
                                                                case 14: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v13 = $result;
lbl146:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 15;
                                                                    v14 = $this$sequence.yield((Object)"k9lArqGtcu1hSa78U4fuu7lIHi+u5rgXbB6HMVT3g5GQ1L9xxT1xad76k2EGEi3F", (Continuation)this);
                                                                    if (v14 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl156
                                                                }
                                                                case 15: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v14 = $result;
lbl156:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 16;
                                                                    v15 = $this$sequence.yield((Object)"9B+tSrvru70CAwEAAaOBjDCBiTAdBgNVHQ4EFgQUpsRiEz+uvh6TsQqurtwXMd4J", (Continuation)this);
                                                                    if (v15 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl166
                                                                }
                                                                case 16: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v15 = $result;
lbl166:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 17;
                                                                    v16 = $this$sequence.yield((Object)"8VEwTQYDVR0jBEYwRIAUpsRiEz+uvh6TsQqurtwXMd4J8VGhIaQfMB0xGzAZBgNV", (Continuation)this);
                                                                    if (v16 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl176
                                                                }
                                                                case 17: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v16 = $result;
lbl176:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 18;
                                                                    v17 = $this$sequence.yield((Object)"BAMMEkxpY2Vuc2UgU2VydmVycyBDQYIJAMCrW9HV+hjZMAwGA1UdEwQFMAMBAf8w", (Continuation)this);
                                                                    if (v17 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl186
                                                                }
                                                                case 18: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v17 = $result;
lbl186:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 19;
                                                                    v18 = $this$sequence.yield((Object)"CwYDVR0PBAQDAgEGMA0GCSqGSIb3DQEBCwUAA4ICAQCJ9+GQWvBS3zsgPB+1PCVc", (Continuation)this);
                                                                    if (v18 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl196
                                                                }
                                                                case 19: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v18 = $result;
lbl196:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 20;
                                                                    v19 = $this$sequence.yield((Object)"oG6FY87N6nb3ZgNTHrUMNYdo7FDeol2DSB4wh/6rsP9Z4FqVlpGkckB+QHCvqU+d", (Continuation)this);
                                                                    if (v19 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl206
                                                                }
                                                                case 20: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v19 = $result;
lbl206:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 21;
                                                                    v20 = $this$sequence.yield((Object)"rYPe6QWHIb1kE8ftTnwapj/ZaBtF80NWUfYBER/9c6To5moW63O7q6cmKgaGk6zv", (Continuation)this);
                                                                    if (v20 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl216
                                                                }
                                                                case 21: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v20 = $result;
lbl216:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 22;
                                                                    v21 = $this$sequence.yield((Object)"St2IhwNdTX0Q5cib9ytE4XROeVwPUn6RdU/+AVqSOspSMc1WQxkPVGRF7HPCoGhd", (Continuation)this);
                                                                    if (v21 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl226
                                                                }
                                                                case 22: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v21 = $result;
lbl226:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 23;
                                                                    v22 = $this$sequence.yield((Object)"vqebbYhpahiMWfClEuv1I37gJaRtsoNpx3f/jleoC/vDvXjAznfO497YTf/GgSM2", (Continuation)this);
                                                                    if (v22 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl236
                                                                }
                                                                case 23: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v22 = $result;
lbl236:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 24;
                                                                    v23 = $this$sequence.yield((Object)"LCnVtpPQQ2vQbOfTjaBYO2MpibQlYpbkbjkd5ZcO5U5PGrQpPFrWcylz7eUC3c05", (Continuation)this);
                                                                    if (v23 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl246
                                                                }
                                                                case 24: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v23 = $result;
lbl246:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 25;
                                                                    v24 = $this$sequence.yield((Object)"UVeygGIthsA/0hMCioYz4UjWTgi9NQLbhVkfmVQ5lCVxTotyBzoubh3FBz+wq2Qt", (Continuation)this);
                                                                    if (v24 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl256
                                                                }
                                                                case 25: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v24 = $result;
lbl256:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 26;
                                                                    v25 = $this$sequence.yield((Object)"iElsBrCMR7UwmIu79UYzmLGt3/gBdHxaImrT9SQ8uqzP5eit54LlGbvGekVdAL5l", (Continuation)this);
                                                                    if (v25 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl266
                                                                }
                                                                case 26: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v25 = $result;
lbl266:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 27;
                                                                    v26 = $this$sequence.yield((Object)"DFwPcSB1IKauXZvi1DwFGPeemcSAndy+Uoqw5XGRqE6jBxS7XVI7/4BSMDDRBz1u", (Continuation)this);
                                                                    if (v26 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl276
                                                                }
                                                                case 27: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v26 = $result;
lbl276:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 28;
                                                                    v27 = $this$sequence.yield((Object)"a+JMGZXS8yyYT+7HdsybfsZLvkVmc9zVSDI7/MjVPdk6h0sLn+vuPC1bIi5edoNy", (Continuation)this);
                                                                    if (v27 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl286
                                                                }
                                                                case 28: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v27 = $result;
lbl286:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 29;
                                                                    v28 = $this$sequence.yield((Object)"PdiG2uPH5eDO6INcisyPpLS4yFKliaO4Jjap7yzLU9pbItoWgCAYa2NpxuxHJ0tB", (Continuation)this);
                                                                    if (v28 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl296
                                                                }
                                                                case 29: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v28 = $result;
lbl296:
                                                                    // 2 sources

                                                                    this.L$0 = $this$sequence;
                                                                    this.label = 30;
                                                                    v29 = $this$sequence.yield((Object)"7tlDFnvaRnQukqSG+VqNWg==", (Continuation)this);
                                                                    if (v29 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl306
                                                                }
                                                                case 30: {
                                                                    $this$sequence = (SequenceScope)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v29 = $result;
lbl306:
                                                                    // 2 sources

                                                                    this.L$0 = null;
                                                                    this.label = 31;
                                                                    v30 = $this$sequence.yield((Object)"-----END CERTIFICATE-----", (Continuation)this);
                                                                    if (v30 == var3_2) {
                                                                        return var3_2;
                                                                    }
                                                                    ** GOTO lbl315
                                                                }
                                                                case 31: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v30 = $result;
lbl315:
                                                                    // 2 sources

                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                            var3_3.L$0 = value2;
                                                            return (Continuation)var3_3;
                                                        }

                                                        @Nullable
                                                        public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    })), (Continuation)this);
                                                    if (v1 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl25
                                                }
                                                case 2: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl25:
                                                    // 2 sources

                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                            var3_3.L$0 = value2;
                                            return (Continuation)var3_3;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull SequenceScope<? super Sequence<String>> p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    })), (Function1)QodanaLicenseChecker.createCertificate.1.trustAchors.1.INSTANCE), (Function1)QodanaLicenseChecker.createCertificate.1.trustAchors.2.INSTANCE), (Function1)((Function1)new Function1<String, TrustAnchor>(x509factory$iv$iv$iv){
                                        final /* synthetic */ CertificateFactory $x509factory;
                                        {
                                            this.$x509factory = $x509factory;
                                            super(1);
                                        }

                                        @NotNull
                                        public final TrustAnchor invoke(@NotNull String it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            String string = it;
                                            byte[] byArray = string.getBytes(Charsets.UTF_8);
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                            Certificate certificate = this.$x509factory.generateCertificate(new ByteArrayInputStream(byArray));
                                            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                                            return new TrustAnchor((X509Certificate)certificate, null);
                                        }
                                    })));
                                    PKIXBuilderParameters pkixParams$iv$iv$iv = new PKIXBuilderParameters(CollectionsKt.toMutableSet((Iterable)list2), (CertSelector)selector$iv$iv$iv);
                                    pkixParams$iv$iv$iv.setRevocationEnabled(false);
                                    pkixParams$iv$iv$iv.setDate(cert$iv$iv$iv.getNotBefore());
                                    pkixParams$iv$iv$iv.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(allCerts$iv$iv$iv)));
                                    CertPath path$iv$iv$iv = CertPathBuilder.getInstance("PKIX").build(pkixParams$iv$iv$iv).getCertPath();
                                    if (path$iv$iv$iv != null) {
                                        CertPathValidator.getInstance("PKIX").validate(path$iv$iv$iv, pkixParams$iv$iv$iv);
                                        x509Certificate = cert$iv$iv$iv;
                                        break block33;
                                    }
                                    $this$createCertificate_u24lambda_u244$iv$iv$iv = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable bl4) {
                                    Object $this$createCertificate_u24lambda_u244$iv$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                                }
                                throw new Exception("Certificate used to sign the license is not signed by JetBrains root certificate");
                            }
                            signature.initVerify(x509Certificate);
                            Base64.Decoder decoder = Base64.getMimeDecoder();
                            byte[] byArray = licensePartBase64$iv$iv.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            byte[] licenseBytes$iv$iv = decoder.decode(byArray);
                            sig$iv$iv.update(licenseBytes$iv$iv);
                            Base64.Decoder decoder2 = Base64.getMimeDecoder();
                            byte[] byArray5 = signatureBase64$iv$iv.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"this as java.lang.String).getBytes(charset)");
                            if (!sig$iv$iv.verify(decoder2.decode(byArray5))) {
                                qodanaLicenseType2 = QodanaLicenseType.NONE;
                                break block32;
                            }
                            Intrinsics.checkNotNull((Object)licenseBytes$iv$iv);
                            intermediateCertsBytes$iv$iv$iv = licenseBytes$iv$iv;
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                            Charset checkValidityAtCurrentDate$iv$iv$iv = charset;
                            String licenseData$iv$iv = new String(intermediateCertsBytes$iv$iv$iv, checkValidityAtCurrentDate$iv$iv$iv);
                            boolean $i$f$logger = false;
                            Logger logger2 = Logger.getInstance(QodanaLicenseChecker.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                            Logger logger$iv$iv = logger2;
                            logger$iv$iv.debug("License data:\n" + licenseData$iv$iv);
                            QodanaLicenseChecker this_$iv$iv$iv = QodanaLicenseChecker.INSTANCE;
                            boolean $i$f$isUltimatePlus = false;
                            try {
                                Object v19;
                                block34: {
                                    JsonNode jsonNode = new ObjectMapper().readTree(licenseData$iv$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
                                    JsonNode root$iv$iv$iv = jsonNode;
                                    Iterator iterator = root$iv$iv$iv.path("products").elements();
                                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
                                    Sequence $this$firstOrNull$iv$iv$iv$iv = SequencesKt.asSequence((Iterator)iterator);
                                    boolean $i$f$firstOrNull = false;
                                    for (Object element$iv$iv$iv$iv : $this$firstOrNull$iv$iv$iv$iv) {
                                        JsonNode it$iv$iv$iv = (JsonNode)element$iv$iv$iv$iv;
                                        boolean bl5 = false;
                                        JsonNode jsonNode2 = it$iv$iv$iv.get("code");
                                        if (!Intrinsics.areEqual((Object)(jsonNode2 != null ? jsonNode2.asText() : null), (Object)"QDL")) continue;
                                        v19 = element$iv$iv$iv$iv;
                                        break block34;
                                    }
                                    v19 = null;
                                }
                                JsonNode jsonNode = v19;
                                if (jsonNode == null) {
                                    bl = false;
                                } else {
                                    JsonNode jsonNode3 = jsonNode;
                                    String plan$iv$iv$iv = jsonNode3.path("properties").path("plan").asText();
                                    QodanaLicenseChecker this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                    boolean $i$f$getULTIMATE_PLUS_PLANS = false;
                                    Object[] objectArray = new String[]{"QDUE", "QDUP"};
                                    bl = SetsKt.setOf((Object[])objectArray).contains(plan$iv$iv$iv);
                                }
                            }
                            catch (JsonParseException e$iv$iv$iv) {
                                boolean bl2 = false;
                                Logger logger3 = Logger.getInstance(QodanaLicenseChecker.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                                logger3.error((Throwable)e$iv$iv$iv);
                                bl = false;
                            }
                            if (bl) {
                                qodanaLicenseType2 = QodanaLicenseType.ULTIMATE_PLUS;
                                break block32;
                            }
                            qodanaLicenseType2 = QodanaLicenseType.ULTIMATE;
                        }
                        catch (Throwable throwable) {
                            Object object5;
                            Object object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object6);
                            if (throwable2 == null) {
                                object5 = object6;
                            } else {
                                Throwable it$iv$iv$iv = throwable2;
                                boolean bl = false;
                                object5 = QodanaLicenseType.NONE;
                            }
                            qodanaLicenseType2 = (QodanaLicenseType)((Object)object5);
                        }
                    } else {
                        this_$iv$iv = QodanaLicenseChecker.INSTANCE;
                        boolean $i$f$getEVAL_PREFIX22 = false;
                        if (StringsKt.startsWith$default((String)cstamp$iv, (String)"eval:", (boolean)false, (int)2, null)) {
                            Object object7;
                            Object object8;
                            this_$iv$iv = QodanaLicenseChecker.INSTANCE;
                            Object $i$f$getEVAL_PREFIX22 = cstamp$iv;
                            QodanaLicenseChecker this_$iv$iv3232 = QodanaLicenseChecker.INSTANCE;
                            boolean $i$f$getEVAL_PREFIX3 = false;
                            int this_$iv$iv3232 = "eval:".length();
                            String string = ((String)$i$f$getEVAL_PREFIX22).substring(this_$iv$iv3232);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            String expirationTime$iv$iv = string;
                            boolean $i$f$isEvaluationValid = false;
                            this_$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$runCatchingOrFalse = false;
                            try {
                                boolean bl = false;
                                Date now$iv$iv = new Date();
                                Date expiration$iv$iv = new Date(Long.parseLong(expirationTime$iv$iv));
                                object8 = Result.constructor-impl((Object)now$iv$iv.before(expiration$iv$iv));
                            }
                            catch (Throwable licenseParts$iv$iv) {
                                object8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)licenseParts$iv$iv));
                            }
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object8);
                            if (throwable == null) {
                                object7 = object8;
                            } else {
                                Throwable it$iv$iv$iv = throwable;
                                boolean bl = false;
                                object7 = false;
                            }
                            qodanaLicenseType2 = ((Boolean)object7).booleanValue() ? QodanaLicenseType.ULTIMATE_PLUS : QodanaLicenseType.NONE;
                        } else {
                            qodanaLicenseType2 = QodanaLicenseType.NONE;
                        }
                    }
                }
                object2 = Result.constructor-impl((Object)((Object)qodanaLicenseType2));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable it$iv$iv = throwable;
                boolean bl = false;
                object = QodanaLicenseType.NONE;
            }
            qodanaLicenseType = (QodanaLicenseType)((Object)object);
        }
        QodanaLicenseType licenseType = qodanaLicenseType;
        if (licenseType == QodanaLicenseType.NONE) {
            System.out.println((Object)"There is no valid license or license has expired.");
            System.exit(7);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        return licenseType;
    }

    public static final void printLicenseInfo(@NotNull QodanaLicenseType licenseType) {
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        if (LicenseCheckKt.isEapLicensing()) {
            Date expirationDate;
            LicensingFacade licensingFacade = LicensingFacade.getInstance();
            Date date = expirationDate = licensingFacade != null ? licensingFacade.expirationDate : null;
            if (expirationDate != null) {
                String string = NlsMessages.formatDateLong((Date)expirationDate);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateLong(...)");
                String formattedExpirationDate = string;
                Object[] objectArray = new Object[]{formattedExpirationDate};
                System.out.println((Object)QodanaBundle.message("eap.license.message.with.expiration.date", objectArray));
            } else {
                Object[] formattedExpirationDate = new Object[]{60};
                System.out.println((Object)QodanaBundle.message("eap.license.message", formattedExpirationDate));
            }
        } else {
            LicensingFacade licensingFacade = LicensingFacade.getInstance();
            if (licensingFacade != null) {
                System.out.println((Object)QodanaBundle.message("release.license.message", new Object[0]));
                String licensedTo = licensingFacade.getLicensedToMessage();
                if (licensedTo != null) {
                    System.out.println((Object)licensedTo);
                }
                List list2 = licensingFacade.getLicenseRestrictionsMessages();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLicenseRestrictionsMessages(...)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    System.out.println((Object)it);
                }
            } else {
                System.out.println((Object)QodanaBundle.message("release.community.license.message", new Object[0]));
            }
        }
        System.out.println((Object)("Qodana license plan: " + licenseType.getPresentableName()));
    }

    private static final boolean isEapLicensing() {
        return ApplicationInfo.getInstance().isEAP() && !Intrinsics.areEqual((Object)System.getProperty("eap.require.license"), (Object)"release");
    }

    private static final void checkCommunityLicense() {
        if (!LicenseCheckKt.isEapLicensing()) {
            return;
        }
        Object object = ApplicationInfo.getInstance().getBuildDate().clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.Calendar");
        Calendar calendar = (Calendar)object;
        Date buildDate = calendar.getTime();
        calendar.add(5, 60);
        Date expirationDate = calendar.getTime();
        Date now = new Date();
        if (now.before(buildDate) || expirationDate.before(now)) {
            System.out.println((Object)"EAP license of this Qodana image is expired. Please use \"docker pull\" to update image.");
            System.exit(7);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }
}

