/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.sarif.CodeInspectionReaderKt;
import org.jetbrains.qodana.sarif.ProblemReaderException;
import org.jetbrains.qodana.sarif.Report;
import org.jetbrains.qodana.sarif.SarifConverter;
import org.jetbrains.qodana.sarif.json.idea.Description;
import org.jetbrains.qodana.sarif.json.idea.Inspection;
import org.jetbrains.qodana.sarif.model.Group;
import org.jetbrains.teamcity.qodana.model.version3.Problem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J*\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b*\u00060\u001cj\u0002`\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f*\u00060 j\u0002`!H\u0002J\u0010\u0010\"\u001a\u00020#*\u00060$j\u0002`%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/qodana/sarif/CodeInspectionReader;", "", "input", "Ljava/io/File;", "(Ljava/io/File;)V", "gson", "Lcom/google/gson/Gson;", "sarifReport", "Lorg/jetbrains/qodana/sarif/Report;", "amountAllProblems", "", "writeDescription", "", "output", "writeProblems", "upperBound", "writer", "Lcom/google/gson/stream/JsonWriter;", "writePromo", "writeSanity", "writeSpecificProblems", "problems", "", "Lorg/jetbrains/teamcity/qodana/model/version3/Problem;", "tag", "", "toQodanaDescription", "Lorg/jetbrains/qodana/sarif/json/idea/Description;", "Lorg/jetbrains/qodana/sarif/model/Description;", "Lorg/jetbrains/qodana/sarif/SarifDescription;", "toQodanaGroup", "Lorg/jetbrains/qodana/sarif/json/idea/Group;", "Lorg/jetbrains/qodana/sarif/model/Group;", "Lorg/jetbrains/qodana/sarif/SarifGroup;", "toQodanaInspection", "Lorg/jetbrains/qodana/sarif/json/idea/Inspection;", "Lorg/jetbrains/qodana/sarif/model/Inspection;", "Lorg/jetbrains/qodana/sarif/SarifInspection;", "sarif-converter"})
public final class CodeInspectionReader {
    @NotNull
    private final Gson gson;
    @NotNull
    private final Report sarifReport;

    public CodeInspectionReader(@NotNull File input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Path.class), CodeInspectionReader::gson$lambda-0).registerTypeAdapter((Type)Paths.get(".", new String[0]).getClass(), CodeInspectionReader::gson$lambda-1).disableHtmlEscaping().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026g()\n            .create()");
        this.gson = gson;
        File sarifFile = FilesKt.resolve((File)input, (String)"qodana.sarif.json");
        if (!sarifFile.exists()) {
            throw new ProblemReaderException("Report should contain qodana.sarif.json", null, 2, null);
        }
        CodeInspectionReaderKt.access$getLog$p().info(Intrinsics.stringPlus((String)"Reading problems and description from sarif: ", (Object)sarifFile.getAbsolutePath()));
        this.sarifReport = new SarifConverter().convert(sarifFile);
    }

    public final int amountAllProblems() {
        return this.sarifReport.getProblems().getListProblem().size();
    }

    /*
     * WARNING - void declaration
     */
    public final void writeProblems(int upperBound, @NotNull JsonWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (upperBound < 0) {
            throw new ProblemReaderException("upperBound have to be positive", null, 2, null);
        }
        if (upperBound == 0) {
            return;
        }
        int written = 0;
        CodeInspectionReaderKt.access$getLog$p().info("Writing sarif problems");
        Iterable $this$forEach$iv = this.sarifReport.getProblems().getListProblem();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$writeProblems_u24lambda_u2d3_u24lambda_u2d2;
            Problem it = (Problem)element$iv;
            boolean bl = false;
            if (written == upperBound) {
                return;
            }
            Problem problem = it;
            boolean bl2 = false;
            boolean bl3 = false;
            Problem problem2 = problem;
            Gson gson = this.gson;
            JsonWriter jsonWriter = writer;
            boolean bl4 = false;
            $this$writeProblems_u24lambda_u2d3_u24lambda_u2d2.setTool("Code Inspection");
            Unit unit = Unit.INSTANCE;
            jsonWriter.jsonValue(gson.toJson((Object)problem));
            int n = written;
            written = n + 1;
        }
    }

    public final void writeSanity(@NotNull JsonWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.writeSpecificProblems(writer, this.sarifReport.getSanity().getListProblem(), "Sanity");
    }

    public final void writePromo(@NotNull JsonWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        CodeInspectionReader.writeSpecificProblems$default(this, writer, this.sarifReport.getPromo().getListProblem(), null, 4, null);
    }

    private final void writeSpecificProblems(JsonWriter writer, List<? extends Problem> problems2, String tag) {
        if (problems2.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = problems2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Problem problem = (Problem)element$iv;
            boolean bl = false;
            Problem problem2 = problem;
            boolean bl2 = false;
            boolean bl3 = false;
            Problem $this$writeSpecificProblems_u24lambda_u2d5_u24lambda_u2d4 = problem2;
            boolean bl4 = false;
            $this$writeSpecificProblems_u24lambda_u2d5_u24lambda_u2d4.setTool("Code Inspection");
            if (tag != null) {
                List<String> temp = $this$writeSpecificProblems_u24lambda_u2d5_u24lambda_u2d4.getTags();
                $this$writeSpecificProblems_u24lambda_u2d5_u24lambda_u2d4.setTags(temp == null ? CollectionsKt.listOf((Object)tag) : CollectionsKt.plus((Collection)temp, (Iterable)CollectionsKt.listOf((Object)tag)));
            }
            writer.jsonValue(this.gson.toJson((Object)problem));
        }
    }

    static /* synthetic */ void writeSpecificProblems$default(CodeInspectionReader codeInspectionReader, JsonWriter jsonWriter, List list2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        codeInspectionReader.writeSpecificProblems(jsonWriter, list2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDescription(@NotNull File output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        if (this.sarifReport.getDescription() != null) {
            boolean $i$f$useJsonWriter = false;
            Closeable closeable = (Closeable)new JsonWriter((Writer)new BufferedWriter(new FileWriter(output2, StandardCharsets.UTF_8)));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                JsonWriter writer = (JsonWriter)closeable;
                boolean bl3 = false;
                JsonWriter jsonWriter = writer.jsonValue(this.gson.toJson((Object)this.toQodanaDescription(this.sarifReport.getDescription())));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Description toQodanaDescription(org.jetbrains.qodana.sarif.model.Description $this$toQodanaDescription) {
        List list2;
        String string = null;
        List<Group> list3 = $this$toQodanaDescription.getGroups();
        if (list3 == null) {
            list2 = null;
        } else {
            Collection<org.jetbrains.qodana.sarif.json.idea.Group> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            String string2 = string;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Group group = (Group)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                org.jetbrains.qodana.sarif.json.idea.Group group2 = this.toQodanaGroup((Group)it);
                collection.add(group2);
            }
            collection = (List)destination$iv$iv;
            string = string2;
            list2 = collection;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1;
        List list4 = list2;
        String string3 = string;
        return new Description(string3, list4, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final org.jetbrains.qodana.sarif.json.idea.Group toQodanaGroup(Group $this$toQodanaGroup) {
        List list2;
        String string = $this$toQodanaGroup.getName();
        List<org.jetbrains.qodana.sarif.model.Inspection> list3 = $this$toQodanaGroup.getInspections();
        if (list3 == null) {
            list2 = null;
        } else {
            Collection<Inspection> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            String string2 = string;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                org.jetbrains.qodana.sarif.model.Inspection inspection = (org.jetbrains.qodana.sarif.model.Inspection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Inspection inspection2 = this.toQodanaInspection((org.jetbrains.qodana.sarif.model.Inspection)it);
                collection.add(inspection2);
            }
            collection = (List)destination$iv$iv;
            string = string2;
            list2 = collection;
        }
        List list4 = list2;
        String string3 = string;
        return new org.jetbrains.qodana.sarif.json.idea.Group(string3, list4);
    }

    private final Inspection toQodanaInspection(org.jetbrains.qodana.sarif.model.Inspection $this$toQodanaInspection) {
        return new Inspection($this$toQodanaInspection.getShortName(), $this$toQodanaInspection.getDisplayName(), $this$toQodanaInspection.getEnabled(), $this$toQodanaInspection.getDescription());
    }

    private static final Path gson$lambda-0(JsonElement json2, Type $noName_1, JsonDeserializationContext $noName_2) {
        JsonElement jsonElement = json2;
        Intrinsics.checkNotNull((Object)jsonElement);
        return Paths.get(jsonElement.getAsString(), new String[0]);
    }

    private static final JsonElement gson$lambda-1(Path path, Type $noName_1, JsonSerializationContext $noName_2) {
        return (JsonElement)new JsonPrimitive(((Object)path).toString());
    }
}

