/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessageBySftp;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessageBySftp;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ResourceUtils;

public class Scp
extends SSHBase {
    private static final String[] FROM_ATTRS = new String[]{"file", "localfile", "remotefile"};
    private static final String[] TO_ATTRS = new String[]{"todir", "localtodir", "remotetodir", "localtofile", "remotetofile"};
    private String fromUri;
    private String toUri;
    private boolean preserveLastModified = false;
    private boolean compressed = false;
    private List<ResourceCollection> rcs = null;
    private boolean isFromRemote;
    private boolean isToRemote;
    private boolean isSftp = false;
    private Integer fileMode;
    private Integer dirMode;

    public void setFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = Scp.isRemoteUri(this.fromUri);
    }

    public void setTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = Scp.isRemoteUri(this.toUri);
    }

    public void setLocalFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = false;
    }

    public void setRemoteFile(String aFromUri) {
        Scp.validateRemoteUri("remoteFile", aFromUri);
        this.setFromUri(aFromUri);
        this.isFromRemote = true;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setLocalTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setPreservelastmodified(boolean yesOrNo) {
        this.preserveLastModified = yesOrNo;
    }

    public void setRemoteTodir(String aToUri) {
        Scp.validateRemoteUri("remoteToDir", aToUri);
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    private static void validateRemoteUri(String type, String aToUri) {
        if (!Scp.isRemoteUri(aToUri)) {
            throw new BuildException("%s '%s' is invalid. The 'remoteToDir' attribute must have syntax like the following: user:password@host:/path - the :password part is optional", type, aToUri);
        }
    }

    public void setLocalTofile(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setRemoteTofile(String aToUri) {
        Scp.validateRemoteUri("remoteToFile", aToUri);
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    public void setSftp(boolean yesOrNo) {
        this.isSftp = yesOrNo;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = Integer.parseInt(fileMode, 8);
    }

    public void setDirMode(String dirMode) {
        this.dirMode = Integer.parseInt(dirMode, 8);
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void add(ResourceCollection res) {
        if (this.rcs == null) {
            this.rcs = new LinkedList<ResourceCollection>();
        }
        this.rcs.add(res);
    }

    @Override
    public void init() throws BuildException {
        super.init();
        this.toUri = null;
        this.fromUri = null;
        this.rcs = null;
    }

    @Override
    public void execute() throws BuildException {
        block12: {
            if (this.toUri == null) {
                throw this.exactlyOne(TO_ATTRS);
            }
            if (this.fromUri == null && this.rcs == null) {
                throw this.exactlyOne(FROM_ATTRS, "one or more nested filesets");
            }
            try {
                if (this.isFromRemote && !this.isToRemote) {
                    this.download(this.fromUri, this.toUri);
                    break block12;
                }
                if (!this.isFromRemote && this.isToRemote) {
                    if (this.rcs != null) {
                        this.upload(this.rcs, this.toUri);
                    } else {
                        this.upload(this.fromUri, this.toUri);
                    }
                    break block12;
                }
                if (this.isFromRemote && this.isToRemote) {
                    throw new BuildException("Copying from a remote server to a remote server is not supported.");
                }
                throw new BuildException("'todir' and 'file' attributes must have syntax like the following: user:password@host:/path");
            }
            catch (Exception e) {
                if (this.getFailonerror()) {
                    if (e instanceof BuildException) {
                        BuildException be = (BuildException)e;
                        if (be.getLocation() == null) {
                            be.setLocation(this.getLocation());
                        }
                        throw be;
                    }
                    throw new BuildException(e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String fromSshUri, String toPath) throws JSchException, IOException {
        String file = this.parseUri(fromSshUri);
        Session session = null;
        try {
            session = this.openSession();
            ScpFromMessage message = null;
            message = !this.isSftp ? new ScpFromMessage(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"), this.preserveLastModified, this.compressed) : new ScpFromMessageBySftp(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"), this.preserveLastModified);
            this.log("Receiving file: " + file);
            message.setLogListener(this);
            message.execute();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(List<ResourceCollection> rcs, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            ArrayList<Directory> list = new ArrayList<Directory>(rcs.size());
            for (ResourceCollection rc : rcs) {
                if (rc instanceof FileSet && rc.isFilesystemOnly()) {
                    FileSet fs = (FileSet)rc;
                    Directory d = this.createDirectory(fs);
                    if (d == null) continue;
                    list.add(d);
                    continue;
                }
                List<Directory> ds = this.createDirectoryCollection(rc);
                if (ds == null) continue;
                list.addAll(ds);
            }
            if (!list.isEmpty()) {
                session = this.openSession();
                ScpToMessage message = !this.isSftp ? new ScpToMessage(this.getVerbose(), this.compressed, session, list, file, this.preserveLastModified) : new ScpToMessageBySftp(this.getVerbose(), session, list, file, this.preserveLastModified);
                message.setLogListener(this);
                if (this.fileMode != null) {
                    message.setFileMode(this.fileMode);
                }
                if (this.dirMode != null) {
                    message.setDirMode(this.dirMode);
                }
                message.execute();
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(String fromPath, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            session = this.openSession();
            ScpToMessage message = null;
            message = !this.isSftp ? new ScpToMessage(this.getVerbose(), this.compressed, session, this.getProject().resolveFile(fromPath), file, this.preserveLastModified) : new ScpToMessageBySftp(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file, this.preserveLastModified);
            message.setLogListener(this);
            if (this.fileMode != null) {
                message.setFileMode(this.fileMode);
            }
            if (this.dirMode != null) {
                message.setDirMode(this.dirMode);
            }
            message.execute();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private String parseUri(String uri) {
        int indexOfAt = uri.indexOf(64);
        int indexOfColon = uri.indexOf(58);
        if (indexOfColon > -1 && indexOfColon < indexOfAt) {
            int indexOfCurrentAt = indexOfAt;
            int indexOfLastColon = uri.lastIndexOf(58);
            while (indexOfCurrentAt > -1 && indexOfCurrentAt < indexOfLastColon) {
                indexOfAt = indexOfCurrentAt;
                indexOfCurrentAt = uri.indexOf(64, indexOfCurrentAt + 1);
            }
            this.setUsername(uri.substring(0, indexOfColon));
            this.setPassword(uri.substring(indexOfColon + 1, indexOfAt));
        } else if (indexOfAt > -1) {
            this.setUsername(uri.substring(0, indexOfAt));
        } else {
            throw new BuildException("no username was given.  Can't authenticate.");
        }
        int indexOfPath = uri.indexOf(58, indexOfAt + 1);
        if (indexOfPath == -1) {
            throw new BuildException("no remote path in %s", uri);
        }
        this.setHost(uri.substring(indexOfAt + 1, indexOfPath));
        this.loadSshConfig();
        if (this.getUserInfo().getPassword() == null && this.getUserInfo().getKeyfile() == null) {
            throw new BuildException("neither password nor keyfile for user %s has been given.  Can't authenticate.", this.getUserInfo().getName());
        }
        String remotePath = uri.substring(indexOfPath + 1);
        if (remotePath.isEmpty()) {
            remotePath = ".";
        }
        return remotePath;
    }

    private static boolean isRemoteUri(String uri) {
        return uri.contains("@");
    }

    private Directory createDirectory(FileSet set) {
        DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
        String[] files = scanner.getIncludedFiles();
        if (files.length == 0) {
            return null;
        }
        Directory root = new Directory(scanner.getBasedir());
        Stream.of(files).map(Directory::getPath).forEach(path -> {
            Directory current = root;
            File currentParent = scanner.getBasedir();
            for (String element : path) {
                File file = new File(currentParent, element);
                if (file.isDirectory()) {
                    current.addDirectory(new Directory(file));
                    current = current.getChild(file);
                    currentParent = current.getDirectory();
                    continue;
                }
                if (!file.isFile()) continue;
                current.addFile(file);
            }
        });
        return root;
    }

    private List<Directory> createDirectoryCollection(ResourceCollection rc) {
        if (!rc.isFilesystemOnly()) {
            throw new BuildException("Only FileSystem resources are supported.");
        }
        ArrayList<Directory> ds = new ArrayList<Directory>();
        for (Resource r : rc) {
            Directory root;
            if (!r.isExists()) {
                throw new BuildException("Could not find resource %s to scp.", r.toLongString());
            }
            FileProvider fp = r.as(FileProvider.class);
            if (fp == null) {
                throw new BuildException("Resource %s is not a file.", r.toLongString());
            }
            FileResource fr = ResourceUtils.asFileResource(fp);
            File baseDir = fr.getBaseDir();
            if (baseDir == null) {
                throw new BuildException("basedir for resource %s is undefined.", r.toLongString());
            }
            String name = r.getName();
            Directory current = root = new Directory(baseDir);
            File currentParent = baseDir;
            for (String element : Directory.getPath(name)) {
                File file = new File(currentParent, element);
                if (file.isDirectory()) {
                    current.addDirectory(new Directory(file));
                    current = current.getChild(file);
                    currentParent = current.getDirectory();
                    continue;
                }
                if (!file.isFile()) continue;
                current.addFile(file);
            }
            ds.add(root);
        }
        return ds;
    }

    private void setFromUri(String fromUri) {
        if (this.fromUri != null) {
            throw this.exactlyOne(FROM_ATTRS);
        }
        this.fromUri = fromUri;
    }

    private void setToUri(String toUri) {
        if (this.toUri != null) {
            throw this.exactlyOne(TO_ATTRS);
        }
        this.toUri = toUri;
    }

    private BuildException exactlyOne(String[] attrs) {
        return this.exactlyOne(attrs, null);
    }

    private BuildException exactlyOne(String[] attrs, String alt) {
        return new BuildException("Exactly one of [%s]%s is required", String.join((CharSequence)"|", attrs), alt == null ? "" : " or " + alt);
    }
}

