/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.WaitForProgressToShow;
import org.jetbrains.idea.perforce.PerforceBundle;

public class ErrorReporter {
    private static final Logger LOG = Logger.getInstance(ErrorReporter.class);
    private final String myOperation;

    public ErrorReporter(String operation) {
        this.myOperation = operation;
    }

    public void report(Project project, VcsException e) {
        LOG.info((Throwable)e);
        String message = PerforceBundle.message("error.during", this.myOperation, e.getMessage());
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project, (String)message, (String)PerforceBundle.message("job.jobs.error", new Object[0])), null, (Project)project);
    }
}

