/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.ParserLogger;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobField;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;
import org.jetbrains.idea.perforce.perforce.jobs.StandardJobFields;

public class JobsOutputParser {
    private static final ParserLogger LOG = new ParserLogger("#org.jetbrains.idea.perforce.perforce.jobs.JobsOutputParser", "'p4 jobs' output parsing error.");
    private final PerforceJobSpecification mySpecification;
    private final List<String> myLines;
    private final P4Connection myConnection;
    private final ConnectionKey myKey;
    private static final Parser[] ourParsers = new Parser[]{new Parser(){

        @Override
        @NotNull
        public StandardJobFields getField() {
            StandardJobFields standardJobFields = StandardJobFields.name;
            if (standardJobFields == null) {
                1.$$$reportNull$$$0(0);
            }
            return standardJobFields;
        }

        @Override
        @NotNull
        public String parse(String s, Ref<Integer> startFrom) throws VcsException {
            int idx = s.indexOf(" ");
            idx = idx == -1 ? s.length() : idx;
            String result = s.substring(0, idx);
            startFrom.set((Object)result.length());
            String string = result;
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/perforce/perforce/jobs/JobsOutputParser$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }, new Parser(){

        @Override
        @NotNull
        public StandardJobFields getField() {
            StandardJobFields standardJobFields = StandardJobFields.date;
            if (standardJobFields == null) {
                2.$$$reportNull$$$0(0);
            }
            return standardJobFields;
        }

        @Override
        @Nullable
        public String parse(String s, Ref<Integer> startFrom) throws VcsException {
            int idx = s.indexOf(" on ", (int)((Integer)startFrom.get()));
            if (idx == -1) {
                return null;
            }
            int idxEnd = s.indexOf(" ", idx + " on ".length());
            idxEnd = idxEnd == -1 ? s.length() : idxEnd;
            String result = s.substring(idx + " on ".length(), idxEnd);
            startFrom.set((Object)idxEnd);
            return result.trim();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/JobsOutputParser$2", "getField"));
        }
    }, new Parser(){

        @Override
        @NotNull
        public StandardJobFields getField() {
            StandardJobFields standardJobFields = StandardJobFields.user;
            if (standardJobFields == null) {
                3.$$$reportNull$$$0(0);
            }
            return standardJobFields;
        }

        @Override
        @Nullable
        public String parse(String s, Ref<Integer> startFrom) throws VcsException {
            int idx = s.indexOf(" by ", (int)((Integer)startFrom.get()));
            if (idx == -1) {
                return null;
            }
            int idxEnd = s.indexOf(" ", idx + " by ".length());
            idxEnd = idxEnd == -1 ? s.length() : idxEnd;
            startFrom.set((Object)idxEnd);
            return s.substring(idx + " by ".length(), idxEnd).trim();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/JobsOutputParser$3", "getField"));
        }
    }, new Parser(){

        @Override
        @NotNull
        public StandardJobFields getField() {
            StandardJobFields standardJobFields = StandardJobFields.status;
            if (standardJobFields == null) {
                4.$$$reportNull$$$0(0);
            }
            return standardJobFields;
        }

        @Override
        @Nullable
        public String parse(String s, Ref<Integer> startFrom) throws VcsException {
            int idx1 = s.indexOf("*", (int)((Integer)startFrom.get()));
            if (idx1 == -1) {
                return null;
            }
            int idx2 = s.indexOf("*", idx1 + "*".length());
            if (idx2 == -1) {
                LOG.generateParseException("Cannot find status in '" + s + "'");
            }
            startFrom.set((Object)(idx2 + 1));
            return s.substring(idx1 + "*".length(), idx2).trim();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/JobsOutputParser$4", "getField"));
        }
    }, new Parser(){

        @Override
        @NotNull
        public StandardJobFields getField() {
            StandardJobFields standardJobFields = StandardJobFields.description;
            if (standardJobFields == null) {
                5.$$$reportNull$$$0(0);
            }
            return standardJobFields;
        }

        @Override
        @NotNull
        public String parse(String s, Ref<Integer> startFrom) {
            String removeWrappers = s.substring((Integer)startFrom.get()).trim();
            if ((removeWrappers = StringUtil.trimStart((String)removeWrappers, (String)"'")).endsWith("'")) {
                removeWrappers = removeWrappers.substring(0, removeWrappers.length() - 2);
            }
            startFrom.set((Object)s.length());
            String string = removeWrappers.trim();
            if (string == null) {
                5.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/perforce/perforce/jobs/JobsOutputParser$5";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }};

    public JobsOutputParser(PerforceJobSpecification specification, List<String> lines, P4Connection connection, ConnectionKey key) {
        this.mySpecification = specification;
        this.myLines = lines;
        this.myConnection = connection;
        this.myKey = key;
    }

    public List<PerforceJob> parse() throws VcsException {
        ArrayList<PerforceJob> result = new ArrayList<PerforceJob>();
        List<FieldParser> fieldParsers = this.createStandardParsersBySpec();
        for (String line : this.myLines) {
            if (line.startsWith("\t")) {
                PerforceJob lastJob;
                PerforceJobFieldValue field;
                if (result.isEmpty()) {
                    LOG.generateParseException("Cannot parse line: " + line);
                }
                if ((field = (lastJob = (PerforceJob)result.get(result.size() - 1)).getValueForStandardField(StandardJobFields.description)) != null) {
                    field.setValue(field.getValue() + " " + line.trim());
                    continue;
                }
                LOG.generateParseException("Cannot append description line: " + line);
                continue;
            }
            result.add(this.parseLine(line, fieldParsers));
        }
        return result;
    }

    private PerforceJob parseLine(String line, List<FieldParser> fieldParsers) throws VcsException {
        ArrayList<PerforceJobFieldValue> values = new ArrayList<PerforceJobFieldValue>(fieldParsers.size());
        Ref startAt = new Ref((Object)0);
        for (FieldParser parser : fieldParsers) {
            parser.parse(line, (Ref<Integer>)startAt, values);
        }
        return new PerforceJob(values, Collections.emptyList(), this.myConnection, this.myKey);
    }

    private List<FieldParser> createStandardParsersBySpec() {
        ArrayList<FieldParser> result = new ArrayList<FieldParser>();
        for (Parser parser : ourParsers) {
            PerforceJobField field = this.mySpecification.getFieldByCode(parser.getField().getFixedCode());
            if (field == null) continue;
            result.add(new FieldParser(field, parser));
        }
        return result;
    }

    private static class FieldParser {
        private final PerforceJobField myField;
        private final Parser myParser;

        protected FieldParser(@NotNull PerforceJobField field, Parser parser) {
            if (field == null) {
                FieldParser.$$$reportNull$$$0(0);
            }
            this.myField = field;
            this.myParser = parser;
        }

        protected void parse(String line, Ref<Integer> startAt, List<PerforceJobFieldValue> fieldValues) throws VcsException {
            String s = this.myParser.parse(line, startAt);
            if (s != null) {
                fieldValues.add(new PerforceJobFieldValue(this.myField, s));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/idea/perforce/perforce/jobs/JobsOutputParser$FieldParser", "<init>"));
        }
    }

    private static interface Parser {
        public static final String BY = " by ";
        public static final String ON = " on ";
        public static final String STAR = "*";

        @NotNull
        public StandardJobFields getField();

        @Nullable
        public String parse(String var1, Ref<Integer> var2) throws VcsException;
    }
}

