/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.git;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTaskBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import git4idea.GitVcs;
import git4idea.log.GitShowExternalLogActionKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/git/SettingsSyncHistoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.settingsSync.git"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncHistoryAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncHistoryAction.kt\ncom/intellij/settingsSync/git/SettingsSyncHistoryAction\n+ 2 ToolWindowManager.kt\ncom/intellij/openapi/wm/ToolWindowManager\n*L\n1#1,40:1\n98#2,3:41\n*S KotlinDebug\n*F\n+ 1 SettingsSyncHistoryAction.kt\ncom/intellij/settingsSync/git/SettingsSyncHistoryAction\n*L\n28#1:41,3\n*E\n"})
final class SettingsSyncHistoryAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        Path settingsSyncStorage = SettingsSyncMain.Companion.getInstance().getControls().getSettingsSyncStorage();
        VirtualFile virtualFile = VfsUtil.findFile((Path)settingsSyncStorage, (boolean)true);
        if (virtualFile == null) {
            Messages.showErrorDialog((String)SettingsSyncBundle.INSTANCE.message("history.error.message", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("history.dialog.title", new Object[0]));
            return;
        }
        String toolWindowId = "SettingsSync";
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
        if (toolWindow == null) {
            RegisterToolWindowTaskBuilder b$iv;
            ToolWindowManager this_$iv = toolWindowManager;
            boolean $i$f$registerToolWindow = false;
            RegisterToolWindowTaskBuilder $this$actionPerformed_u24lambda_u241 = b$iv = new RegisterToolWindowTaskBuilder(toolWindowId);
            boolean bl = false;
            $this$actionPerformed_u24lambda_u241.stripeTitle = SettingsSyncHistoryAction::actionPerformed$lambda$1$lambda$0;
            toolWindow = this_$iv.registerToolWindow(b$iv.build());
        }
        ToolWindow toolWindow2 = toolWindow;
        GitVcs gitVcs = GitVcs.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitVcs, (String)"getInstance(...)");
        GitShowExternalLogActionKt.showExternalGitLogInToolwindow((Project)project2, (ToolWindow)toolWindow2, (GitVcs)gitVcs, (List)CollectionsKt.listOf((Object)virtualFile), (String)SettingsSyncBundle.INSTANCE.message("history.tab.name", new Object[0]), (String)"");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && SettingsSyncMainKt.isSettingsSyncEnabledByKey());
    }

    private static final String actionPerformed$lambda$1$lambda$0() {
        return SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]);
    }
}

