/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.ConfigurationException;
import org.jetbrains.jps.dependency.NodeSerializer;
import org.jetbrains.jps.dependency.NodeSerializerRegistry;
import org.jetbrains.jps.dependency.SerializableGraphElement;
import org.jetbrains.jps.dependency.impl.serializer.FileSourceNodeSerializerImpl;
import org.jetbrains.jps.dependency.impl.serializer.JvmClassNodeSerializerImpl;
import org.jetbrains.jps.dependency.impl.serializer.JvmModuleNodeSerializerImpl;
import org.jetbrains.jps.dependency.impl.serializer.StringReferenceIDNodeSerializerImpl;

public final class SerializerRegistryImpl
implements NodeSerializerRegistry {
    private final Function<SerializableGraphElement, NodeSerializer> mySerializerSelector;
    private final Function<Integer, NodeSerializer> mySerializerIDSelector;
    private static final NodeSerializerRegistry INSTANCE = new SerializerRegistryImpl(Arrays.asList(new FileSourceNodeSerializerImpl(), new StringReferenceIDNodeSerializerImpl(), new JvmClassNodeSerializerImpl(), new JvmModuleNodeSerializerImpl()));

    public static NodeSerializerRegistry getInstance() {
        return INSTANCE;
    }

    private SerializerRegistryImpl(final @NotNull Collection<NodeSerializer> serializers) {
        if (serializers == null) {
            SerializerRegistryImpl.$$$reportNull$$$0(0);
        }
        if (serializers.isEmpty()) {
            throw new ConfigurationException("Should be at least one NodeSerializer registered");
        }
        this.mySerializerSelector = SerializerRegistryImpl.createSerializerSelector(serializers);
        this.mySerializerIDSelector = new Function<Integer, NodeSerializer>(){
            private final Map<Integer, NodeSerializer> myCache = new HashMap<Integer, NodeSerializer>();
            {
                for (NodeSerializer serializer : serializers) {
                    this.myCache.put(serializer.getId(), serializer);
                }
            }

            @Override
            public NodeSerializer apply(Integer serializerId) {
                NodeSerializer serializer = this.myCache.get(serializerId);
                if (serializer == null) {
                    throw new ConfigurationException("No serializers found with ID= " + serializerId);
                }
                return serializer;
            }
        };
    }

    @Override
    public NodeSerializer getSerializer(SerializableGraphElement element) throws ConfigurationException {
        return this.mySerializerSelector.apply(element);
    }

    @Override
    public NodeSerializer getSerializer(int serializerId) throws ConfigurationException {
        return this.mySerializerIDSelector.apply(serializerId);
    }

    private static Function<SerializableGraphElement, NodeSerializer> createSerializerSelector(final Collection<NodeSerializer> serializers) {
        if (serializers.size() == 1) {
            NodeSerializer serializer = serializers.iterator().next();
            return elem -> {
                if (!serializer.isSupported(elem)) {
                    throw new ConfigurationException("The only available NodeSerializer does not support element " + elem);
                }
                return serializer;
            };
        }
        return new Function<SerializableGraphElement, NodeSerializer>(){
            private final Map<Class<? extends SerializableGraphElement>, NodeSerializer> myCache = new HashMap<Class<? extends SerializableGraphElement>, NodeSerializer>();

            @Override
            public NodeSerializer apply(SerializableGraphElement elem) {
                Class<?> implCls = elem.getClass();
                NodeSerializer serializer = this.myCache.get(implCls);
                if (serializer == null) {
                    for (NodeSerializer nodeSerializer : serializers) {
                        if (!nodeSerializer.isSupported(elem)) continue;
                        serializer = nodeSerializer;
                        this.myCache.put(implCls, serializer);
                        break;
                    }
                }
                if (serializer == null) {
                    throw new ConfigurationException("No compatible serializers found for element " + elem);
                }
                return serializer;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializers", "org/jetbrains/jps/dependency/impl/SerializerRegistryImpl", "<init>"));
    }
}

