/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.TypeRepr;

public abstract class JVMClassNode<T extends JVMClassNode<T, D>, D extends Difference>
extends Proto
implements Node<T, D> {
    private final JvmNodeReferenceID myId;
    private final String outFilePath;
    private final Iterable<Usage> myUsages;

    public JVMClassNode(JVMFlags flags, String signature, String name, String outFilePath, @NotNull Iterable<TypeRepr.ClassType> annotations, @NotNull Iterable<Usage> usages) {
        if (annotations == null) {
            JVMClassNode.$$$reportNull$$$0(0);
        }
        if (usages == null) {
            JVMClassNode.$$$reportNull$$$0(1);
        }
        super(flags, signature, name, annotations);
        this.myId = new JvmNodeReferenceID(name);
        this.outFilePath = outFilePath;
        this.myUsages = usages;
    }

    @Override
    @NotNull
    public JvmNodeReferenceID getReferenceID() {
        JvmNodeReferenceID jvmNodeReferenceID = this.myId;
        if (jvmNodeReferenceID == null) {
            JVMClassNode.$$$reportNull$$$0(2);
        }
        return jvmNodeReferenceID;
    }

    public String getOutFilePath() {
        return this.outFilePath;
    }

    @Override
    public Iterable<Usage> getUsages() {
        return this.myUsages;
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        if (!(other instanceof JVMClassNode)) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        JVMClassNode that = (JVMClassNode)other;
        return this.myId.equals(that.myId) && this.outFilePath.equals(that.outFilePath);
    }

    @Override
    public int diffHashCode() {
        return 31 * this.outFilePath.hashCode() + this.myId.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/JVMClassNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/JVMClassNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

