/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;

final class AnyPathRelativizer
implements PathRelativizer {
    private final Path myPath;
    private final String myIdentifier;

    AnyPathRelativizer(@Nullable String path, @NotNull String identifier) {
        if (identifier == null) {
            AnyPathRelativizer.$$$reportNull$$$0(0);
        }
        this.myPath = path != null ? Paths.get(path, new String[0]) : null;
        this.myIdentifier = identifier;
    }

    @Override
    @Nullable
    public String toRelativePath(@NotNull String path) {
        Path rel;
        if (path == null) {
            AnyPathRelativizer.$$$reportNull$$$0(1);
        }
        if (this.myPath == null) {
            return null;
        }
        try {
            rel = this.myPath.relativize(Paths.get(path, new String[0]));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)(this.myIdentifier + "/" + rel));
    }

    @Override
    @Nullable
    public String toAbsolutePath(@NotNull String path) {
        if (path == null) {
            AnyPathRelativizer.$$$reportNull$$$0(2);
        }
        if (this.myPath == null || !path.startsWith(this.myIdentifier)) {
            return null;
        }
        Path abs = Paths.get(this.myPath + path.substring(this.myIdentifier.length()), new String[0]).normalize();
        return FileUtil.toSystemIndependentName((String)abs.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/relativizer/AnyPathRelativizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toRelativePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toAbsolutePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

