/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgChangesetUtil;

public abstract class HgChangesetsCommand {
    private static final Logger LOG = Logger.getInstance((String)HgChangesetsCommand.class.getName());
    protected final Project project;
    @NonNls
    protected final String command;

    public HgChangesetsCommand(Project project, @NonNls String command) {
        this.project = project;
        this.command = command;
    }

    public List<HgRevisionNumber> executeInCurrentThread(VirtualFile repo) {
        return this.getRevisions(repo);
    }

    protected List<HgRevisionNumber> getRevisions(VirtualFile repo) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--template", HgChangesetUtil.makeTemplate("{rev}", "{node}", "{author}", "{desc|firstline}"), "--quiet"));
        this.addArguments(args);
        HgCommandResult result = this.executeCommandInCurrentThread(repo, args);
        if (result == null) {
            return Collections.emptyList();
        }
        String output = result.getRawOutput();
        if (StringUtil.isEmpty((String)output)) {
            return Collections.emptyList();
        }
        String[] changesets = output.split("\u0003");
        ArrayList<HgRevisionNumber> revisions = new ArrayList<HgRevisionNumber>(changesets.length);
        for (String changeset : changesets) {
            List parts = StringUtil.split((String)changeset, (String)"\u0017");
            if (parts.size() >= 3) {
                revisions.add(HgRevisionNumber.getInstance((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), parts.size() > 3 ? (String)parts.get(3) : ""));
                continue;
            }
            LOG.warn("Could not parse changeset [" + changeset + "]");
        }
        return revisions;
    }

    @Nullable
    protected HgCommandResult executeCommandInCurrentThread(VirtualFile repo, List<String> args) {
        HgCommandExecutor executor = new HgCommandExecutor(this.project);
        executor.setSilent(this.isSilentCommand());
        return executor.executeInCurrentThread(repo, this.command, args);
    }

    protected boolean isSilentCommand() {
        return false;
    }

    protected abstract void addArguments(List<@NonNls String> var1);
}

