/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightTestData;
import com.intellij.codeInsight.EditorInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.ProjectScope;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.JavaPsiTestCase;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeInsightTestCase
extends JavaPsiTestCase {
    protected Editor myEditor;

    protected Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(0);
        }
        FileEditorManager instance2 = FileEditorManager.getInstance((Project)this.myProject);
        if (file2.getFileType().isBinary()) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = instance2.openTextEditor(new OpenFileDescriptor(this.myProject, file2, 0), false);
        ((EditorImpl)editor).setCaretActive();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myProject != null) {
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
                for (VirtualFile openFile : editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myEditor = null;
            super.tearDown();
        }
    }

    @Override
    @NotNull
    protected PsiTestData createData() {
        return new CodeInsightTestData();
    }

    protected void configureByFile(String filePath) throws Exception {
        this.configureByFile(filePath, null);
    }

    protected VirtualFile configureByFiles(@Nullable String projectRoot, String ... files) {
        if (files == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(1);
        }
        if (files.length == 0) {
            return null;
        }
        VirtualFile[] vFiles = new VirtualFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            vFiles[i2] = this.findVirtualFile(files[i2]);
            if (vFiles[i2] == null) continue;
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(vFiles[i2], files[i2]);
        }
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        try {
            return this.configureByFiles(projectFile, vFiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected VirtualFile configureByFile(@NotNull String filePath, @Nullable String projectRoot) throws Exception {
        if (filePath == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(2);
        }
        VirtualFile vFile = this.findVirtualFile(filePath);
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFile(vFile, projectFile);
    }

    protected PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        if (fileType == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(3);
        }
        if (text == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(4);
        }
        return this.configureByText(fileType, text, null);
    }

    protected PsiFile configureByText(@NotNull FileType fileType, @NotNull String text, @Nullable String _extension) {
        if (fileType == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(5);
        }
        if (text == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(6);
        }
        try {
            String extension = _extension == null ? fileType.getDefaultExtension() : _extension;
            File dir = this.createTempDirectory();
            File tempFile = FileUtil.createTempFile((File)dir, (String)"tempFile", (String)("." + extension), (boolean)true);
            CodeInsightTestFixtureImpl.associateExtensionTemporarily(fileType, extension, this.getTestRootDisposable());
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
            assert (vFile != null);
            WriteAction.runAndWait(() -> {
                vFile.setCharset(StandardCharsets.UTF_8);
                VfsUtil.saveText((VirtualFile)vFile, (String)text);
            });
            VirtualFile vdir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            PsiTestUtil.addSourceRoot(this.myModule, vdir);
            this.configureByExistingFile(vFile);
            JavaCodeInsightTestCase.assertEquals((Object)fileType, (Object)this.myFile.getVirtualFile().getFileType());
            return this.myFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureByFile(@NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(7);
        }
        this.configureByFile(vFile, null);
    }

    protected void configureByExistingFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(8);
        }
        this.myFile = null;
        this.myEditor = null;
        Editor editor = this.createEditor(virtualFile);
        Document document = editor.getDocument();
        EditorInfo editorInfo = new EditorInfo(document.getText());
        String newFileText = editorInfo.getNewFileText();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!document.getText().equals(newFileText)) {
                document.setText((CharSequence)newFileText);
            }
            PsiFile file2 = this.myPsiManager.findFile(virtualFile);
            if (this.myFile == null) {
                this.myFile = file2;
            }
            if (this.myEditor == null) {
                this.myEditor = editor;
            }
            editorInfo.applyToEditor(editor);
        });
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
    }

    @Deprecated
    public VirtualFile doConfigureByFiles(@Nullable File rawProjectRoot, VirtualFile ... vFiles) throws IOException {
        if (vFiles == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(9);
        }
        return this.configureByFiles(rawProjectRoot, vFiles);
    }

    protected VirtualFile configureByFiles(@Nullable File rawProjectRoot, VirtualFile ... vFiles) throws IOException {
        if (vFiles == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(10);
        }
        this.myFile = null;
        this.myEditor = null;
        VirtualFile toDir = this.createVirtualDirectoryForContentFile();
        Map editorInfos = (Map)WriteAction.compute(() -> {
            try {
                boolean bl;
                Map<VirtualFile, EditorInfo> editorInfos1;
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
                ModifiableRootModel rootModel = rootManager.getModifiableModel();
                if (this.clearModelBeforeConfiguring()) {
                    rootModel.clear();
                }
                Object[] reversed = (VirtualFile[])ArrayUtil.reverseArray((Object[])vFiles);
                if (rawProjectRoot != null) {
                    FileUtil.copyDir((File)rawProjectRoot, (File)toDir.toNioPath().toFile());
                    File file2 = rawProjectRoot.getCanonicalFile();
                    VirtualFile aNull = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
                    editorInfos1 = this.copyFilesFillingEditorInfos(aNull, toDir, (String[])ContainerUtil.map2Array((Object[])reversed, String.class, s -> s.getPath().substring(file2.getPath().length())));
                    toDir.refresh(false, true);
                } else {
                    editorInfos1 = new LinkedHashMap<VirtualFile, EditorInfo>();
                    for (VirtualFile virtualFile : reversed) {
                        VirtualFile parent = virtualFile.getParent();
                        assert (parent.isDirectory()) : parent;
                        editorInfos1.putAll(this.copyFilesFillingEditorInfos(parent, toDir, virtualFile.getName()));
                    }
                }
                boolean bl2 = false;
                if (this.isAddDirToContentRoot()) {
                    ContentEntry contentEntry = rootModel.addContentEntry(toDir);
                    if (this.isAddDirToSource()) {
                        bl = true;
                        contentEntry.addSourceFolder(toDir, this.isAddDirToTests());
                    }
                }
                this.doCommitModel(rootModel);
                if (bl) {
                    this.sourceRootAdded(toDir);
                }
                return editorInfos1;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        });
        if (editorInfos != null) {
            List<Editor> list = this.openEditors(editorInfos);
            this.setActiveEditor((Editor)ContainerUtil.getLastItem(list));
        }
        return toDir;
    }

    @NotNull
    protected VirtualFile createVirtualDirectoryForContentFile() {
        VirtualFile virtualFile = this.getTempDir().createVirtualDir();
        if (virtualFile == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    protected boolean isAddDirToTests() {
        return false;
    }

    protected void doCommitModel(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(12);
        }
        rootModel.commit();
    }

    protected void sourceRootAdded(VirtualFile dir) {
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull String testDataFromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        if (testDataFromDir == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(13);
        }
        if (toDir == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(14);
        }
        if (relativePaths == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(15);
        }
        if (!((String)testDataFromDir).startsWith("/")) {
            testDataFromDir = "/" + (String)testDataFromDir;
        }
        Map<VirtualFile, EditorInfo> map = this.copyFilesFillingEditorInfos(LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getTestDataPath() + (String)testDataFromDir), toDir, relativePaths);
        if (map == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        if (fromDir == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(17);
        }
        if (toDir == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(18);
        }
        if (relativePaths == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(19);
        }
        LinkedHashMap<VirtualFile, EditorInfo> editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
        ArrayList streamsToClose = new ArrayList();
        for (String relativePath : relativePaths) {
            relativePath = StringUtil.trimStart((String)relativePath, (String)"/");
            VirtualFile fromFile = fromDir.findFileByRelativePath(relativePath);
            JavaCodeInsightTestCase.assertNotNull((String)(fromDir.getPath() + "/" + relativePath), (Object)fromFile);
            VirtualFile toFile = toDir.findFileByRelativePath(relativePath);
            if (toFile == null) {
                File file2 = new File(toDir.getPath(), relativePath);
                FileUtil.createIfDoesntExist((File)file2);
                toFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
                JavaCodeInsightTestCase.assertNotNull((String)file2.getCanonicalPath(), (Object)toFile);
            }
            toFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)FileUtil.toSystemDependentName((String)fromFile.getPath()));
            editorInfos.put(toFile, this.copyContent(fromFile, toFile, streamsToClose));
        }
        for (int i2 = streamsToClose.size() - 1; i2 >= 0; --i2) {
            ((OutputStream)streamsToClose.get(i2)).close();
        }
        LinkedHashMap<VirtualFile, EditorInfo> linkedHashMap = editorInfos;
        if (linkedHashMap == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    private EditorInfo copyContent(@NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull List<? super OutputStream> streamsToClose) throws IOException {
        if (from == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(21);
        }
        if (to == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(22);
        }
        if (streamsToClose == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(23);
        }
        byte[] content = from.getFileType().isBinary() ? from.contentsToByteArray() : null;
        String fileText = from.getFileType().isBinary() ? null : StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)from));
        EditorInfo editorInfo = fileText == null ? null : new EditorInfo(fileText);
        String newFileText = fileText == null ? null : editorInfo.getNewFileText();
        this.doWrite(newFileText, to, content, streamsToClose);
        return editorInfo;
    }

    protected final void setActiveEditor(@NotNull Editor editor) {
        if (editor == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(24);
        }
        this.myEditor = editor;
        this.myFile = this.getPsiFile(editor.getDocument());
    }

    @Deprecated
    @NotNull
    protected List<Editor> openEditorsAndActivateLast(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        if (editorInfos == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(25);
        }
        List<Editor> list = this.openEditors(editorInfos);
        this.setActiveEditor(list.get(list.size() - 1));
        List<Editor> list2 = list;
        if (list2 == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    protected final List<Editor> openEditors(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        if (editorInfos == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(27);
        }
        List list = ContainerUtil.map(editorInfos.keySet(), newVFile -> {
            EditorInfo editorInfo;
            PsiFile file2 = this.myPsiManager.findFile(newVFile);
            if (this.myFile == null) {
                this.myFile = file2;
            }
            Editor editor = this.createEditor((VirtualFile)newVFile);
            if (this.myEditor == null) {
                this.myEditor = editor;
            }
            if ((editorInfo = (EditorInfo)editorInfos.get(newVFile)) != null) {
                editorInfo.applyToEditor(editor);
            }
            return editor;
        });
        if (list == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(28);
        }
        return list;
    }

    private void doWrite(String newFileText, @NotNull VirtualFile newVFile, byte[] content, @NotNull List<? super OutputStream> streamsToClose) throws IOException {
        if (newVFile == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(29);
        }
        if (streamsToClose == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(30);
        }
        if (newFileText == null) {
            OutputStream outputStream = newVFile.getOutputStream((Object)this, -1L, -1L);
            outputStream.write(content);
            streamsToClose.add(outputStream);
        } else {
            JavaCodeInsightTestCase.setFileText(newVFile, newFileText);
        }
    }

    protected boolean isAddDirToContentRoot() {
        return true;
    }

    protected boolean isAddDirToSource() {
        return true;
    }

    protected VirtualFile configureByFile(@NotNull VirtualFile vFile, File projectRoot) throws IOException {
        if (vFile == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(31);
        }
        return this.configureByFiles(projectRoot, vFile);
    }

    protected boolean clearModelBeforeConfiguring() {
        return false;
    }

    @Deprecated
    protected void setupCursorAndSelection(@NotNull Editor editor) {
        if (editor == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(32);
        }
        Document document = editor.getDocument();
        EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
        EditorTestUtil.setCaretsAndSelection(editor, caretState);
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @Override
    @Deprecated
    protected void configure(@NotNull String path, String dataName) throws Exception {
        int selectionEnd;
        if (path == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(33);
        }
        super.configure(path, dataName);
        this.myEditor = this.createEditor(this.myFile.getVirtualFile());
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataBefore;
        LogicalPosition pos = new LogicalPosition(data.getLineNumber() - 1, data.getColumnNumber() - 1);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        int selectionStart = selectionEnd = this.myEditor.getCaretModel().getOffset();
        if (data.getSelectionStartColumnNumber() >= 0) {
            selectionStart = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionStartLineNumber() - 1, data.getSelectionStartColumnNumber() - 1));
            selectionEnd = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionEndColumnNumber() - 1));
        }
        this.myEditor.getSelectionModel().setSelection(selectionStart, selectionEnd);
    }

    protected void checkResultByFile(@NotNull String filePath) throws Exception {
        if (filePath == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(34);
        }
        this.checkResultByFile(filePath, false);
    }

    protected void checkResultByFile(@NotNull String filePath, boolean stripTrailingSpaces) throws Exception {
        if (filePath == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(35);
        }
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            String expectedText;
            PostprocessReformattingAspect.getInstance((Project)this.getProject()).doPostponedFormatting();
            if (stripTrailingSpaces) {
                ((DocumentImpl)this.myEditor.getDocument()).stripTrailingSpaces(this.getProject());
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            VirtualFile vFile = this.findVirtualFile(filePath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(vFile, filePath);
            try {
                expectedText = VfsUtilCore.loadText((VirtualFile)vFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            expectedText = StringUtil.convertLineSeparators((String)expectedText);
            Document document = EditorFactory.getInstance().createDocument((CharSequence)expectedText);
            EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            expectedText = document.getText();
            if (stripTrailingSpaces) {
                Document document1 = EditorFactory.getInstance().createDocument((CharSequence)expectedText);
                ((DocumentImpl)document1).stripTrailingSpaces(this.getProject());
                expectedText = document1.getText();
            }
            if (this.myEditor instanceof EditorWindow) {
                this.myEditor = ((EditorWindow)this.myEditor).getDelegate();
            }
            this.myFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.myEditor.getDocument());
            String actualText = StringUtil.convertLineSeparators((String)this.myFile.getText());
            if (!Objects.equals(expectedText, actualText)) {
                throw new FileComparisonFailure("Text mismatch in file " + filePath, expectedText, actualText, vFile.getPath());
            }
            EditorTestUtil.verifyCaretAndSelectionState(this.myEditor, caretState);
        });
    }

    @Override
    @Deprecated
    protected void checkResult(String dataName) throws Exception {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        super.checkResult(dataName);
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataAfter;
        if (data.getColumnNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":caretColumn"), (int)data.getColumnNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (data.getLineNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":caretLine"), (int)data.getLineNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
        }
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        LogicalPosition startPosition = this.myEditor.offsetToLogicalPosition(selectionStart);
        LogicalPosition endPosition = this.myEditor.offsetToLogicalPosition(selectionEnd);
        if (data.getSelectionStartColumnNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartColumn"), (int)data.getSelectionStartColumnNumber(), (int)(startPosition.column + 1));
        }
        if (data.getSelectionStartLineNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartLine"), (int)data.getSelectionStartLineNumber(), (int)(startPosition.line + 1));
        }
        if (data.getSelectionEndColumnNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndColumn"), (int)data.getSelectionEndColumnNumber(), (int)(endPosition.column + 1));
        }
        if (data.getSelectionEndLineNumber() >= 0) {
            JavaCodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndLine"), (int)data.getSelectionEndLineNumber(), (int)(endPosition.line + 1));
        }
    }

    @NotNull
    protected VirtualFile findVirtualFile(@NotNull String filePath) {
        if (filePath == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(36);
        }
        String absolutePath = this.getTestDataPath() + filePath;
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{absolutePath});
        VirtualFile virtualFile = VfsTestUtil.findFileByCaseSensitivePath(absolutePath);
        if (virtualFile == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(37);
        }
        return virtualFile;
    }

    @NotNull
    protected String getTestRoot() {
        String string = FileUtil.toSystemIndependentName((String)this.getTestDataPath());
        if (string == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(38);
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type(c, this.getEditor(), this.getProject());
    }

    protected void undo() {
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(this.getEditor());
        undoManager.undo((FileEditor)textEditor);
    }

    protected void caretLeft() {
        this.caretLeft(this.getEditor());
    }

    protected void caretLeft(@NotNull Editor editor) {
        if (editor == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(39);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorLeft", editor, this.getProject());
    }

    protected void caretRight() {
        this.caretRight(this.getEditor());
    }

    protected void caretRight(@NotNull Editor editor) {
        if (editor == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(40);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorRight", editor, this.getProject());
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp", this.myEditor, this.getProject());
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(this.myEditor, this.getProject());
    }

    protected void type(@NotNull String s) {
        if (s == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(41);
        }
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void backspace() {
        this.backspace(this.getEditor());
    }

    protected void backspace(@NotNull Editor editor) {
        if (editor == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(42);
        }
        LightPlatformCodeInsightTestCase.backspace(editor, this.getProject());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(this.getEditor(), this.getProject());
    }

    protected void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(this.getEditor(), this.getProject());
    }

    protected void delete(@NotNull Editor editor) {
        if (editor == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(43);
        }
        LightPlatformCodeInsightTestCase.delete(editor, this.getProject());
    }

    @NotNull
    protected PsiClass findClass(@NotNull String name) {
        if (name == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(44);
        }
        PsiClass aClass = this.myJavaFacade.findClass(name, ProjectScope.getProjectScope((Project)this.getProject()));
        JavaCodeInsightTestCase.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(45);
        }
        return psiClass;
    }

    @NotNull
    protected PsiPackage findPackage(@NotNull String name) {
        if (name == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(46);
        }
        PsiPackage aPackage = this.myJavaFacade.findPackage(name);
        JavaCodeInsightTestCase.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        PsiPackage psiPackage = aPackage;
        if (psiPackage == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(47);
        }
        return psiPackage;
    }

    protected void setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaCodeInsightTestCase.$$$reportNull$$$0(48);
        }
        LanguageLevelProjectExtension.getInstance((Project)this.getProject()).setLanguageLevel(level);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 16, 20, 26, 28, 37, 38, 45, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFiles";
                break;
            }
            case 11: 
            case 16: 
            case 20: 
            case 26: 
            case 28: 
            case 37: 
            case 38: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/JavaCodeInsightTestCase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFromDir";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamsToClose";
                break;
            }
            case 24: 
            case 32: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/JavaCodeInsightTestCase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualDirectoryForContentFile";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFilesFillingEditorInfos";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditorsAndActivateLast";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditors";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoot";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 1: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureByFiles";
                break;
            }
            case 2: 
            case 7: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureByExistingFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doConfigureByFiles";
                break;
            }
            case 11: 
            case 16: 
            case 20: 
            case 26: 
            case 28: 
            case 37: 
            case 38: 
            case 45: 
            case 47: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCommitModel";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyFilesFillingEditorInfos";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setActiveEditor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openEditorsAndActivateLast";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "openEditors";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doWrite";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupCursorAndSelection";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "caretLeft";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "caretRight";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "backspace";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 16, 20, 26, 28, 37, 38, 45, 47 -> new IllegalStateException(string);
        };
    }
}

