/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Property;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.EnvironmentVariablesDataOptions;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.ValueWithDefault;

@com.intellij.openapi.components.State(name="TerminalProjectNonSharedOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002)*B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0007J\u0018\u0010\u0019\u001a\u00020\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001bH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0002H\u0016J\u0018\u0010\"\u001a\u00020#2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001bH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u000e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020 R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u0010R/\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultStartingDirectory", "", "getDefaultStartingDirectory", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "shellPath", "getShellPath", "setShellPath", "(Ljava/lang/String;)V", "<set-?>", "startingDirectory", "getStartingDirectory", "setStartingDirectory", "startingDirectory$delegate", "Lorg/jetbrains/plugins/terminal/ValueWithDefault;", "state", "defaultShellPath", "findDefaultShellPath", "workingDirectory", "Lkotlin/Function0;", "findWslDistributionName", "directory", "getDefaultWorkingDirectory", "getEnvData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getState", "isProjectLevelShellPath", "", "loadState", "", "newState", "setEnvData", "envData", "Companion", "State", "intellij.terminal"})
public final class TerminalProjectOptionsProvider
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final State state;
    @NotNull
    private final ValueWithDefault startingDirectory$delegate;
    @NotNull
    private static final Logger LOG;

    public TerminalProjectOptionsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = new State();
        this.startingDirectory$delegate = new ValueWithDefault((KMutableProperty0)new MutablePropertyReference0Impl(this.state){

            @Nullable
            public Object get() {
                return ((State)this.receiver).getStartingDirectory();
            }

            public void set(@Nullable Object value) {
                ((State)this.receiver).setStartingDirectory((String)value);
            }
        }, (Function0)new Function0<String>(this){
            final /* synthetic */ TerminalProjectOptionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.this$0.getDefaultStartingDirectory();
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state.setStartingDirectory(newState.getStartingDirectory());
        this.state.setShellPath(newState.getShellPath());
        this.state.setEnvDataOptions(newState.getEnvDataOptions());
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.state.getEnvDataOptions().get();
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData envData) {
        Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
        this.state.getEnvDataOptions().set(envData);
    }

    @Nullable
    public final String getStartingDirectory() {
        return this.startingDirectory$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setStartingDirectory(@Nullable String string) {
        this.startingDirectory$delegate.setValue(this, $$delegatedProperties[0], string);
    }

    @Nullable
    public final String getDefaultStartingDirectory() {
        String directory = null;
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                directory = customizer.getDefaultFolder(this.project);
                if (directory == null) continue;
                break;
            }
            catch (Exception e) {
                LOG.error("Exception during getting default folder", (Throwable)e);
            }
        }
        if (directory == null) {
            directory = this.getDefaultWorkingDirectory();
        }
        String string = directory;
        return string != null ? FileUtil.toSystemDependentName((String)string) : null;
    }

    private final String getDefaultWorkingDirectory() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        return virtualFile != null ? virtualFile.getCanonicalPath() : null;
    }

    @NotNull
    public final String getShellPath() {
        Lazy workingDirectoryLazy2 = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TerminalProjectOptionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.this$0.getStartingDirectory();
            }
        }));
        String shellPath2 = this.isProjectLevelShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy2){

            @Nullable
            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        })) && TrustedProjects.isTrusted((Project)this.project) ? this.state.getShellPath() : TerminalOptionsProvider.Companion.getInstance().getShellPath();
        CharSequence charSequence = shellPath2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return this.findDefaultShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy2){

                @Nullable
                public Object get() {
                    return ((Lazy)this.receiver).getValue();
                }
            }));
        }
        return shellPath2;
    }

    public final void setShellPath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Lazy workingDirectoryLazy2 = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TerminalProjectOptionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.this$0.getStartingDirectory();
            }
        }));
        String valueToStore2 = Strings.nullize((String)value, (String)this.findDefaultShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy2){

            @Nullable
            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        })));
        if (this.isProjectLevelShellPath((Function0<String>)((Function0)new PropertyReference0Impl(workingDirectoryLazy2){

            @Nullable
            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        }))) {
            this.state.setShellPath(valueToStore2);
        } else {
            TerminalOptionsProvider.Companion.getInstance().setShellPath(valueToStore2);
        }
    }

    private final boolean isProjectLevelShellPath(Function0<String> workingDirectory) {
        return SystemInfo.isWindows && this.findWslDistributionName((String)workingDirectory.invoke()) != null;
    }

    @NotNull
    public final String defaultShellPath() {
        return this.findDefaultShellPath((Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ TerminalProjectOptionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.this$0.getStartingDirectory();
            }
        }));
    }

    private final String findDefaultShellPath(Function0<String> workingDirectory) {
        String wslDistributionName;
        if (SystemInfo.isWindows && (wslDistributionName = this.findWslDistributionName((String)workingDirectory.invoke())) != null) {
            return "wsl.exe --distribution " + wslDistributionName;
        }
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            return shell;
        }
        if (SystemInfo.isUnix) {
            String bashPath = "/bin/bash";
            if (new File(bashPath).exists()) {
                return bashPath;
            }
            return "/bin/sh";
        }
        return "powershell.exe";
    }

    private final String findWslDistributionName(String directory) {
        String string;
        String string2 = directory;
        if (string2 == null) {
            string = null;
        } else {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(string2);
            string = wslPath != null ? wslPath.getDistributionId() : null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TerminalProjectOptionsProvider.class, "startingDirectory", "getStartingDirectory()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(TerminalProjectOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TerminalProjectOptionsProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TerminalProjectOptionsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "", "()V", "envDataOptions", "Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;", "getEnvDataOptions", "()Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;", "setEnvDataOptions", "(Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;)V", "shellPath", "", "getShellPath", "()Ljava/lang/String;", "setShellPath", "(Ljava/lang/String;)V", "startingDirectory", "getStartingDirectory", "setStartingDirectory", "intellij.terminal"})
    public static final class State {
        @Nullable
        private String startingDirectory;
        @Nullable
        private String shellPath;
        @NotNull
        private EnvironmentVariablesDataOptions envDataOptions = new EnvironmentVariablesDataOptions();

        @Nullable
        public final String getStartingDirectory() {
            return this.startingDirectory;
        }

        public final void setStartingDirectory(@Nullable String string) {
            this.startingDirectory = string;
        }

        @Nullable
        public final String getShellPath() {
            return this.shellPath;
        }

        public final void setShellPath(@Nullable String string) {
            this.shellPath = string;
        }

        @Property(surroundWithTag=false, flat=true)
        @NotNull
        public final EnvironmentVariablesDataOptions getEnvDataOptions() {
            return this.envDataOptions;
        }

        public final void setEnvDataOptions(@NotNull EnvironmentVariablesDataOptions environmentVariablesDataOptions) {
            Intrinsics.checkNotNullParameter((Object)((Object)environmentVariablesDataOptions), (String)"<set-?>");
            this.envDataOptions = environmentVariablesDataOptions;
        }
    }
}

