/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.linux;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.linux.AllVariablesAreOK;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesFixer;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.linux.VariableValidationResult;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u001e\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\"\u0010\r\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkKernelVariables", "Lcom/intellij/profiler/linux/ValidationResult;", "variables", "", "Lcom/intellij/profiler/linux/KernelVariable;", "fixer", "Lcom/intellij/profiler/linux/KernelVariablesFixer;", "checkKernelVariablesOnLinuxOnly", "validateVariables", "", "AllVariablesValidationResult", "", "Lcom/intellij/profiler/linux/VariableValidationResult;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nKernelVariablesValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelVariablesValidator.kt\ncom/intellij/profiler/linux/KernelVariablesValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1271#2,2:157\n1285#2,4:159\n1726#2,3:163\n*S KotlinDebug\n*F\n+ 1 KernelVariablesValidator.kt\ncom/intellij/profiler/linux/KernelVariablesValidatorKt\n*L\n137#1:157,2\n137#1:159,4\n138#1:163,3\n*E\n"})
public final class KernelVariablesValidatorKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    private static final ValidationResult validateVariables(Collection<? extends KernelVariable> variables, KernelVariablesFixer fixer) {
        boolean bl;
        Map result2;
        block4: {
            Iterable $this$associateWith$iv = variables;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                KernelVariable kernelVariable = (KernelVariable)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl2 = false;
                VariableValidationResult variableValidationResult = it.validate();
                map2.put(t, variableValidationResult);
            }
            result2 = result$iv;
            Iterable $this$all$iv = result2.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VariableValidationResult it = (VariableValidationResult)element$iv;
                    boolean bl3 = false;
                    if (it instanceof OK) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl ? (ValidationResult)AllVariablesAreOK.INSTANCE : (ValidationResult)new HasInvalidVariables(result2, fixer);
    }

    @NotNull
    public static final ValidationResult checkKernelVariablesOnLinuxOnly(@NotNull List<? extends KernelVariable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        if (!SystemInfo.isLinux) {
            return AllVariablesAreOK.INSTANCE;
        }
        return KernelVariablesValidatorKt.checkKernelVariables(variables);
    }

    @NotNull
    public static final ValidationResult checkKernelVariables(@NotNull List<? extends KernelVariable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        if (!Registry.is((String)"linux.kernel.variables.validate.every.time")) {
            return AllVariablesAreOK.INSTANCE;
        }
        return KernelVariablesValidatorKt.validateVariables((Collection<? extends KernelVariable>)variables, new KernelVariablesFixer());
    }

    @NotNull
    public static final ValidationResult checkKernelVariables(@NotNull List<? extends KernelVariable> variables, @NotNull KernelVariablesFixer fixer) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)fixer, (String)"fixer");
        if (!Registry.is((String)"linux.kernel.variables.validate.every.time")) {
            return AllVariablesAreOK.INSTANCE;
        }
        return KernelVariablesValidatorKt.validateVariables((Collection<? extends KernelVariable>)variables, fixer);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.profiler.linux.KernelVariablesValidator");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

