/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.statistic;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.CompileStatisticsData;
import org.jetbrains.kotlin.build.report.statistics.HttpReportService;
import org.jetbrains.kotlin.build.report.statistics.file.FileReportService;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinLogger;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporterImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService;", "", "()V", "contextMetrics", "Ljava/util/HashMap;", "Lorg/jetbrains/jps/incremental/CompileContext;", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "fileReportSettings", "Lorg/jetbrains/kotlin/build/report/FileReportSettings;", "httpReportSettings", "Lorg/jetbrains/kotlin/build/report/HttpReportSettings;", "httpService", "Lorg/jetbrains/kotlin/build/report/statistics/HttpReportService;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loggerAdapter", "Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinLogger;", "buildFinished", "", "context", "buildStarted", "Companion", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nJpsStatisticsReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class JpsStatisticsReportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FileReportSettings fileReportSettings = org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportService$Companion.access$initFileReportSettings(Companion);
    @Nullable
    private final HttpReportSettings httpReportSettings = org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportService$Companion.access$initHttpReportSettings(Companion);
    @NotNull
    private final HashMap<CompileContext, JpsBuilderMetricReporter> contextMetrics = new HashMap();
    @NotNull
    private final Logger log;
    @NotNull
    private final JpsKotlinLogger loggerAdapter;
    @Nullable
    private final HttpReportService httpService;

    public JpsStatisticsReportService() {
        HttpReportService httpReportService;
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.statistic.KotlinBuilderReportService");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#org.jetbra\u2026linBuilderReportService\")");
        this.log = logger;
        this.loggerAdapter = new JpsKotlinLogger(this.log);
        JpsStatisticsReportService jpsStatisticsReportService = this;
        HttpReportSettings httpReportSettings = this.httpReportSettings;
        if (httpReportSettings != null) {
            HttpReportSettings it = httpReportSettings;
            JpsStatisticsReportService jpsStatisticsReportService2 = jpsStatisticsReportService;
            boolean bl = false;
            httpReportService = new HttpReportService(it.getUrl(), it.getUser(), it.getPassword());
            jpsStatisticsReportService = jpsStatisticsReportService2;
        } else {
            httpReportService = null;
        }
        jpsStatisticsReportService.httpService = httpReportService;
    }

    public final void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.contextMetrics.get(context) != null) {
            this.log.error("Service already initialized for context");
        }
        ((Map)this.contextMetrics).put(context, new JpsBuilderMetricReporterImpl(new BuildMetricsReporterImpl()));
    }

    public final void buildFinished(@NotNull CompileContext context) {
        block2: {
            FileReportSettings fileReportSettings;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JpsBuilderMetricReporter metrics = this.contextMetrics.remove(context);
            if (metrics == null) {
                this.log.error("Service hasn't initialized for context");
                return;
            }
            CompileStatisticsData compileStatisticsData = metrics.flush(context);
            HttpReportService httpReportService = this.httpService;
            if (httpReportService != null) {
                httpReportService.sendData(compileStatisticsData, this.loggerAdapter);
            }
            FileReportSettings fileReportSettings2 = this.fileReportSettings;
            if (fileReportSettings2 == null) break block2;
            FileReportSettings it = fileReportSettings = fileReportSettings2;
            boolean bl = false;
            FileReportService.process$default(new FileReportService(it.getBuildReportDir(), true, this.loggerAdapter), CollectionsKt.listOf((Object)compileStatisticsData), new BuildStartParameters(CollectionsKt.listOf((Object)"JPS build"), null, null, null, null, 30, null), null, 4, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService$Companion;", "", "()V", "initFileReportSettings", "Lorg/jetbrains/kotlin/build/report/FileReportSettings;", "initHttpReportSettings", "Lorg/jetbrains/kotlin/build/report/HttpReportSettings;", "jps-plugin"})
    @SourceDebugExtension(value={"SMAP\nJpsStatisticsReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final FileReportSettings initFileReportSettings() {
            FileReportSettings fileReportSettings;
            String string2 = System.getProperty("kotlin.build.report.file.output_dir");
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                fileReportSettings = new FileReportSettings(new File(it), false, 2, null);
            } else {
                fileReportSettings = null;
            }
            return fileReportSettings;
        }

        private final HttpReportSettings initHttpReportSettings() {
            String string2 = System.getProperty("kotlin.build.report.http.url");
            if (string2 == null) {
                return null;
            }
            String httpReportUrl = string2;
            String httpReportUser = System.getProperty("kotlin.build.report.http.user");
            String httpReportPassword = System.getProperty("kotlin.build.report.http.password");
            boolean includeGitBranch = Boolean.parseBoolean(System.getProperty("kotlin.build.report.http.git_branch", "false"));
            boolean verboseEnvironment = Boolean.parseBoolean(System.getProperty("kotlin.build.report.http.environment.verbose", "false"));
            return new HttpReportSettings(httpReportUrl, httpReportUser, httpReportPassword, verboseEnvironment, includeGitBranch);
        }

        public static final /* synthetic */ FileReportSettings access$initFileReportSettings(Companion $this) {
            return $this.initFileReportSettings();
        }

        public static final /* synthetic */ HttpReportSettings access$initHttpReportSettings(Companion $this) {
            return $this.initHttpReportSettings();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

