/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.popup;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.uiautomation.BeControlSize;
import com.jetbrains.ide.model.uiautomation.DialogResult;
import com.jetbrains.rd.ide.model.BeAbstractPopup;
import com.jetbrains.rd.ide.model.BePopupPositionActiveWindowContext;
import com.jetbrains.rd.ide.model.BePopupPositionComponentContext;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionDataContextContext;
import com.jetbrains.rd.ide.model.BePopupPositionFocusContext;
import com.jetbrains.rd.ide.model.BePopupPositionMousePositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionScreenPointContext;
import com.jetbrains.rd.ide.model.BePopupPositionTreeOrTableSelectedItemContext;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ConverterStorage;
import com.jetbrains.rd.ui.bindable.popup.BeShowPopupHandler;
import com.jetbrains.rd.ui.bindable.popup.PopupProvider;
import com.jetbrains.rd.ui.bindable.popup.PopupViewControl;
import com.jetbrains.rd.ui.bindable.views.contextProviders.BeContextProvider;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.ui.bindable.views.utils.MarginTypesKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/bindable/popup/PopupViewControl;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rd/ide/model/BeAbstractPopup;", "isReflection", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/BeAbstractPopup;Z)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "loadPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "showPopup", "", "popup", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.ui"})
public final class PopupViewControl {
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final Project project;
    @NotNull
    private final BeAbstractPopup model;
    private final boolean isReflection;

    public PopupViewControl(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull BeAbstractPopup model, boolean isReflection) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.lifetime = lifetime;
        this.project = project;
        this.model = model;
        this.isReflection = isReflection;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final void showPopup() {
        JBPopup popup = this.loadPopup();
        this.model.getLoaded().advise(this.lifetime, (Function1)new Function1<Unit, Unit>(popup, this){
            final /* synthetic */ JBPopup $popup;
            final /* synthetic */ PopupViewControl this$0;
            {
                this.$popup = $popup;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> showPopup.1.invoke$lambda$0((Function1)new Function1<DataContext, Unit>(this.$popup, this.this$0){
                    final /* synthetic */ JBPopup $popup;
                    final /* synthetic */ PopupViewControl this$0;
                    {
                        this.$popup = $popup;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(DataContext dataContext) {
                        SwingUtilities.invokeLater(() -> showPopup.1.invoke$lambda$0(this.$popup, this.this$0, dataContext));
                    }

                    private static final void invoke$lambda$0(JBPopup $popup, PopupViewControl this$0, DataContext $dataContext) {
                        Intrinsics.checkNotNullParameter((Object)$popup, (String)"$popup");
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        if ($popup.isDisposed()) {
                            return;
                        }
                        Intrinsics.checkNotNull((Object)$dataContext);
                        PopupViewControl.access$showPopup(this$0, $popup, $dataContext);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        });
    }

    private final JBPopup loadPopup() {
        JBPopup jBPopup = PopupProvider.Companion.getPopup(this.lifetime, this.project, this.model);
        if (jBPopup == null) {
            throw new IllegalStateException();
        }
        JBPopup popup = jBPopup;
        if (popup instanceof AbstractPopup) {
            ((AbstractPopup)popup).setStretchToOwnerWidth(this.model.getSettings().getStretchToOwnerWidth());
            ((AbstractPopup)popup).setStretchToOwnerHeight(this.model.getSettings().getStretchToOwnerHeight());
            ((AbstractPopup)popup).setOkHandler(() -> PopupViewControl.loadPopup$lambda$0(this));
        }
        this.model.getResult().advise(this.lifetime, (Function1)new Function1<DialogResult, Unit>(popup){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
                super(1);
            }

            public final void invoke(@NotNull DialogResult it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                if (it == DialogResult.CLOSE && !this.$popup.isDisposed()) {
                    this.$popup.cancel(null);
                }
            }
        });
        ISource iSource = this.model.getTitle();
        if (iSource != null && (iSource = iSource.getText()) != null && (iSource = iSource.getChange()) != null) {
            iSource.advise(this.lifetime, (Function1)new Function1<String, Unit>(popup){
                final /* synthetic */ JBPopup $popup;
                {
                    this.$popup = $popup;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$popup.setCaption(it);
                }
            });
        }
        this.model.getResize().advise(this.lifetime, (Function1)new Function1<BeControlSize, Unit>(popup){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
                super(1);
            }

            public final void invoke(@NotNull BeControlSize it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Pair<Integer, Integer> size = MarginTypesKt.getSize(it);
                if (((Number)size.getFirst()).intValue() < 0 || ((Number)size.getSecond()).intValue() < 0) {
                    BeUtilKt.resizePopup$default(this.$popup, false, false, 3, null);
                } else {
                    this.$popup.setSize(new Dimension(((Number)size.getFirst()).intValue(), ((Number)size.getSecond()).intValue()));
                }
            }
        });
        this.lifetime.onTermination((Function0)new Function0<Unit>(this, popup){
            final /* synthetic */ PopupViewControl this$0;
            final /* synthetic */ JBPopup $popup;
            {
                this.this$0 = $receiver;
                this.$popup = $popup;
                super(0);
            }

            public final void invoke() {
                PopupViewControl.access$getModel$p(this.this$0).getResult().set((Object)((Object)DialogResult.CLOSE));
                if (this.$popup.isDisposed()) {
                    return;
                }
                this.$popup.cancel();
                Disposer.dispose((Disposable)((Disposable)this.$popup));
            }
        });
        if (this.isReflection) {
            popup.addListener(new JBPopupListener(){

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    JPanel glassPane = new JPanel();
                    glassPane.setOpaque(false);
                    glassPane.setVisible(true);
                    glassPane.addMouseListener(new MouseAdapter(){});
                    glassPane.addKeyListener(new KeyAdapter(){});
                    JRootPane rootPane = SwingUtilities.getRootPane(event.asPopup().getContent());
                    if (rootPane != null) {
                        rootPane.setGlassPane(glassPane);
                    }
                }
            });
        }
        return popup;
    }

    private final void showPopup(JBPopup popup, DataContext dataContext) {
        BePopupPositionContext bePopupPositionContext;
        Component focusedComponent;
        BePopupPositionContext bePopupContext = (BePopupPositionContext)((Object)this.model.getContext().getValueOrNull());
        Component component = WindowManagerEx.getInstanceEx().getFocusedComponent(this.project);
        if (component == null) {
            component = focusedComponent = (Component)WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        }
        if ((bePopupPositionContext = bePopupContext) instanceof BePopupPositionFocusContext) {
            popup.showInFocusCenter();
        } else if (bePopupPositionContext instanceof BePopupPositionActiveWindowContext) {
            Project contextProject = ProjectUtilKt.toProject(((BePopupPositionActiveWindowContext)bePopupContext).getProjectId());
            popup.showCenteredInCurrentWindow(contextProject);
        } else if (bePopupPositionContext instanceof BePopupPositionTreeOrTableSelectedItemContext) {
            RelativeRectangle selectedItemBounds;
            Component treeOrTable;
            Component component2 = treeOrTable = ConverterStorage.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication())).tryGetComponentByDataId(((BePopupPositionTreeOrTableSelectedItemContext)bePopupContext).getComponentId());
            Object object = selectedItemBounds = component2 != null ? SwingTreeUtilsKt.tryGetSelectedItemBounds(component2) : null;
            if (selectedItemBounds != null) {
                RelativeRectangle $this$showPopup_u24lambda_u241 = selectedItemBounds;
                boolean bl = false;
                Point point = new Point($this$showPopup_u24lambda_u241.getPoint().getPoint().x + $this$showPopup_u24lambda_u241.getDimension().width, $this$showPopup_u24lambda_u241.getPoint().getPoint().y + $this$showPopup_u24lambda_u241.getDimension().height / 2);
                popup.show(new RelativePoint(selectedItemBounds.getComponent(), point));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else if (bePopupPositionContext instanceof BePopupPositionComponentContext) {
            Project project = this.project;
            if (project == null) {
                project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            }
            Project contextProject = project;
            RelativePoint point = BeContextProvider.Companion.getPointFromContext(contextProject, (BePopupPositionComponentContext)bePopupContext, popup.getContent().getPreferredSize());
            RelativePoint relativePoint = point;
            if (relativePoint != null) {
                popup.show(relativePoint);
            } else {
                Project project2 = contextProject;
                if (project2 != null) {
                    popup.showCenteredInCurrentWindow(project2);
                } else {
                    popup.showInBestPositionFor(dataContext);
                }
            }
        } else if (bePopupPositionContext instanceof BePopupPositionMousePositionContext) {
            if (focusedComponent != null) {
                popup.showInScreenCoordinates(focusedComponent, MouseInfo.getPointerInfo().getLocation());
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else if (bePopupPositionContext instanceof BePopupPositionScreenPointContext) {
            if (focusedComponent != null) {
                popup.showInScreenCoordinates(focusedComponent, new Point(((BePopupPositionScreenPointContext)bePopupContext).getX(), ((BePopupPositionScreenPointContext)bePopupContext).getY()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else if (bePopupPositionContext instanceof BePopupPositionDataContextContext) {
            popup.showInBestPositionFor(dataContext);
        } else if (!BeShowPopupHandler.Companion.showPopup(popup, bePopupContext)) {
            popup.showInBestPositionFor(dataContext);
        }
    }

    private static final void loadPopup$lambda$0(PopupViewControl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        InterfacesKt.fire(this$0.model.getAccept());
        this$0.model.getResult().set((Object)DialogResult.OK);
        this$0.model.getResult().set((Object)DialogResult.CANCEL);
    }

    public static final /* synthetic */ void access$showPopup(PopupViewControl $this, JBPopup popup, DataContext dataContext) {
        $this.showPopup(popup, dataContext);
    }

    public static final /* synthetic */ BeAbstractPopup access$getModel$p(PopupViewControl $this) {
        return $this.model;
    }
}

