/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;

public class DaemonContextBuilder
implements Factory<DaemonContext> {
    private String uid;
    private File javaHome;
    private File daemonRegistryDir;
    private Long pid;
    private Integer idleTimeout;
    private Locale locale = Locale.getDefault();
    private List<String> daemonOpts = Lists.newArrayList();
    private boolean applyInstrumentationAgent;
    private DaemonParameters.Priority priority;

    public DaemonContextBuilder(ProcessEnvironment processEnvironment) {
        this.javaHome = FileUtils.canonicalize((File)Jvm.current().getJavaHome());
        this.pid = processEnvironment.maybeGetPid();
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public File getDaemonRegistryDir() {
        return this.daemonRegistryDir;
    }

    public void setDaemonRegistryDir(File daemonRegistryDir) {
        this.daemonRegistryDir = daemonRegistryDir;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<String> getDaemonOpts() {
        return this.daemonOpts;
    }

    public void setDaemonOpts(List<String> daemonOpts) {
        this.daemonOpts = daemonOpts;
    }

    public void setApplyInstrumentationAgent(boolean applyInstrumentationAgent) {
        this.applyInstrumentationAgent = applyInstrumentationAgent;
    }

    public void setPriority(DaemonParameters.Priority priority) {
        this.priority = priority;
    }

    public void useDaemonParameters(DaemonParameters daemonParameters) {
        this.setJavaHome(daemonParameters.getEffectiveJvm().getJavaHome());
        this.setDaemonOpts(daemonParameters.getEffectiveJvmArgs());
        this.setApplyInstrumentationAgent(daemonParameters.shouldApplyInstrumentationAgent());
        this.setPriority(daemonParameters.getPriority());
    }

    public DaemonContext create() {
        if (this.daemonRegistryDir == null) {
            throw new IllegalStateException("Registry dir must be specified.");
        }
        return new DefaultDaemonContext(this.uid, this.javaHome, this.daemonRegistryDir, this.pid, this.idleTimeout, this.daemonOpts, this.applyInstrumentationAgent, this.priority);
    }
}

