/*
 * Decompiled with CFR 0.152.
 */
package git4idea.light;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.PathUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u000bH\u0003\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"color", "Ljava/awt/Color;", "Lgit4idea/index/LightFileStatus;", "getColor", "(Lgit4idea/index/LightFileStatus;)Ljava/awt/Color;", "getPresentation", "", "Lorg/jetbrains/annotations/Nls;", "status", "", "Lgit4idea/index/StatusCode;", "Lgit4idea/index/LightFileStatus$StatusRecord;", "intellij.vcs.git"})
public final class LightGitPresentationKt {
    @Nullable
    public static final Color getColor(@NotNull LightFileStatus $this$color) {
        Intrinsics.checkNotNullParameter((Object)$this$color, (String)"<this>");
        return $this$color.getFileStatus$intellij_vcs_git().getColor();
    }

    @Nls
    @NotNull
    public static final String getPresentation(@NotNull LightFileStatus $this$getPresentation) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getPresentation, (String)"<this>");
        LightFileStatus lightFileStatus = $this$getPresentation;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE) ? true : lightFileStatus instanceof LightFileStatus.NotChanged) {
            string = "";
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            string = LightGitPresentationKt.getPresentation((LightFileStatus.StatusRecord)$this$getPresentation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nls
    private static final String getPresentation(LightFileStatus.StatusRecord $this$getPresentation) {
        String string;
        String string2;
        String string3 = PathUtil.getFileName((String)$this$getPresentation.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileName(...)");
        String fileName = string3;
        if ($this$getPresentation.getIndex() == '!' || $this$getPresentation.getWorkTree() == '!' || $this$getPresentation.getIndex() == '?' || $this$getPresentation.getWorkTree() == '?') {
            return fileName + ": " + LightGitPresentationKt.getPresentation($this$getPresentation.getIndex());
        }
        if ($this$getPresentation.isConflicted$intellij_vcs_git()) {
            Object object;
            if ($this$getPresentation.getIndex() == $this$getPresentation.getWorkTree()) {
                Object[] objectArray = new Object[1];
                FileStatus fileStatus = GitIndexStatusUtilKt.getFileStatus($this$getPresentation.getIndex() == 'U' ? (char)'M' : (char)$this$getPresentation.getIndex());
                Intrinsics.checkNotNull((Object)fileStatus);
                String string4 = fileStatus.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string4.toLowerCase(), (String)"this as java.lang.String).toLowerCase()");
                object = GitBundle.message("git.status.unmerged.both", objectArray);
            } else {
                String string5;
                String string6;
                if ($this$getPresentation.getIndex() == 'U') {
                    string6 = "";
                } else {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)LightGitPresentationKt.getPresentation($this$getPresentation.getIndex()).toLowerCase(), (String)"this as java.lang.String).toLowerCase()");
                    String string7 = GitBundle.message("git.status.unmerged.index", objectArray);
                    string6 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                }
                String indexPresentation = string6;
                if ($this$getPresentation.getWorkTree() == 'U') {
                    string5 = "";
                } else {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)LightGitPresentationKt.getPresentation($this$getPresentation.getWorkTree()).toLowerCase(), (String)"this as java.lang.String).toLowerCase()");
                    String string8 = GitBundle.message("git.status.unmerged.work.tree", objectArray);
                    string5 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
                }
                String workTreePresentation = string5;
                object = StringsKt.isBlank((CharSequence)indexPresentation) ? workTreePresentation : (StringsKt.isBlank((CharSequence)workTreePresentation) ? indexPresentation : indexPresentation + ", " + workTreePresentation);
            }
            String string9 = object;
            Intrinsics.checkNotNull((Object)string9);
            String status = string9;
            return fileName + ": " + LightGitPresentationKt.getPresentation('U') + " (" + status + ")";
        }
        if ($this$getPresentation.getIndex() == ' ') {
            string2 = "";
        } else {
            Object[] objectArray = new Object[]{LightGitPresentationKt.getPresentation($this$getPresentation.getIndex())};
            String string10 = GitBundle.message("git.status.index", objectArray);
            string2 = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
        }
        String indexPresentation = string2;
        if ($this$getPresentation.getWorkTree() == ' ') {
            string = "";
        } else {
            Object[] objectArray = new Object[]{LightGitPresentationKt.getPresentation($this$getPresentation.getWorkTree())};
            String string11 = GitBundle.message("git.status.work.tree", objectArray);
            string = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(...)");
        }
        String workTreePresentation = string;
        if (StringsKt.isBlank((CharSequence)indexPresentation)) {
            return fileName + ": " + workTreePresentation;
        }
        if (StringsKt.isBlank((CharSequence)workTreePresentation)) {
            return fileName + ": " + indexPresentation;
        }
        return fileName + ":<br/>" + indexPresentation + "<br/>" + workTreePresentation;
    }

    private static final String getPresentation(char status) {
        String string;
        char c = status;
        if (c == ' ') {
            String string2 = GitBundle.message("git.status.not.changed", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (c == 'R') {
            String string3 = GitBundle.message("git.status.renamed", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (c == 'C') {
            String string4 = GitBundle.message("git.status.copied", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else if (c == 'T') {
            String string5 = GitBundle.message("git.status.type.changed", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        } else if (c == 'U') {
            String string6 = GitBundle.message("git.status.unmerged", new Object[0]);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        } else if (c == '?') {
            String string7 = GitBundle.message("git.status.untracked", new Object[0]);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        } else {
            FileStatus fileStatus = GitIndexStatusUtilKt.getFileStatus(status);
            Intrinsics.checkNotNull((Object)fileStatus);
            String string8 = fileStatus.getText();
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
        }
        return string;
    }
}

