/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.groovy.GroovyEnabledFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/config/GradleFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "Lorg/jetbrains/plugins/groovy/GroovyEnabledFileType;", "()V", "getDefaultExtension", "", "getDescription", "getDisplayName", "getIcon", "Ljavax/swing/Icon;", "getName", "isGradleFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "intellij.gradle.java"})
public final class GradleFileType
extends LanguageFileType
implements GroovyEnabledFileType {
    @NotNull
    public static final GradleFileType INSTANCE = new GradleFileType();

    private GradleFileType() {
        super((Language)GroovyLanguage.INSTANCE, true);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GradleIcons.GradleFile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GradleFile");
        return icon;
    }

    @NotNull
    public String getName() {
        return "Gradle";
    }

    @NotNull
    public String getDescription() {
        String string = GradleBundle.message((String)"gradle.filetype.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = GradleBundle.message((String)"gradle.filetype.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "gradle";
    }

    @JvmStatic
    public static final boolean isGradleFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)INSTANCE);
    }

    @JvmStatic
    public static final boolean isGradleFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return GradleFileType.isGradleFile(virtualFile2);
    }
}

