/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.util;

import git4idea.remote.hosting.GitRemoteBranchesUtil;
import git4idea.remote.hosting.HostedGitRepositoryRemote;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabProjectDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestFullDetails;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestFullDetailsKt;
import org.jetbrains.plugins.gitlab.util.GitLabProjectMapping;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/util/GitLabMergeRequestBranchUtil;", "", "()V", "FORK_BRANCH_PREFIX", "", "fetchAndCheckoutBranch", "", "mapping", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping;", "details", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestFullDetails;", "(Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestFullDetails;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestBranchUtil {
    @NotNull
    public static final GitLabMergeRequestBranchUtil INSTANCE = new GitLabMergeRequestBranchUtil();
    @NotNull
    private static final String FORK_BRANCH_PREFIX = "fork";

    private GitLabMergeRequestBranchUtil() {
    }

    @Nullable
    public final Object fetchAndCheckoutBranch(@NotNull GitLabProjectMapping mapping2, @NotNull GitLabMergeRequestFullDetails details, @NotNull Continuation<? super Unit> $completion) {
        HostedGitRepositoryRemote hostedGitRepositoryRemote = GitLabMergeRequestFullDetailsKt.getRemoteDescriptor(details, mapping2.getRepository().getServerPath());
        if (hostedGitRepositoryRemote == null) {
            return Unit.INSTANCE;
        }
        HostedGitRepositoryRemote remoteDescriptor = hostedGitRepositoryRemote;
        GitLabProjectDTO gitLabProjectDTO = details.getSourceProject();
        boolean isFork = !Intrinsics.areEqual((Object)(gitLabProjectDTO != null ? gitLabProjectDTO.getFullPath() : null), (Object)details.getTargetProject().getFullPath());
        String localPrefix = isFork ? FORK_BRANCH_PREFIX : null;
        Object object = GitRemoteBranchesUtil.INSTANCE.fetchAndCheckoutRemoteBranch(mapping2.getGitRepository(), remoteDescriptor, details.getSourceBranch(), localPrefix, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

