/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.indices;

import ai.grazie.emb.FloatTextEmbedding;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J \u0010\u001d\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001f\u0018\u00010\u001eJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u0005J\u0014\u0010#\u001a\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\"\u0010%\u001a\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fJ\u0019\u0010'\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0019H\u0086\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006*"}, d2={"Lcom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager;", "", "root", "Ljava/nio/file/Path;", "dimensions", "", "(Ljava/nio/file/Path;I)V", "embeddingSizeInBytes", "getEmbeddingSizeInBytes", "()I", "embeddingsPath", "kotlin.jvm.PlatformType", "getEmbeddingsPath", "()Ljava/nio/file/Path;", "idsPath", "getIdsPath", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "prettyPrinter", "Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;", "rootPath", "getRootPath", "get", "Lai/grazie/emb/FloatTextEmbedding;", "index", "getIndexOffset", "", "loadIndex", "Lkotlin/Pair;", "", "", "removeAtIndex", "", "saveIds", "ids", "saveIndex", "embeddings", "set", "embedding", "Companion", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nLocalEmbeddingIndexFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEmbeddingIndexFileManager.kt\ncom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n13344#3,2:133\n13344#3,2:135\n13344#3,2:148\n48#4:137\n43#4:138\n1549#5:139\n1620#5,3:140\n1549#5:143\n1620#5,3:144\n1855#5:147\n1856#5:150\n*S KotlinDebug\n*F\n+ 1 LocalEmbeddingIndexFileManager.kt\ncom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager\n*L\n57#1:133,2\n79#1:135,2\n114#1:148,2\n89#1:137\n89#1:138\n89#1:139\n89#1:140,3\n92#1:143\n92#1:144,3\n113#1:147\n113#1:150\n*E\n"})
public final class LocalEmbeddingIndexFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int dimensions;
    @NotNull
    private final ReentrantReadWriteLock lock;
    private final ObjectMapper mapper;
    @NotNull
    private final DefaultPrettyPrinter prettyPrinter;
    @NotNull
    private final Path rootPath;
    private final int embeddingSizeInBytes;
    public static final int DEFAULT_DIMENSIONS = 128;
    public static final int EMBEDDING_ELEMENT_SIZE = 4;
    @NotNull
    private static final String IDS_FILENAME = "ids.json";
    @NotNull
    private static final String EMBEDDINGS_FILENAME = "embeddings.bin";

    /*
     * WARNING - void declaration
     */
    public LocalEmbeddingIndexFileManager(@NotNull Path root, int dimensions) {
        void $this$prettyPrinter_u24lambda_u240;
        DefaultPrettyPrinter defaultPrettyPrinter;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.dimensions = dimensions;
        this.lock = new ReentrantReadWriteLock();
        this.mapper = ExtensionsKt.jacksonObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter defaultPrettyPrinter2 = defaultPrettyPrinter = new DefaultPrettyPrinter();
        LocalEmbeddingIndexFileManager localEmbeddingIndexFileManager = this;
        boolean bl = false;
        $this$prettyPrinter_u24lambda_u240.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        localEmbeddingIndexFileManager.prettyPrinter = defaultPrettyPrinter;
        this.rootPath = root;
        this.embeddingSizeInBytes = this.dimensions * 4;
    }

    public /* synthetic */ LocalEmbeddingIndexFileManager(Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 128;
        }
        this(path, n);
    }

    private final Path getRootPath() {
        Path path;
        Path it = path = this.rootPath;
        boolean bl = false;
        Files.createDirectories(this.rootPath, new FileAttribute[0]);
        return path;
    }

    private final Path getIdsPath() {
        return this.getRootPath().resolve(IDS_FILENAME);
    }

    private final Path getEmbeddingsPath() {
        return this.getRootPath().resolve(EMBEDDINGS_FILENAME);
    }

    public final int getEmbeddingSizeInBytes() {
        return this.embeddingSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FloatTextEmbedding get(int index) {
        FloatTextEmbedding floatTextEmbedding;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            FloatTextEmbedding floatTextEmbedding2;
            boolean bl = false;
            Closeable closeable = new RandomAccessFile(this.getEmbeddingsPath().toFile(), "r");
            Throwable throwable = null;
            try {
                RandomAccessFile input = (RandomAccessFile)closeable;
                boolean bl2 = false;
                input.seek(this.getIndexOffset(index));
                byte[] buffer = new byte[4];
                int n = 0;
                int n2 = this.dimensions;
                float[] fArray = new float[n2];
                while (n < n2) {
                    int n3 = n++;
                    input.read(buffer);
                    fArray[n3] = ByteBuffer.wrap(buffer).getFloat();
                }
                float[] fArray2 = fArray;
                floatTextEmbedding2 = new FloatTextEmbedding(fArray2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            floatTextEmbedding = floatTextEmbedding2;
        }
        finally {
            readLock.unlock();
        }
        return floatTextEmbedding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int index, @NotNull FloatTextEmbedding embedding) {
        Intrinsics.checkNotNullParameter((Object)embedding, (String)"embedding");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Closeable closeable = new RandomAccessFile(this.getEmbeddingsPath().toFile(), "rw");
            Throwable throwable = null;
            try {
                RandomAccessFile output = (RandomAccessFile)closeable;
                boolean bl2 = false;
                output.seek(this.getIndexOffset(index));
                ByteBuffer buffer = ByteBuffer.allocate(4);
                float[] $this$forEach$iv = embedding.getValues();
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (int i = 0; i < n2; ++i) {
                    float element$iv;
                    float it = element$iv = $this$forEach$iv[i];
                    boolean bl3 = false;
                    output.write(buffer.putFloat(0, it).array());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAtIndex(int index) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Closeable closeable = new RandomAccessFile(this.getEmbeddingsPath().toFile(), "rw");
            Throwable throwable = null;
            try {
                RandomAccessFile file = (RandomAccessFile)closeable;
                boolean bl2 = false;
                if (file.length() < (long)this.embeddingSizeInBytes) {
                    return;
                }
                if (file.length() - (long)this.embeddingSizeInBytes != this.getIndexOffset(index)) {
                    int n2;
                    file.seek(file.length() - (long)this.embeddingSizeInBytes);
                    byte[] array = new byte[4];
                    int n3 = 0;
                    int n4 = this.dimensions;
                    float[] fArray = new float[n4];
                    while (n3 < n4) {
                        n2 = n3++;
                        file.read(array);
                        fArray[n2] = ByteBuffer.wrap(array).getFloat();
                    }
                    float[] fArray2 = fArray;
                    FloatTextEmbedding embedding = new FloatTextEmbedding(fArray2);
                    file.seek(this.getIndexOffset(index));
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    float[] $this$forEach$iv = embedding.getValues();
                    boolean $i$f$forEach = false;
                    int n5 = $this$forEach$iv.length;
                    for (n2 = 0; n2 < n5; ++n2) {
                        float element$iv;
                        float it = element$iv = $this$forEach$iv[n2];
                        boolean bl3 = false;
                        file.write(buffer.putFloat(0, it).array());
                    }
                }
                file.setLength(file.length() - (long)this.embeddingSizeInBytes);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<List<String>, List<FloatTextEmbedding>> loadIndex() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Pair pair;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$readValue$iv;
            LinkOption[] linkOptionArray;
            block16: {
                block15: {
                    boolean bl = false;
                    Path path = this.getIdsPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-idsPath>(...)");
                    Path path2 = path;
                    linkOptionArray = new ObjectMapper[]{};
                    if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block15;
                    Path path3 = this.getEmbeddingsPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"<get-embeddingsPath>(...)");
                    path2 = path3;
                    linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block16;
                }
                Pair<List<String>, List<FloatTextEmbedding>> pair2 = null;
                return pair2;
            }
            LinkOption[] linkOptionArray2 = this.mapper;
            Intrinsics.checkNotNullExpressionValue((Object)linkOptionArray2, (String)"mapper");
            linkOptionArray = linkOptionArray2;
            File file = this.getIdsPath().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            File src$iv = file;
            boolean $i$f$readValue22 = false;
            boolean $i$f$jacksonTypeRef = false;
            $this$readValue$iv = (Iterable)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<List<? extends String>>(){});
            boolean $i$f$map = false;
            void $i$f$readValue22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = it.intern();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).intern()");
                collection.add(string2);
            }
            List ids = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            byte[] buffer = new byte[4];
            Path path = this.getEmbeddingsPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-embeddingsPath>(...)");
            Object object = path;
            Object object2 = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(this, *options)");
            object = inputStream2;
            object2 = null;
            try {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                InputStream input = (InputStream)object;
                boolean bl = false;
                Iterable iterable = ids;
                List list = ids;
                boolean $i$f$map2 = false;
                void bl2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    int n = 0;
                    int n2 = this.dimensions;
                    float[] fArray = new float[n2];
                    while (n < n2) {
                        int n3 = n++;
                        input.read(buffer);
                        fArray[n3] = ByteBuffer.wrap(buffer).getFloat();
                    }
                    float[] fArray2 = fArray;
                    collection.add(new FloatTextEmbedding(fArray2));
                }
                pair = TuplesKt.to((Object)list, (Object)((List)destination$iv$iv2));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Pair pair3 = pair;
            return pair3;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveIds(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Path path = this.getIdsPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-idsPath>(...)");
            Closeable closeable = PathKt.outputStream$default((Path)path, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
            Throwable throwable = null;
            try {
                OutputStream output = (OutputStream)closeable;
                boolean bl2 = false;
                this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValue(output, ids);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveIndex(@NotNull List<String> ids, @NotNull List<FloatTextEmbedding> embeddings) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(embeddings, (String)"embeddings");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object object;
            boolean bl = false;
            Path path = this.getIdsPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-idsPath>(...)");
            Closeable closeable = PathKt.outputStream$default((Path)path, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
            Object object2 = null;
            try {
                OutputStream output = (OutputStream)closeable;
                boolean bl2 = false;
                this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValue(output, ids);
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            ByteBuffer buffer = ByteBuffer.allocate(4);
            Path path2 = this.getEmbeddingsPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"<get-embeddingsPath>(...)");
            object2 = PathKt.outputStream$default((Path)path2, (boolean)false, (OpenOption[])new OpenOption[0], (int)1, null);
            object = null;
            try {
                OutputStream output = (OutputStream)object2;
                boolean bl3 = false;
                Iterable $this$forEach$iv = embeddings;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FloatTextEmbedding embedding = (FloatTextEmbedding)element$iv;
                    boolean bl4 = false;
                    float[] $this$forEach$iv2 = embedding.getValues();
                    boolean $i$f$forEach2 = false;
                    int n2 = $this$forEach$iv2.length;
                    for (int i = 0; i < n2; ++i) {
                        float element$iv2;
                        float it = element$iv2 = $this$forEach$iv2[i];
                        boolean bl5 = false;
                        output.write(buffer.putFloat(0, it).array());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final long getIndexOffset(int index) {
        return (long)index * (long)this.embeddingSizeInBytes;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/ml/embeddings/search/indices/LocalEmbeddingIndexFileManager$Companion;", "", "()V", "DEFAULT_DIMENSIONS", "", "EMBEDDINGS_FILENAME", "", "EMBEDDING_ELEMENT_SIZE", "IDS_FILENAME", "intellij.platform.ml.embeddings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

