/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.services;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.ml.embeddings.EmbeddingsBundle;
import com.intellij.platform.ml.embeddings.search.indices.DiskSynchronizedEmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.services.DiskSynchronizedEmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.EmbeddingIndexingTask;
import com.intellij.platform.ml.embeddings.search.services.FileEmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.IndexableFile;
import com.intellij.platform.ml.embeddings.search.settings.SemanticSearchSettings;
import com.intellij.platform.ml.embeddings.services.LocalArtifactsManager;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/FileEmbeddingsStorage;", "Lcom/intellij/platform/ml/embeddings/search/services/DiskSynchronizedEmbeddingsStorage;", "Lcom/intellij/platform/ml/embeddings/search/services/IndexableFile;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "index", "Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "getIndex", "()Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "indexMemoryWeight", "", "getIndexMemoryWeight", "()I", "indexStrongLimit", "getIndexStrongLimit", "()Ljava/lang/Integer;", "scanningTitle", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getScanningTitle", "()Ljava/lang/String;", "setupTitle", "getSetupTitle", "spanIndexName", "getSpanIndexName", "checkSearchEnabled", "", "dispose", "", "getIndexableEntities", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renameFile", "oldFileName", "newFile", "Companion", "intellij.platform.ml.embeddings"})
public final class FileEmbeddingsStorage
extends DiskSynchronizedEmbeddingsStorage<IndexableFile>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DiskSynchronizedEmbeddingSearchIndex index;
    @NotNull
    private final String spanIndexName;
    private final int indexMemoryWeight;
    private final int indexStrongLimit;
    @NotNull
    private static final String INDEX_DIR = "files";

    public FileEmbeddingsStorage(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project, cs);
        this.cs = cs;
        String string = FilesKt.resolve((File)FilesKt.resolve((File)new File("semantic-search"), (String)LocalArtifactsManager.Companion.getInstance().getModelVersion()), (String)INDEX_DIR).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.index = new DiskSynchronizedEmbeddingSearchIndex(ProjectUtil.getProjectCachePath$default((Project)project, (String)string, (boolean)false, null, (int)6, null), null, 2, null);
        this.spanIndexName = "semanticFiles";
        this.indexMemoryWeight = 1;
        this.indexStrongLimit = Registry.intValue((String)"search.everywhere.ml.semantic.indexing.indexable.files.limit");
    }

    @Override
    @NotNull
    public DiskSynchronizedEmbeddingSearchIndex getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public String getScanningTitle() {
        String string = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.indices.files.scanning.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @Override
    @NotNull
    public String getSetupTitle() {
        String string = EmbeddingsBundle.INSTANCE.getMessage("ml.embeddings.indices.files.generation.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @Override
    @NotNull
    public String getSpanIndexName() {
        return this.spanIndexName;
    }

    @Override
    public int getIndexMemoryWeight() {
        return this.indexMemoryWeight;
    }

    @Override
    @NotNull
    public Integer getIndexStrongLimit() {
        return this.indexStrongLimit;
    }

    @Override
    public boolean checkSearchEnabled() {
        return SemanticSearchSettings.Companion.getInstance().getEnabledInFilesTab();
    }

    @Override
    @Nullable
    public Object getIndexableEntities(@NotNull Continuation<? super List<IndexableFile>> $completion) {
        return CoroutinesKt.readAction((Function0)((Function0)new Function0<List<? extends IndexableFile>>(this){
            final /* synthetic */ FileEmbeddingsStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<IndexableFile> invoke() {
                List list;
                FileEmbeddingsStorage fileEmbeddingsStorage = this.this$0;
                List $this$invoke_u24lambda_u241 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                ProjectFileIndex.getInstance((Project)fileEmbeddingsStorage.getProject()).iterateContent(arg_0 -> getIndexableEntities.2.invoke$lambda$1$lambda$0($this$invoke_u24lambda_u241, arg_0));
                return CollectionsKt.build((List)list);
            }

            private static final boolean invoke$lambda$1$lambda$0(List $this_buildList, VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)$this_buildList, (String)"$this_buildList");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (VirtualFileUtil.isFile((VirtualFile)it) & it.isInLocalFileSystem()) {
                    $this_buildList.add(new IndexableFile(it));
                }
                return true;
            }
        }), $completion);
    }

    public final void renameFile(@NotNull String oldFileName, @NotNull IndexableFile newFile) {
        Intrinsics.checkNotNullParameter((Object)oldFileName, (String)"oldFileName");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        if (!this.checkSearchEnabled()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, oldFileName, newFile, null){
            int label;
            final /* synthetic */ FileEmbeddingsStorage this$0;
            final /* synthetic */ String $oldFileName;
            final /* synthetic */ IndexableFile $newFile;
            {
                this.this$0 = $receiver;
                this.$oldFileName = $oldFileName;
                this.$newFile = $newFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Job job = this.this$0.getIndexSetupJob().get();
                        if (job == null) break;
                        this.label = 1;
                        Object object3 = job.join((Continuation)this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                String string = this.$oldFileName.intern();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).intern()");
                String string2 = this.$newFile.getId().intern();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).intern()");
                String string3 = this.$newFile.getIndexableRepresentation().intern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).intern()");
                this.label = 2;
                Object object4 = new EmbeddingIndexingTask.RenameDiskSynchronized(string, string2, string3, null, 8, null).run(this.this$0.getIndex(), (Continuation<? super Unit>)((Continuation)this));
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void dispose() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/FileEmbeddingsStorage$Companion;", "", "()V", "INDEX_DIR", "", "getInstance", "Lcom/intellij/platform/ml/embeddings/search/services/FileEmbeddingsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ml.embeddings"})
    @SourceDebugExtension(value={"SMAP\nFileEmbeddingsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileEmbeddingsStorage.kt\ncom/intellij/platform/ml/embeddings/search/services/FileEmbeddingsStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,89:1\n30#2,3:90\n*S KotlinDebug\n*F\n+ 1 FileEmbeddingsStorage.kt\ncom/intellij/platform/ml/embeddings/search/services/FileEmbeddingsStorage$Companion\n*L\n80#1:90,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileEmbeddingsStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FileEmbeddingsStorage> serviceClass$iv = FileEmbeddingsStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (FileEmbeddingsStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

