/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.IFilter;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.AutoChoices;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.ChoicesHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.CustomChoice;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.FiltersHandler;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor.FilterEditor;

class AdaptiveChoicesHandler
extends ChoicesHandler {
    private AdaptiveChoicesSupport adaptiveSupport;
    private boolean interrupted = true;

    AdaptiveChoicesHandler(FiltersHandler handler) {
        super(handler);
    }

    @Override
    public RowFilter getRowFilter() {
        return this.adaptiveSupport;
    }

    @Override
    public boolean setInterrupted(boolean interrupted) {
        boolean ret = false;
        if (this.interrupted != interrupted) {
            this.interrupted = interrupted;
            if (interrupted) {
                ret = this.removeAdaptiveChoicesSupport();
            } else {
                boolean bl = ret = this.handler.getTable() != null && this.handler.isEnabled();
                if (ret) {
                    this.createAdaptiveChoicesSupport();
                }
            }
        }
        return ret;
    }

    @Override
    public void editorUpdated(FilterEditor editor) {
        if (this.adaptiveSupport != null) {
            this.adaptiveSupport.editorUpdated(editor);
        }
    }

    @Override
    public boolean filterUpdated(IFilter filter, boolean retInfoRequired) {
        return this.adaptiveSupport == null || this.adaptiveSupport.update(filter);
    }

    @Override
    public void filterOperation(boolean start2) {
        if (start2) {
            this.removeAdaptiveChoicesSupport();
        } else if (!this.interrupted) {
            this.createAdaptiveChoicesSupport();
            this.handler.updateTableFilter();
        }
    }

    @Override
    public void filterEnabled(IFilter filter) {
        if (this.adaptiveSupport == null) {
            if (!this.interrupted) {
                this.createAdaptiveChoicesSupport();
                this.handler.updateTableFilter();
            }
        } else {
            this.adaptiveSupport.initChoices(filter);
        }
    }

    @Override
    public void allFiltersDisabled() {
        if (this.removeAdaptiveChoicesSupport()) {
            this.handler.updateTableFilter();
        }
    }

    @Override
    public void consolidateFilterChanges(int modelIndex) {
        if (this.adaptiveSupport != null) {
            this.adaptiveSupport.propagateChanges(modelIndex);
        }
    }

    @Override
    public void tableUpdated(TableModel model, int eventType, int firstRow, int lastRow, int column) {
        if (this.adaptiveSupport != null) {
            this.adaptiveSupport.tableChanged(eventType, firstRow, lastRow, column);
        }
    }

    private void createAdaptiveChoicesSupport() {
        Collection<FilterEditor> eds = this.handler.getEditors();
        FilterEditor[] array = eds.toArray(new FilterEditor[0]);
        this.adaptiveSupport = new AdaptiveChoicesSupport(this.handler.getTable().getModel(), array, this.handler.getFilters());
        this.setEnableTableModelEvents(true);
    }

    private boolean removeAdaptiveChoicesSupport() {
        if (this.adaptiveSupport == null) {
            return false;
        }
        this.adaptiveSupport = null;
        this.setEnableTableModelEvents(false);
        return true;
    }

    static class AdaptiveChoicesSupport
    extends RowFilter {
        private final ArrayList<RowInfo> rows;
        private final ChoicesHandler.RowEntry rowEntry;
        private final EditorHandle[] editorHandles;
        private final RowInfo.Filter[] filters;

        AdaptiveChoicesSupport(TableModel model, FilterEditor[] editors, Set<IFilter> allFilters) {
            int columns = model.getColumnCount();
            int edLen = editors.length;
            this.rows = new ArrayList(model.getRowCount() + 1);
            this.editorHandles = new EditorHandle[edLen];
            this.filters = new RowInfo.Filter[allFilters.size() + columns - edLen];
            for (int i = 0; i < columns; ++i) {
                this.filters[i] = null;
            }
            for (FilterEditor editor : editors) {
                int column = editor.getModelIndex();
                this.editorHandles[--edLen] = new EditorHandle(editor, model);
                IFilter filter = editor.getFilter();
                allFilters.remove(filter);
                this.filters[column] = new RowInfo.Filter(filter, column);
            }
            for (IFilter filter : allFilters) {
                this.filters[columns] = new RowInfo.Filter(filter, columns);
                ++columns;
            }
            this.rowEntry = new ChoicesHandler.RowEntry(model, editors);
            this.rowsAdded(0, model.getRowCount() - 1);
        }

        public void tableChanged(int event, int firstRow, int lastRow, int column) {
            if (column != -1) {
                this.rowsUpdated(firstRow, lastRow, column);
            } else if (event == 0) {
                if (lastRow >= this.rows.size()) {
                    this.rows.clear();
                    this.rowsAdded(0, this.rowEntry.getModel().getRowCount() - 1);
                } else {
                    this.rowsUpdated(firstRow, lastRow, -1);
                }
            } else if (event == 1) {
                this.rowsAdded(firstRow, lastRow);
            } else if (event == -1) {
                this.rowsDeleted(firstRow, lastRow);
            }
        }

        private void rowsAdded(int firstRow, int lastRow) {
            this.rows.ensureCapacity(this.rows.size() + lastRow - firstRow + 1);
            for (int r = firstRow; r <= lastRow; ++r) {
                RowInfo row = new RowInfo(this.filters.length);
                this.rows.add(r, row);
                this.rowEntry.row = r;
                for (RowInfo.Filter filter : this.filters) {
                    if (filter == null || filter.include(this.rowEntry)) continue;
                    filter.set(row, false);
                }
            }
            this.extractChoices(this.editorHandles.length, firstRow, lastRow);
        }

        private void rowsUpdated(int firstRow, int lastRow, int column) {
            RowInfo.Filter filter;
            RowInfo.Filter filter2 = filter = column == -1 ? null : this.filters[column];
            while (firstRow <= lastRow) {
                RowInfo row = this.rows.get(firstRow);
                this.rowEntry.row = firstRow++;
                if (filter == null) {
                    for (RowInfo.Filter f : this.filters) {
                        if (f == null) continue;
                        f.set(row, f.include(this.rowEntry));
                    }
                    continue;
                }
                filter.set(row, filter.include(this.rowEntry));
            }
            this.extractChoices(this.editorHandles.length, 0, -1);
        }

        private void rowsDeleted(int firstRow, int lastRow) {
            this.rows.subList(firstRow, lastRow + 1).clear();
            this.extractChoices(this.editorHandles.length, 0, -1);
        }

        public boolean update(IFilter iFilter) {
            int editorHandle;
            boolean changed;
            RowInfo.Filter filter = this.getFilter(iFilter);
            int update2 = this.updateRowInfo(filter, iFilter);
            boolean bl = changed = 1 == (update2 & 1);
            if (changed && ((editorHandle = this.getEditorHandle(filter.column)) == -1 || !this.editorHandles[editorHandle].editor.isEditing())) {
                this.propagateChanges(filter.column);
            }
            return (update2 & 2) == 2;
        }

        public void propagateChanges(int modelPosition) {
            int width = this.editorHandles.length;
            int handle = this.getEditorHandle(modelPosition);
            if (handle >= 0) {
                this.switchHandle(handle, --width);
            }
            this.extractChoices(width, 0, -1);
        }

        public void editorUpdated(FilterEditor fe) {
            int width;
            int column = fe.getModelIndex();
            int editorHandle = this.getEditorHandle(column);
            this.editorHandles[editorHandle].updateFormatter(this.rowEntry.getModel(), this.rowEntry.getFormatters());
            int updateRowInfo = this.updateRowInfo(this.filters[fe.getModelIndex()], fe.getFilter());
            if (1 == (1 & updateRowInfo)) {
                width = this.editorHandles.length;
            } else {
                this.switchHandle(editorHandle, 0);
                width = 1;
            }
            this.extractChoices(width, 0, -1);
        }

        private int updateRowInfo(RowInfo.Filter filter, IFilter iFilter) {
            int changedBit = 0;
            int anyBitSet = 1;
            this.rowEntry.row = 0;
            for (RowInfo ri : this.rows) {
                boolean set;
                boolean bl = set = !iFilter.isEnabled() || iFilter.include(this.rowEntry);
                if (filter.set(ri, set)) {
                    changedBit = 1;
                }
                if (set) {
                    anyBitSet = 2;
                }
                ++this.rowEntry.row;
            }
            return changedBit | anyBitSet;
        }

        public void initChoices(IFilter iFilter) {
            RowInfo.Filter filter = this.getFilter(iFilter);
            if (filter.column < this.editorHandles.length) {
                this.switchHandle(this.getEditorHandle(filter.column), 0);
                this.extractChoices(1, 0, -1);
            }
        }

        private RowInfo.Filter getFilter(IFilter filter) {
            for (RowInfo.Filter f : this.filters) {
                if (f == null || f.filter != filter) continue;
                return f;
            }
            return null;
        }

        private void extractChoices(int handles, int firstRow, int lastRow) {
            int rows = this.rowEntry.getModelRowCount() - 1;
            if (lastRow == -1) {
                lastRow = rows;
            }
            boolean fullMode = firstRow == 0 && lastRow == rows;
            int check2 = handles;
            int i = 0;
            while (i < check2) {
                if (this.editorHandles[i].startIteration(fullMode)) {
                    this.switchHandle(i, --check2);
                    continue;
                }
                ++i;
            }
            if (check2 > 0) {
                this.iterateRows(check2, firstRow, lastRow);
            }
            while (handles-- > 0) {
                this.editorHandles[handles].iterationCompleted(fullMode);
            }
        }

        private void iterateRows(int handles, int firstRow, int lastRow) {
            while (firstRow <= lastRow) {
                this.rowEntry.row = firstRow;
                RowInfo row = this.rows.get(firstRow);
                int i = 0;
                while (i < handles) {
                    EditorHandle handle = this.editorHandles[i++];
                    if (!this.filters[handle.column].is(row) || !handle.handleRow(this.rowEntry)) continue;
                    this.switchHandle(--i, --handles);
                    if (handles != 0) continue;
                    return;
                }
                ++firstRow;
            }
        }

        private void switchHandle(int source2, int target) {
            if (target != source2) {
                EditorHandle move = this.editorHandles[target];
                this.editorHandles[target] = this.editorHandles[source2];
                this.editorHandles[source2] = move;
            }
        }

        private int getEditorHandle(int column) {
            int len = this.editorHandles.length;
            while (len-- > 0) {
                if (this.editorHandles[len].column != column) continue;
                return len;
            }
            return len;
        }

        public boolean include(RowFilter.Entry entry2) {
            RowInfo ri = this.rows.get((Integer)entry2.getIdentifier());
            return ri == null || ri.is();
        }

        public boolean include(int row) {
            return this.rows.get(row).is();
        }

        static class EditorHandle {
            int column;
            FilterEditor editor;
            private boolean autoOptions;
            private int maxChoices;
            private int maxIterationChoices;
            private Map<CustomChoice, RowFilter> customChoices;
            private Map<CustomChoice, RowFilter> missingChoices;
            private final Set choices = new HashSet();

            EditorHandle(FilterEditor editor, TableModel model) {
                this.editor = editor;
                this.column = editor.getModelIndex();
                this.init(model);
            }

            public void updateFormatter(TableModel model, Format[] formatters) {
                formatters[this.column] = this.editor.getFormat();
                this.init(model);
            }

            private void init(TableModel model) {
                ?[] o;
                Class<?> c;
                Set<CustomChoice> choices = this.editor.getCustomChoices();
                this.maxChoices = AutoChoices.DISABLED == this.editor.getAutoChoices() ? 0 : ((c = model.getColumnClass(this.column)).equals(Boolean.class) ? 3 : ((o = c.getEnumConstants()) == null ? (AutoChoices.ENUMS == this.editor.getAutoChoices() ? 0 : Integer.MAX_VALUE) : o.length + 1));
                boolean bl = this.autoOptions = this.maxChoices > 0;
                if (choices.isEmpty()) {
                    this.customChoices = null;
                } else {
                    this.customChoices = new HashMap<CustomChoice, RowFilter>();
                    for (CustomChoice cc : choices) {
                        this.customChoices.put(cc, cc.getFilter(this.editor));
                    }
                    if (this.maxChoices != Integer.MAX_VALUE) {
                        this.maxChoices += this.customChoices.size();
                    }
                }
            }

            public boolean startIteration(boolean fullMode) {
                if (!this.editor.isEnabled()) {
                    return true;
                }
                this.choices.clear();
                this.maxIterationChoices = this.maxChoices;
                if (fullMode) {
                    this.missingChoices = this.customChoices == null ? Collections.emptyMap() : new HashMap<CustomChoice, RowFilter>(this.customChoices);
                } else {
                    this.maxIterationChoices -= this.editor.getChoicesSize();
                }
                return this.maxIterationChoices <= 0;
            }

            public boolean handleRow(ChoicesHandler.RowEntry entry2) {
                if (!this.missingChoices.isEmpty()) {
                    Iterator<Map.Entry<CustomChoice, RowFilter>> it = this.missingChoices.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<CustomChoice, RowFilter> o = it.next();
                        if (!o.getValue().include(entry2)) continue;
                        this.choices.add(o.getKey());
                        it.remove();
                    }
                }
                if (this.autoOptions) {
                    this.choices.add(entry2.getValue(this.column));
                }
                return this.maxIterationChoices == this.choices.size();
            }

            public void iterationCompleted(boolean fullMode) {
                if (this.editor.isEnabled()) {
                    if (fullMode) {
                        this.editor.setChoices(this.choices);
                    } else {
                        this.editor.addChoices(this.choices);
                    }
                }
            }
        }

        static class RowInfo {
            static final byte SET = -1;
            byte[] info;

            RowInfo(int columns) {
                int length = 1 + (columns >> 3);
                this.info = new byte[length];
                while (length-- > 0) {
                    this.info[length] = -1;
                }
            }

            public boolean is() {
                int length = this.info.length;
                while (length-- > 0) {
                    if (this.info[length] == -1) continue;
                    return false;
                }
                return true;
            }

            static class Filter {
                private final int col;
                private final int bit;
                int column;
                IFilter filter;

                Filter(IFilter filter, int column) {
                    this.column = column;
                    this.filter = filter;
                    this.col = column >> 3;
                    this.bit = 1 << (column & 7);
                }

                public boolean include(RowFilter.Entry rowEntry) {
                    return !this.filter.isEnabled() || this.filter.include(rowEntry);
                }

                public boolean set(RowInfo row, boolean set) {
                    byte[] info = row.info;
                    byte now = info[this.col];
                    if (set) {
                        int n = this.col;
                        info[n] = (byte)(info[n] | this.bit);
                    } else {
                        int n = this.col;
                        info[n] = (byte)(info[n] & (0xFFFFFFFF ^ this.bit));
                    }
                    return now != info[this.col];
                }

                public boolean is(RowInfo row) {
                    byte[] info = row.info;
                    boolean now = 0 != (info[this.col] & this.bit);
                    this.set(row, true);
                    boolean ret = row.is();
                    this.set(row, now);
                    return ret;
                }
            }
        }
    }
}

