/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateBundleToLoad;
import org.jetbrains.plugins.textmate.TextMateBundlesLoader;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.BundleReaderKt;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.bundles.VSCBundleReaderKt;
import org.jetbrains.plugins.textmate.configuration.TextMateBuiltinBundlesSettings;
import org.jetbrains.plugins.textmate.configuration.TextMatePersistentBundle;
import org.jetbrains.plugins.textmate.configuration.TextMateUserBundlesSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtilsKt;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class TextMateServiceImpl
extends TextMateService {
    private boolean ourBuiltinBundlesDisabled;
    private volatile boolean myInitialized;
    private final Lock myRegistrationLock = new ReentrantLock();
    private final Map<CharSequence, TextMateTextAttributesAdapter> myCustomHighlightingColors = new HashMap<CharSequence, TextMateTextAttributesAdapter>();
    private Map<TextMateFileNameMatcher, CharSequence> myExtensionMapping = new HashMap<TextMateFileNameMatcher, CharSequence>();
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final SnippetsRegistryImpl mySnippetRegistry = new SnippetsRegistryImpl();
    private final PreferencesRegistryImpl myPreferenceRegistry = new PreferencesRegistryImpl();
    private final ShellVariablesRegistryImpl myShellVariablesRegistry = new ShellVariablesRegistryImpl();
    private final Interner<CharSequence> myInterner = Interner.createWeakInterner();
    private final CoroutineScope myScope;

    public static Path getBundledBundlePath() {
        return PluginPathManager.getPluginHome((String)"textmate").toPath().resolve("lib/bundles").normalize();
    }

    public TextMateServiceImpl(CoroutineScope scope) {
        this.myScope = scope;
        Application application = ApplicationManager.getApplication();
        Runnable checkCancelled = application == null || application.isUnitTestMode() ? null : ProgressManager::checkCanceled;
        SyntaxMatchUtils.setCheckCancelledCallback(checkCancelled);
    }

    @Override
    public void reloadEnabledBundles() {
        this.registerBundles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    private void registerBundles(boolean fireEvents) {
        this.myRegistrationLock.lock();
        try {
            Map<String, TextMatePersistentBundle> userBundles;
            TextMateBuiltinBundlesSettings builtinBundlesSettings;
            HashMap<TextMateFileNameMatcher, CharSequence> oldExtensionsMapping = new HashMap<TextMateFileNameMatcher, CharSequence>(this.myExtensionMapping);
            this.unregisterAllBundles();
            TextMateUserBundlesSettings settings = TextMateUserBundlesSettings.getInstance();
            if (settings == null) {
                return;
            }
            ConcurrentHashMap<TextMateFileNameMatcher, CharSequence> newExtensionsMapping = new ConcurrentHashMap<TextMateFileNameMatcher, CharSequence>();
            if (!this.ourBuiltinBundlesDisabled && (builtinBundlesSettings = TextMateBuiltinBundlesSettings.getInstance()) != null) {
                Set<String> turnedOffBundleNames = builtinBundlesSettings.getTurnedOffBundleNames();
                List builtInBundles = TextMateServiceImpl.discoverBuiltinBundles(builtinBundlesSettings);
                List bundlesToEnable = turnedOffBundleNames.isEmpty() ? builtInBundles : ContainerUtil.filter(builtInBundles, bundleToLoad -> !turnedOffBundleNames.contains(bundleToLoad.getName()));
                TextMateBundlesLoader.registerBundlesInParallel(this.myScope, bundlesToEnable, (Function1<? super TextMateBundleToLoad, Boolean>)((Function1)bundleToLoad -> this.registerBundle(Path.of(bundleToLoad.getPath(), new String[0]), newExtensionsMapping)));
            }
            if (!(userBundles = settings.getBundles()).isEmpty()) {
                @NotNull List paths = ContainerUtil.mapNotNull(userBundles.entrySet(), entry -> ((TextMatePersistentBundle)entry.getValue()).getEnabled() ? new TextMateBundleToLoad(((TextMatePersistentBundle)entry.getValue()).getName(), (String)entry.getKey()) : null);
                TextMateBundlesLoader.registerBundlesInParallel(this.myScope, paths, (Function1<? super TextMateBundleToLoad, Boolean>)((Function1)bundleToLoad -> this.registerBundle(Path.of(bundleToLoad.getPath(), new String[0]), newExtensionsMapping)), bundleToLoad -> {
                    String bundleName = bundleToLoad.getName();
                    String errorMessage = TextMateBundle.message("textmate.cant.register.bundle", bundleName);
                    new Notification("TextMate Bundles", TextMateBundle.message("textmate.bundle.load.error", bundleName), errorMessage, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimpleExpiring((String)TextMateBundle.message("textmate.disable.bundle.notification.action", bundleName), () -> settings.disableBundle(bundleToLoad.getPath()))).notify(null);
                });
            }
            if (fireEvents && !oldExtensionsMapping.equals(newExtensionsMapping)) {
                TextMateServiceImpl.fireFileTypesChangedEvent("old mappings = " + oldExtensionsMapping + ", new mappings" + newExtensionsMapping, () -> {
                    this.myExtensionMapping = newExtensionsMapping;
                });
            } else {
                this.myExtensionMapping = newExtensionsMapping;
            }
            this.mySyntaxTable.compact();
        }
        finally {
            this.myRegistrationLock.unlock();
        }
    }

    private static void fireFileTypesChangedEvent(@NonNls @NotNull String reason, @NotNull Runnable update) {
        if (reason == null) {
            TextMateServiceImpl.$$$reportNull$$$0(0);
        }
        if (update == null) {
            TextMateServiceImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            fileTypeManager.makeFileTypesChange(reason, update);
        }), ModalityState.nonModal());
    }

    @ApiStatus.Internal
    public static List<TextMateBundleToLoad> discoverBuiltinBundles(@NotNull TextMateBuiltinBundlesSettings builtinBundlesSettings) {
        List<TextMateBundleToLoad> builtinBundles;
        if (builtinBundlesSettings == null) {
            TextMateServiceImpl.$$$reportNull$$$0(2);
        }
        if ((builtinBundles = builtinBundlesSettings.getBuiltinBundles()).isEmpty()) {
            List<TextMateBundleToLoad> list;
            block10: {
                Path builtinBundlesPath = TextMateServiceImpl.getBundledBundlePath();
                Stream<Path> files = Files.list(builtinBundlesPath);
                try {
                    List<TextMateBundleToLoad> bundles = files.filter(file -> !StringUtil.startsWithChar((CharSequence)file.getFileName().toString(), (char)'.')).map(file -> new TextMateBundleToLoad(file.getFileName().toString(), file.toString())).toList();
                    builtinBundlesSettings.setBuiltinBundles(bundles);
                    list = bundles;
                    if (files == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        LOG.warn("Couldn't list builtin textmate bundles at " + builtinBundlesPath, e);
                        return Collections.emptyList();
                    }
                }
                files.close();
            }
            return list;
        }
        return builtinBundles;
    }

    private void unregisterAllBundles() {
        this.myExtensionMapping.clear();
        this.myPreferenceRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    @NotNull
    public Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors() {
        this.ensureInitialized();
        Map<CharSequence, TextMateTextAttributesAdapter> map = this.myCustomHighlightingColors;
        if (map == null) {
            TextMateServiceImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public ShellVariablesRegistry getShellVariableRegistry() {
        this.ensureInitialized();
        ShellVariablesRegistryImpl shellVariablesRegistryImpl = this.myShellVariablesRegistry;
        if (shellVariablesRegistryImpl == null) {
            TextMateServiceImpl.$$$reportNull$$$0(4);
        }
        return shellVariablesRegistryImpl;
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetRegistry() {
        this.ensureInitialized();
        SnippetsRegistryImpl snippetsRegistryImpl = this.mySnippetRegistry;
        if (snippetsRegistryImpl == null) {
            TextMateServiceImpl.$$$reportNull$$$0(5);
        }
        return snippetsRegistryImpl;
    }

    @Override
    @NotNull
    public PreferencesRegistry getPreferenceRegistry() {
        this.ensureInitialized();
        PreferencesRegistryImpl preferencesRegistryImpl = this.myPreferenceRegistry;
        if (preferencesRegistryImpl == null) {
            TextMateServiceImpl.$$$reportNull$$$0(6);
        }
        return preferencesRegistryImpl;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(7);
        }
        if (Strings.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        CharSequence scopeName = this.myExtensionMapping.get(new TextMateFileNameMatcher.Name(StringUtil.toLowerCase((String)fileName.toString())));
        if (!Strings.isEmpty((CharSequence)scopeName)) {
            return new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName));
        }
        Iterator extensionsIterator = TextMateEditorUtilsKt.fileNameExtensions(fileName).iterator();
        while (extensionsIterator.hasNext()) {
            TextMateLanguageDescriptor descriptor = this.getLanguageDescriptorByExtension((CharSequence)extensionsIterator.next());
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        if (Strings.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        CharSequence scopeName = this.myExtensionMapping.get(new TextMateFileNameMatcher.Extension(StringUtil.toLowerCase((String)extension.toString())));
        return !Strings.isEmpty((CharSequence)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    @Override
    @Nullable
    public TextMateBundleReader readBundle(@Nullable Path directory) {
        if (directory != null) {
            BundleType bundleType = BundleType.detectBundleType(directory);
            return switch (bundleType) {
                default -> throw new IncompatibleClassChangeError();
                case BundleType.TEXTMATE -> BundleReaderKt.readTextMateBundle(directory);
                case BundleType.SUBLIME -> BundleReaderKt.readSublimeBundle(directory);
                case BundleType.VSCODE -> VSCBundleReaderKt.readVSCBundle((Function1<? super String, ? extends InputStream>)((Function1)relativePath -> {
                    try {
                        return Files.newInputStream(directory.resolve((String)relativePath), new OpenOption[0]);
                    }
                    catch (NoSuchFileException e) {
                        TextMateService.LOG.warn("Cannot find referenced file `" + relativePath + "` in bundle `" + directory + "`");
                        return null;
                    }
                    catch (Throwable e) {
                        TextMateService.LOG.warn("Cannot read referenced file `" + relativePath + "` in bundle `" + directory + "`", e);
                        return null;
                    }
                }));
                case BundleType.UNDEFINED -> null;
            };
        }
        return null;
    }

    private void ensureInitialized() {
        if (!this.myInitialized) {
            this.myRegistrationLock.lock();
            try {
                if (this.myInitialized) {
                    return;
                }
                this.registerBundles(false);
                this.myInitialized = true;
            }
            finally {
                this.myRegistrationLock.unlock();
            }
        }
    }

    private boolean registerBundle(@Nullable Path directory, @NotNull Map<TextMateFileNameMatcher, CharSequence> extensionMapping) {
        TextMateBundleReader reader;
        if (extensionMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(8);
        }
        if ((reader = this.readBundle(directory)) != null) {
            this.registerLanguageSupport(reader, extensionMapping);
            this.registerPreferences(reader);
            this.registerSnippets(reader);
            return true;
        }
        return false;
    }

    private void registerSnippets(@NotNull TextMateBundleReader reader) {
        if (reader == null) {
            TextMateServiceImpl.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Iterator snippetsIterator = reader.readSnippets().iterator();
            while (snippetsIterator.hasNext()) {
                this.mySnippetRegistry.register((TextMateSnippet)snippetsIterator.next());
            }
        }
    }

    private void registerPreferences(@NotNull TextMateBundleReader reader) {
        if (reader == null) {
            TextMateServiceImpl.$$$reportNull$$$0(10);
        }
        for (TextMatePreferences preferences : reader.readPreferences()) {
            CharSequence scopeName = (CharSequence)this.myInterner.intern((Object)preferences.getScopeName());
            Set internedHighlightingPairs = (Set)ObjectUtils.doIfNotNull(preferences.getHighlightingPairs(), pairs -> ContainerUtil.map2Set((Collection)pairs, p -> new TextMateBracePair((CharSequence)this.myInterner.intern((Object)p.getLeft()), (CharSequence)this.myInterner.intern((Object)p.getRight()))));
            Set internedSmartTypingPairs = (Set)ObjectUtils.doIfNotNull(preferences.getSmartTypingPairs(), pairs -> ContainerUtil.map2Set((Collection)pairs, p -> new TextMateAutoClosingPair((CharSequence)this.myInterner.intern((Object)p.getLeft()), (CharSequence)this.myInterner.intern((Object)p.getRight()), p.getNotIn())));
            Set internedSurroundingPairs = (Set)ObjectUtils.doIfNotNull(preferences.getSurroundingPairs(), pairs -> ContainerUtil.map2Set((Collection)pairs, p -> new TextMateBracePair((CharSequence)this.myInterner.intern((Object)p.getLeft()), (CharSequence)this.myInterner.intern((Object)p.getRight()))));
            this.myPreferenceRegistry.addPreferences(new Preferences(scopeName, internedHighlightingPairs, internedSmartTypingPairs, internedSurroundingPairs, preferences.getAutoCloseBefore(), preferences.getIndentationRules()));
            for (TextMateShellVariable variable : preferences.getVariables()) {
                this.myShellVariablesRegistry.addVariable(variable);
            }
            TextMateTextAttributes customHighlightingAttributes = preferences.getCustomHighlightingAttributes();
            if (customHighlightingAttributes == null) continue;
            this.myCustomHighlightingColors.put(scopeName, new TextMateTextAttributesAdapter(scopeName, customHighlightingAttributes));
        }
    }

    private void registerLanguageSupport(@NotNull TextMateBundleReader reader, @NotNull Map<TextMateFileNameMatcher, CharSequence> extensionMapping) {
        if (reader == null) {
            TextMateServiceImpl.$$$reportNull$$$0(11);
        }
        if (extensionMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(12);
        }
        for (TextMateGrammar grammar : reader.readGrammars()) {
            CharSequence rootScopeName = this.mySyntaxTable.loadSyntax((Plist)grammar.getPlist().getValue(), this.myInterner);
            if (rootScopeName == null) continue;
            for (TextMateFileNameMatcher fileNameMatcher : grammar.getFileNameMatchers()) {
                if (fileNameMatcher instanceof TextMateFileNameMatcher.Name) {
                    String newName = StringUtil.toLowerCase((String)((TextMateFileNameMatcher.Name)fileNameMatcher).getFileName());
                    extensionMapping.put(((TextMateFileNameMatcher.Name)fileNameMatcher).copy(newName), rootScopeName);
                    continue;
                }
                extensionMapping.put(fileNameMatcher, rootScopeName);
            }
        }
    }

    @TestOnly
    public void disableBuiltinBundles(Disposable disposable) {
        this.ourBuiltinBundlesDisabled = true;
        TextMateService.getInstance().reloadEnabledBundles();
        this.myInitialized = true;
        Disposer.register((Disposable)disposable, () -> {
            this.ourBuiltinBundlesDisabled = false;
            this.unregisterAllBundles();
            this.myInitialized = false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtinBundlesSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionMapping";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHighlightingColors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellVariableRegistry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetRegistry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferenceRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireFileTypesChangedEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "discoverBuiltinBundles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDescriptorByFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerBundle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerSnippets";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerPreferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSupport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

