/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.debugger;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/debugger/GradleJvmDebuggerBackend;", "Lcom/intellij/openapi/externalSystem/debugger/DebuggerBackendExtension;", "()V", "debugConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "project", "Lcom/intellij/openapi/project/Project;", "processName", "", "processParameters", "id", "initializationCode", "", "dispatchPort", "parameters", "intellij.gradle.java"})
public final class GradleJvmDebuggerBackend
implements DebuggerBackendExtension {
    @NotNull
    public String id() {
        return "Gradle JVM";
    }

    @NotNull
    public RunnerAndConfigurationSettings debugConfigurationSettings(@NotNull Project project, @NotNull String processName, @NotNull String processParameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        RunnerAndConfigurationSettings runSettings = RunManager.Companion.getInstance(project).createConfiguration(processName, RemoteConfigurationType.class);
        HashMap description = this.splitParameters(processParameters);
        RunConfiguration runConfiguration = runSettings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.execution.remote.RemoteConfiguration");
        RemoteConfiguration configuration = (RemoteConfiguration)runConfiguration;
        configuration.HOST = "localhost";
        configuration.PORT = (String)description.get("DEBUG_SERVER_PORT");
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = true;
        configuration.putUserData(DebuggerBackendExtension.RUNTIME_MODULE_DIR_KEY, description.get("MODULE_DIR"));
        return runSettings;
    }

    @NotNull
    public List<String> initializationCode(@NotNull String dispatchPort, @NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)dispatchPort, (String)"dispatchPort");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String initScript2 = GradleInitScriptUtil.loadJvmDebugInitScript((String)this.id(), (String)parameters);
        String[] stringArray = new String[]{"\n"};
        return StringsKt.split$default((CharSequence)initScript2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }
}

