/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.externalSystem.JarTaskManifestData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.jar.JarTaskManifestConfiguration;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.tooling.internal.jar.JarTaskManifestConfigurationImpl;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\u000bH\u0016J\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/JarTaskManifestResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "doPopulate", "", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "ideModule", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "Lorg/jetbrains/plugins/gradle/model/jar/JarTaskManifestConfiguration;", "getToolingExtensionsClasses", "Lorg/jetbrains/plugins/gradle/tooling/internal/jar/JarTaskManifestConfigurationImpl;", "populateModuleExtraModels", "intellij.gradle.java"})
public final class JarTaskManifestResolver
extends AbstractProjectResolverExtension {
    @NotNull
    public Set<Class<JarTaskManifestConfiguration>> getExtraProjectModelClasses() {
        return SetsKt.setOf(JarTaskManifestConfiguration.class);
    }

    @NotNull
    public Set<Class<JarTaskManifestConfigurationImpl>> getToolingExtensionsClasses() {
        return SetsKt.setOf(JarTaskManifestConfigurationImpl.class);
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
        this.doPopulate(gradleModule, ideModule);
        super.populateModuleExtraModels(gradleModule, ideModule);
    }

    private final void doPopulate(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        JarTaskManifestConfiguration jarTaskManifestConfiguration = (JarTaskManifestConfiguration)this.resolverCtx.getModels().getModel((ProjectModel)gradleModule, JarTaskManifestConfiguration.class);
        if (jarTaskManifestConfiguration == null) {
            return;
        }
        JarTaskManifestConfiguration model = jarTaskManifestConfiguration;
        Object object = ideModule.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        ModuleData moduleData = (ModuleData)object;
        String string = GradleModuleDataKt.getGradleIdentityPathOrNull((ModuleData)moduleData);
        if (string == null) {
            String string2 = moduleData.getId();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        }
        String moduleIdentityPath = string;
        Map map = (Map)model.getProjectIdentityPathToManifestAttributes().get(moduleIdentityPath);
        if (map == null) {
            return;
        }
        Map manifestAttributes = map;
        DataNode dataNode = ExternalSystemApiUtil.findChild(ideModule, (Key)ProjectKeys.TASK, arg_0 -> JarTaskManifestResolver.doPopulate$lambda$0((Function1)new Function1<DataNode<TaskData>, Boolean>(moduleData){
            final /* synthetic */ ModuleData $moduleData;
            {
                this.$moduleData = $moduleData;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DataNode<TaskData> it) {
                return Intrinsics.areEqual((Object)((TaskData)it.getData()).getName(), (Object)"jar") || Intrinsics.areEqual((Object)((TaskData)it.getData()).getName(), (Object)(this.$moduleData.getId() + ":jar"));
            }
        }, arg_0));
        if (dataNode == null) {
            return;
        }
        DataNode jarTask2 = dataNode;
        jarTask2.createChild(JarTaskManifestData.KEY, (Object)new JarTaskManifestData(manifestAttributes));
    }

    private static final boolean doPopulate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

