/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.GitSilentFileAdderProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.buildscript.GradleBuildScriptBuilder;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.wizard.util.GradleWrapperUtil;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleDefaultProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

public abstract class AbstractGradleModuleBuilder
extends AbstractExternalModuleBuilder<GradleProjectSettings> {
    private static final Logger LOG = Logger.getInstance(AbstractGradleModuleBuilder.class);
    private static final String TEMPLATE_GRADLE_SETTINGS = "Gradle Settings.gradle";
    private static final String TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Settings merge.gradle";
    private static final String TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Build Script with wrapper.gradle";
    private static final String DEFAULT_TEMPLATE_GRADLE_BUILD = "Gradle Build Script.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_BUILD = "Gradle Kotlin DSL Build Script.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Kotlin DSL Build Script with wrapper.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS = "Gradle Kotlin DSL Settings.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Kotlin DSL Settings merge.gradle";
    private static final String TEMPLATE_ATTRIBUTE_PROJECT_NAME = "PROJECT_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_PATH = "MODULE_PATH";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR = "MODULE_FLAT_DIR";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_NAME = "MODULE_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_GROUP = "MODULE_GROUP";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_VERSION = "MODULE_VERSION";
    private static final String TEMPLATE_ATTRIBUTE_GRADLE_VERSION = "GRADLE_VERSION";
    private static final Key<BuildScriptDataBuilder> BUILD_SCRIPT_DATA = Key.create((String)"gradle.module.buildScriptData");
    @Nullable
    private ProjectData myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private ProjectId myProjectId;
    private Path rootProjectPath;
    private boolean myUseKotlinDSL;
    private boolean isCreatingNewProject;
    private boolean createEmptyContentRoots = true;
    private GradleVersion gradleVersion;
    private DistributionType gradleDistributionType;
    @Nullable
    private String gradleHome;
    private boolean isCreatingBuildScriptFile = true;
    private VirtualFile buildScriptFile;
    private VirtualFile settingsScriptFile;
    private GradleBuildScriptBuilder<?> buildScriptBuilder;
    private final List<Consumer<GradleBuildScriptBuilder<?>>> buildScriptConfigurators = new ArrayList();
    private final List<BiConsumer<VirtualFile, VirtualFile>> preImportConfigurators = new ArrayList<BiConsumer<VirtualFile, VirtualFile>>();

    public AbstractGradleModuleBuilder() {
        super(GradleConstants.SYSTEM_ID, (ExternalProjectSettings)GradleDefaultProjectSettings.createProjectSettings((String)""));
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, ConfigurationException {
        if (moduleModel == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(this.getName() != null);
        String moduleFilePath = this.getModuleFilePath();
        LOG.assertTrue(moduleFilePath != null);
        AbstractGradleModuleBuilder.deleteModuleFile((String)moduleFilePath);
        String moduleTypeId = this.getModuleType().getId();
        Module module2 = moduleModel.newModule(moduleFilePath, moduleTypeId);
        this.setupModule(module2);
        Module module3 = module2;
        if (module3 == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(1);
        }
        return module3;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        String contentEntryPath;
        if (modifiableRootModel == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(contentEntryPath = this.getContentEntryPath()))) {
            return;
        }
        File contentRootDir = new File(contentEntryPath);
        FileUtilRt.createDirectory((File)contentRootDir);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByIoFile(contentRootDir);
        if (modelContentRootDir == null) {
            return;
        }
        modifiableRootModel.addContentEntry(modelContentRootDir);
        Project project = modifiableRootModel.getProject();
        Module module2 = modifiableRootModel.getModule();
        if (this.myParentProject != null) {
            this.rootProjectPath = Paths.get(this.myParentProject.getLinkedExternalProjectPath(), new String[0]);
        } else {
            Path path = this.rootProjectPath = this.isCreatingNewProject ? Paths.get(Objects.requireNonNull(project.getBasePath()), new String[0]) : modelContentRootDir.toNioPath();
        }
        if (this.isCreatingBuildScriptFile) {
            this.buildScriptFile = this.setupGradleBuildFile(modelContentRootDir);
        }
        this.settingsScriptFile = AbstractGradleModuleBuilder.setupGradleSettingsFile(this.rootProjectPath, modelContentRootDir, project.getName(), this.myProjectId == null ? module2.getName() : this.myProjectId.getArtifactId(), this.isCreatingNewLinkedProject(), this.myUseKotlinDSL);
        if (this.isCreatingBuildScriptFile) {
            this.buildScriptBuilder = GradleBuildScriptBuilder.create((GradleVersion)this.gradleVersion, (boolean)this.myUseKotlinDSL);
            this.buildScriptConfigurators.forEach(it -> it.accept(this.buildScriptBuilder));
            BuildScriptDataBuilder scriptDataBuilder = new BuildScriptDataBuilder(this.buildScriptFile, this.buildScriptBuilder);
            modifiableRootModel.getModule().putUserData(BUILD_SCRIPT_DATA, (Object)scriptDataBuilder);
        }
    }

    protected void setupModule(Module module2) throws ConfigurationException {
        super.setupModule(module2);
        assert (this.rootProjectPath != null);
        VirtualFile buildScriptFile = this.createAndConfigureBuildScriptFile();
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module2);
        modulePropertyManager.setExternalId(GradleConstants.SYSTEM_ID);
        modulePropertyManager.setRootProjectPath(PathKt.getSystemIndependentPath((Path)this.rootProjectPath));
        modulePropertyManager.setLinkedProjectPath(PathKt.getSystemIndependentPath((Path)this.rootProjectPath));
        Project project = module2.getProject();
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        GradleProjectSettings projectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
        if (this.isCreatingNewLinkedProject()) {
            projectSettings.setExternalProjectPath(NioPathUtil.toCanonicalPath((Path)this.rootProjectPath));
            projectSettings.setDistributionType(this.gradleDistributionType);
            projectSettings.setGradleHome(this.gradleHome);
            GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)this.gradleVersion);
            GradleJvmValidationUtil.validateJavaHome((Project)project, (Path)this.rootProjectPath, (GradleVersion)this.gradleVersion);
            settings.linkProject((ExternalProjectSettings)projectSettings);
        }
        if (this.isCreatingNewProject) {
            ExternalProjectsManagerImpl.setupCreatedProject((Project)project);
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isCreatingNewProject) {
                this.loadPreviewProject(project);
            }
            if (this.isCreatingBuildScriptFile) {
                this.preImportConfigurators.forEach(c -> c.accept(buildScriptFile, this.settingsScriptFile));
                AbstractGradleModuleBuilder.openBuildScriptFile(project, buildScriptFile);
            }
            if (this.isCreatingNewLinkedProject() && this.gradleDistributionType.isWrapped()) {
                this.generateGradleWrapper(project);
            }
            this.reloadProject(project);
        }, ModalityState.nonModal(), project.getDisposed());
    }

    private void loadPreviewProject(@NotNull Project project) {
        if (project == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(3);
        }
        ImportSpecBuilder previewSpec = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        previewSpec.usePreviewMode();
        previewSpec.use(ProgressExecutionMode.MODAL_SYNC);
        previewSpec.callback((ExternalProjectRefreshCallback)new ConfigureGradleModuleCallback(previewSpec));
        ExternalSystemUtil.refreshProject((String)PathKt.getSystemIndependentPath((Path)this.rootProjectPath), (ImportSpecBuilder)previewSpec);
    }

    private void reloadProject(@NotNull Project project) {
        if (project == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(4);
        }
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(() -> {
            ImportSpecBuilder importSpec = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
            if (this.createEmptyContentRoots) {
                importSpec.createDirectoriesForEmptyContentRoots();
            }
            importSpec.callback((ExternalProjectRefreshCallback)new ConfigureGradleModuleCallback(importSpec));
            ExternalSystemUtil.refreshProject((String)PathKt.getSystemIndependentPath((Path)this.rootProjectPath), (ImportSpecBuilder)importSpec);
        });
    }

    private void generateGradleWrapper(@NotNull Project project) {
        if (project == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(5);
        }
        GitSilentFileAdder vcs = GitSilentFileAdderProvider.create((Project)project);
        vcs.markFileForAdding(this.rootProjectPath.resolve("gradle"), true);
        vcs.markFileForAdding(this.rootProjectPath.resolve("gradlew"), false);
        vcs.markFileForAdding(this.rootProjectPath.resolve("gradlew.bat"), false);
        GradleWrapperUtil.generateGradleWrapper(this.rootProjectPath, this.gradleVersion);
        vcs.finish();
    }

    public void configureBuildScript(@NotNull Consumer<GradleBuildScriptBuilder<?>> configure) {
        if (configure == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(6);
        }
        this.buildScriptConfigurators.add(configure);
    }

    public void configurePreImport(@NotNull @NotNull BiConsumer<@NotNull VirtualFile, @NotNull VirtualFile> configure) {
        if (configure == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(7);
        }
        this.preImportConfigurators.add(configure);
    }

    @Nullable
    private VirtualFile createAndConfigureBuildScriptFile() {
        if (!this.isCreatingBuildScriptFile) {
            return null;
        }
        try {
            if (this.buildScriptFile != null && this.buildScriptBuilder != null) {
                this.buildScriptBuilder.addPrefix(new String[]{StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)this.buildScriptFile))});
                String content = StringUtil.convertLineSeparators((String)this.buildScriptBuilder.generate(), (String)AbstractGradleModuleBuilder.lineSeparator(this.buildScriptFile));
                VfsUtil.saveText((VirtualFile)this.buildScriptFile, (String)content);
                return this.buildScriptFile;
            }
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception on applying frameworks templates", (Throwable)e);
        }
        return null;
    }

    private static void openBuildScriptFile(@NotNull Project project, VirtualFile buildScriptFile) {
        if (project == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(8);
        }
        if (buildScriptFile == null) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(buildScriptFile);
        if (psiFile == null) {
            return;
        }
        EditorHelper.openInEditor((PsiElement)psiFile);
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(9);
        }
        if (modulesProvider == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(10);
        }
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk instanceof JavaSdkType && !(sdk instanceof DependentSdkType);
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 2000;
    }

    public ModuleType<?> getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @NotNull
    private VirtualFile setupGradleBuildFile(@NotNull VirtualFile modelContentRootDir) throws ConfigurationException {
        VirtualFile file;
        if (modelContentRootDir == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(11);
        }
        String scriptName = this.myUseKotlinDSL ? "build.gradle.kts" : "build.gradle";
        try {
            file = AbstractGradleModuleBuilder.getOrCreateExternalProjectConfigFile(modelContentRootDir.toNioPath(), scriptName, true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new ConfigurationException(e.getMessage());
        }
        String templateName = this.myUseKotlinDSL ? (((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? KOTLIN_DSL_TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : KOTLIN_DSL_TEMPLATE_GRADLE_BUILD) : (((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : DEFAULT_TEMPLATE_GRADLE_BUILD);
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this.myProjectId != null) {
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_VERSION, this.myProjectId.getVersion());
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_GROUP, this.myProjectId.getGroupId());
            attributes.put(TEMPLATE_ATTRIBUTE_GRADLE_VERSION, this.gradleVersion.getVersion());
        }
        AbstractGradleModuleBuilder.appendToFile(file, templateName, attributes);
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile setupGradleSettingsFile(@NotNull Path rootProjectPath, @NotNull VirtualFile modelContentRootDir, String projectName, String moduleName, boolean renderNewFile, boolean useKotlinDSL) throws ConfigurationException {
        VirtualFile file;
        if (rootProjectPath == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(13);
        }
        if (modelContentRootDir == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(14);
        }
        if (!renderNewFile) {
            Path settingsFile = rootProjectPath.resolve("settings.gradle");
            Path kotlinKtsSettingsFile = rootProjectPath.resolve("settings.gradle.kts");
            useKotlinDSL = !Files.exists(settingsFile, new LinkOption[0]) && (Files.exists(kotlinKtsSettingsFile, new LinkOption[0]) || useKotlinDSL);
        }
        String scriptName = useKotlinDSL ? "settings.gradle.kts" : "settings.gradle";
        try {
            file = AbstractGradleModuleBuilder.getOrCreateExternalProjectConfigFile(rootProjectPath, scriptName, renderNewFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new ConfigurationException(e.getMessage());
        }
        if (renderNewFile) {
            String templateName = useKotlinDSL ? KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS : TEMPLATE_GRADLE_SETTINGS;
            String moduleDirName = VfsUtilCore.getRelativePath((VirtualFile)modelContentRootDir, (VirtualFile)file.getParent(), (char)'/');
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(TEMPLATE_ATTRIBUTE_PROJECT_NAME, projectName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, moduleDirName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            AbstractGradleModuleBuilder.appendToFile(file, templateName, attributes);
        } else {
            String flatStructureModulePath;
            String templateName = useKotlinDSL ? KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS_MERGE : TEMPLATE_GRADLE_SETTINGS_MERGE;
            char separatorChar = file.getParent() == null || !VfsUtilCore.isAncestor((VirtualFile)file.getParent(), (VirtualFile)modelContentRootDir, (boolean)true) ? (char)'/' : ':';
            String modulePath = VfsUtilCore.findRelativePath((VirtualFile)file, (VirtualFile)modelContentRootDir, (char)separatorChar);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            String string = flatStructureModulePath = modulePath != null && StringUtil.startsWith((CharSequence)modulePath, (CharSequence)"../") ? StringUtil.trimStart((String)modulePath, (String)"../") : null;
            if (StringUtil.equals(flatStructureModulePath, (CharSequence)modelContentRootDir.getName())) {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR, "true");
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, flatStructureModulePath);
            } else {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, modulePath);
            }
            AbstractGradleModuleBuilder.appendToFile(file, templateName, attributes);
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    private static void appendToFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map<String, String> templateAttributes) throws ConfigurationException {
        if (file == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(16);
        }
        if (templateName == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(17);
        }
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            AbstractGradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (Exception e) {
            LOG.warn(String.format("Unexpected exception on appending template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(GradleInspectionBundle.message("dialog.message.generate.scripts.error", new Object[0]) + "\n" + e.getMessage(), UIBundle.message((String)"error.project.wizard.new.project.title", (Object[])new Object[]{1}));
        }
    }

    @NotNull
    private static VirtualFile getOrCreateExternalProjectConfigFile(@NotNull Path parent, @NotNull String fileName, boolean deleteExistingFile) throws ConfigurationException, IOException {
        if (parent == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(18);
        }
        if (fileName == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(19);
        }
        Path file = parent.resolve(fileName);
        if (deleteExistingFile) {
            Files.deleteIfExists(file);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try {
            Files.createFile(file, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
        if (virtualFile == null) {
            throw new ConfigurationException(GradleInspectionBundle.message("dialog.message.can.t.create.configuration.file", file));
        }
        if (virtualFile.isDirectory()) {
            throw new ConfigurationException(GradleInspectionBundle.message("dialog.message.configuration.file.directory", file));
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(20);
        }
        return virtualFile2;
    }

    @Nullable
    public ProjectData getParentProject() {
        return this.myParentProject;
    }

    public void setParentProject(@Nullable ProjectData parentProject) {
        this.myParentProject = parentProject;
    }

    private boolean isCreatingNewLinkedProject() {
        return this.myParentProject == null;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public void setInheritGroupId(boolean inheritGroupId) {
        this.myInheritGroupId = inheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setInheritVersion(boolean inheritVersion) {
        this.myInheritVersion = inheritVersion;
    }

    public ProjectId getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(@NotNull ProjectId projectId) {
        if (projectId == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(21);
        }
        this.myProjectId = projectId;
    }

    public boolean isCreatingNewProject() {
        return this.isCreatingNewProject;
    }

    public void setCreatingNewProject(boolean creatingNewProject) {
        this.isCreatingNewProject = creatingNewProject;
    }

    public void setCreateEmptyContentRoots(boolean createEmptyContentRoots) {
        this.createEmptyContentRoots = createEmptyContentRoots;
    }

    public void setGradleVersion(@NotNull GradleVersion version) {
        if (version == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(22);
        }
        this.gradleVersion = version;
    }

    public void setGradleDistributionType(@NotNull DistributionType distributionType) {
        if (distributionType == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(23);
        }
        this.gradleDistributionType = distributionType;
    }

    public void setGradleHome(@Nullable String path) {
        this.gradleHome = path;
    }

    public void setCreatingBuildScriptFile(boolean creatingBuildScriptFile) {
        this.isCreatingBuildScriptFile = creatingBuildScriptFile;
    }

    public boolean isCreatingBuildScriptFile() {
        return this.isCreatingBuildScriptFile;
    }

    public void cleanup() {
        this.myJdk = null;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(24);
        }
        if (settingsStep instanceof ProjectSettingsStep) {
            ProjectSettingsStep projectSettingsStep = (ProjectSettingsStep)settingsStep;
            if (this.myProjectId != null) {
                ModuleNameLocationSettings nameLocationSettings = settingsStep.getModuleNameLocationSettings();
                String artifactId = this.myProjectId.getArtifactId();
                if (nameLocationSettings != null && artifactId != null) {
                    nameLocationSettings.setModuleName(artifactId);
                }
            }
            projectSettingsStep.bindModuleSettings();
        }
        return super.modifySettingsStep(settingsStep);
    }

    public static void appendToFile(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        if (file == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(25);
        }
        if (text == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(26);
        }
        String lineSeparator = AbstractGradleModuleBuilder.lineSeparator(file);
        String existingText = StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)file));
        String content = (String)(StringUtil.isNotEmpty((String)existingText) ? existingText + lineSeparator : "") + StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
        VfsUtil.saveText((VirtualFile)file, (String)content);
    }

    @NotNull
    private static String lineSeparator(@NotNull VirtualFile file) {
        String lineSeparator;
        if (file == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(27);
        }
        if ((lineSeparator = LoadTextUtil.detectLineSeparator((VirtualFile)file, (boolean)true)) == null) {
            lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        }
        String string = lineSeparator;
        if (string == null) {
            AbstractGradleModuleBuilder.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static BuildScriptDataBuilder getBuildScriptData(@Nullable Module module2) {
        return module2 == null ? null : (BuildScriptDataBuilder)module2.getUserData(BUILD_SCRIPT_DATA);
    }

    @Nullable
    public Project createProject(String name, String path) {
        this.setCreatingNewProject(true);
        return super.createProject(name, path);
    }

    public boolean isUseKotlinDsl() {
        return this.myUseKotlinDSL;
    }

    public void setUseKotlinDsl(boolean useKotlinDSL) {
        this.myUseKotlinDSL = useKotlinDSL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12, 15, 20, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configure";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelContentRootDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 16: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setupGradleBuildFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setupGradleSettingsFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExternalProjectConfigFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "lineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 1: 
            case 12: 
            case 15: 
            case 20: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadPreviewProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reloadProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateGradleWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureBuildScript";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configurePreImport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openBuildScriptFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupGradleBuildFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupGradleSettingsFile";
                break;
            }
            case 16: 
            case 17: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendToFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateExternalProjectConfigFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setProjectId";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setGradleVersion";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setGradleDistributionType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lineSeparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12, 15, 20, 28 -> new IllegalStateException(string);
        };
    }

    private final class ConfigureGradleModuleCallback
    implements ExternalProjectRefreshCallback {
        @Nullable
        private final String externalConfigPath;
        @Nullable
        private final String sdkName;
        @NotNull
        private final ImportSpecBuilder.DefaultProjectRefreshCallback defaultCallback;

        ConfigureGradleModuleCallback(ImportSpecBuilder importSpecBuilder) {
            if (importSpecBuilder == null) {
                ConfigureGradleModuleCallback.$$$reportNull$$$0(0);
            }
            this.defaultCallback = new ImportSpecBuilder.DefaultProjectRefreshCallback(importSpecBuilder.build());
            this.sdkName = AbstractGradleModuleBuilder.this.myJdk == null ? null : AbstractGradleModuleBuilder.this.myJdk.getName();
            this.externalConfigPath = FileUtil.toCanonicalPath((String)AbstractGradleModuleBuilder.this.getContentEntryPath());
        }

        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject != null) {
                this.configureModulesSdk(externalProject);
            }
            this.defaultCallback.onSuccess(externalProject);
        }

        private void configureModulesSdk(@NotNull DataNode<ProjectData> projectNode) {
            DataNode moduleNode;
            if (projectNode == null) {
                ConfigureGradleModuleCallback.$$$reportNull$$$0(1);
            }
            if ((moduleNode = ExternalSystemApiUtil.findChild(projectNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE, this::isTargetModule)) == null) {
                return;
            }
            this.configureModuleSdk((DataNode<? extends ModuleData>)moduleNode);
            Collection sourceSetsNodes = ExternalSystemApiUtil.getChildren((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)GradleSourceSetData.KEY);
            for (DataNode sourceSetsNode : sourceSetsNodes) {
                this.configureModuleSdk((DataNode<? extends ModuleData>)sourceSetsNode);
            }
        }

        private void configureModuleSdk(@NotNull DataNode<? extends ModuleData> moduleNode) {
            DataNode moduleSdkNode;
            if (moduleNode == null) {
                ConfigureGradleModuleCallback.$$$reportNull$$$0(2);
            }
            if ((moduleSdkNode = ExternalSystemApiUtil.find(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ModuleSdkData.KEY)) == null) {
                return;
            }
            ((ModuleSdkData)moduleSdkNode.getData()).setSdkName(this.sdkName);
        }

        private boolean isTargetModule(@NotNull DataNode<ModuleData> moduleNode) {
            if (moduleNode == null) {
                ConfigureGradleModuleCallback.$$$reportNull$$$0(3);
            }
            ModuleData moduleData = (ModuleData)moduleNode.getData();
            String linkedExternalProjectPath = moduleData.getLinkedExternalProjectPath();
            return linkedExternalProjectPath.equals(this.externalConfigPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importSpecBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectNode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleNode";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder$ConfigureGradleModuleCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureModulesSdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configureModuleSdk";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTargetModule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

