/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.cache.GradleLocalCacheHelper;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleDependencySourceDownloader;
import org.jetbrains.plugins.gradle.util.JarUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0019\u0010\u0016\u001a\u00130\u0011\u00a2\u0006\u000e\b\u0017\u0012\n\b\u0018\u0012\u0006\b\n0\u00198\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J*\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0018\u0010$\u001a\u00020%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleDownloadSourceAction;", "Lcom/intellij/codeInsight/AttachSourcesProvider$AttachSourcesAction;", "orderEntries", "", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "psiFile", "Lcom/intellij/psi/PsiFile;", "gradleModuleProvider", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/module/Module;", "(Ljava/util/List;Lcom/intellij/psi/PsiFile;Ljava/util/function/Supplier;)V", "attachSources", "", "sourcesJar", "Ljava/io/File;", "getBusyText", "", "Lcom/intellij/openapi/util/NlsContexts$LinkLabel;", "getLibraryUnifiedCoordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "sourceArtifactNotation", "getName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "isArtifactId", "", "artifactIdCandidate", "libraryOrderEntry", "lookupSourcesPathFromCache", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "perform", "Lcom/intellij/openapi/util/ActionCallback;", "orderEntriesContainingFile", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleDownloadSourceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDownloadSourceAction.kt\norg/jetbrains/plugins/gradle/util/GradleDownloadSourceAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n12474#3,2:151\n1855#4,2:153\n*S KotlinDebug\n*F\n+ 1 GradleDownloadSourceAction.kt\norg/jetbrains/plugins/gradle/util/GradleDownloadSourceAction\n*L\n147#1:151,2\n106#1:153,2\n*E\n"})
public final class GradleDownloadSourceAction
implements AttachSourcesProvider.AttachSourcesAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LibraryOrderEntry> orderEntries;
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final Supplier<Map<LibraryOrderEntry, Module>> gradleModuleProvider;
    @NotNull
    private static final String ANDROID_LIBRARY_SUFFIX = "@aar";

    public GradleDownloadSourceAction(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile, @NotNull Supplier<Map<LibraryOrderEntry, Module>> gradleModuleProvider) {
        Intrinsics.checkNotNullParameter(orderEntries, (String)"orderEntries");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(gradleModuleProvider, (String)"gradleModuleProvider");
        this.orderEntries = orderEntries;
        this.psiFile = psiFile;
        this.gradleModuleProvider = gradleModuleProvider;
    }

    @NotNull
    public String getName() {
        String string = GradleBundle.message((String)"gradle.action.download.sources", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getBusyText() {
        String string = GradleBundle.message((String)"gradle.action.download.sources.busy.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
        Intrinsics.checkNotNullParameter(orderEntriesContainingFile, (String)"orderEntriesContainingFile");
        Map<LibraryOrderEntry, Module> map = this.gradleModuleProvider.get();
        Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
        Map<LibraryOrderEntry, Module> gradleModules = map;
        if (gradleModules.isEmpty()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"REJECTED");
            return actionCallback;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)gradleModules.entrySet());
        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry.getKey();
        Module module2 = (Module)entry.getValue();
        if (CachedModuleDataFinder.getGradleModuleData((Module)module2) == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"REJECTED");
            return actionCallback;
        }
        String libraryName = libraryOrderEntry.getLibraryName();
        if (libraryName == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"REJECTED");
            return actionCallback;
        }
        String artifactCoordinates = StringsKt.removePrefix((String)libraryName, (CharSequence)(GradleConstants.SYSTEM_ID.getReadableName() + ": "));
        if (Intrinsics.areEqual((Object)libraryName, (Object)artifactCoordinates)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"REJECTED");
            return actionCallback;
        }
        String externalProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
        if (externalProjectPath == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"REJECTED");
            return actionCallback;
        }
        String sourceArtifactNotation = Companion.getSourceArtifactNotation(artifactCoordinates, arg_0 -> GradleDownloadSourceAction.perform$lambda$0(this, libraryOrderEntry, arg_0));
        Project project = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Path cachedSourcesPath = this.lookupSourcesPathFromCache(libraryOrderEntry, sourceArtifactNotation, project2, externalProjectPath);
        if (cachedSourcesPath != null && JarUtilKt.isValidJar(cachedSourcesPath)) {
            File file = cachedSourcesPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.attachSources(file, this.orderEntries);
            ActionCallback actionCallback = ActionCallback.DONE;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"DONE");
            return actionCallback;
        }
        ActionCallback executionResult = new ActionCallback();
        GradleDependencySourceDownloader.downloadSources(project2, this.getName(), sourceArtifactNotation, externalProjectPath).whenComplete((arg_0, arg_1) -> GradleDownloadSourceAction.perform$lambda$1((Function2)new Function2<File, Throwable, Unit>(executionResult, this){
            final /* synthetic */ ActionCallback $executionResult;
            final /* synthetic */ GradleDownloadSourceAction this$0;
            {
                this.$executionResult = $executionResult;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(File path, Throwable error) {
                if (error != null) {
                    this.$executionResult.setRejected();
                } else {
                    Intrinsics.checkNotNull((Object)path);
                    GradleDownloadSourceAction.access$attachSources(this.this$0, path, GradleDownloadSourceAction.access$getOrderEntries$p(this.this$0));
                    this.$executionResult.setDone();
                }
            }
        }, arg_0, arg_1));
        return executionResult;
    }

    private final void attachSources(File sourcesJar, List<? extends LibraryOrderEntry> orderEntries) {
        ApplicationManager.getApplication().invokeLater(() -> GradleDownloadSourceAction.attachSources$lambda$3(orderEntries, sourcesJar));
    }

    private final Path lookupSourcesPathFromCache(LibraryOrderEntry libraryOrderEntry, String sourceArtifactNotation, Project project, String projectPath) {
        VirtualFile[] virtualFileArray = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootFiles(...)");
        VirtualFile[] rootFiles = virtualFileArray;
        if (rootFiles.length == 0) {
            return null;
        }
        BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.getInstance().guessBuildLayoutParameters(project, projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)buildLayoutParameters, (String)"guessBuildLayoutParameters(...)");
        BuildLayoutParameters buildLayoutParameters2 = buildLayoutParameters;
        String gradleUserHome = (String)GradleTargetUtil.maybeGetLocalValue((TargetValue)buildLayoutParameters2.getGradleUserHome());
        if (gradleUserHome == null) {
            return null;
        }
        if (!FileUtil.isAncestor((String)gradleUserHome, (String)rootFiles[0].getPath(), (boolean)false)) {
            return null;
        }
        UnifiedCoordinates coordinates = this.getLibraryUnifiedCoordinates(sourceArtifactNotation);
        if (coordinates == null) {
            return null;
        }
        Path path = Path.of(gradleUserHome, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)LibraryPathType.SOURCE);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        Map localArtifacts = GradleLocalCacheHelper.findArtifactComponents((UnifiedCoordinates)coordinates, (Path)path, (Set)enumSet);
        List list = (List)localArtifacts.get(LibraryPathType.SOURCE);
        return list != null ? (Path)CollectionsKt.firstOrNull((List)list) : null;
    }

    private final UnifiedCoordinates getLibraryUnifiedCoordinates(String sourceArtifactNotation) {
        String[] stringArray = new String[]{":"};
        List it = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)sourceArtifactNotation, (String)ANDROID_LIBRARY_SUFFIX, (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        return it.size() < 3 ? null : new UnifiedCoordinates((String)it.get(0), (String)it.get(1), (String)it.get(2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArtifactId(String artifactIdCandidate, LibraryOrderEntry libraryOrderEntry) {
        VirtualFile[] virtualFileArray = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootFiles(...)");
        VirtualFile[] rootFiles = virtualFileArray;
        if (rootFiles.length == 0) return true;
        VirtualFile[] $this$any$iv = rootFiles;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            VirtualFile element$iv;
            VirtualFile file = element$iv = $this$any$iv[n];
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string, (String)artifactIdCandidate, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean perform$lambda$0(GradleDownloadSourceAction this$0, LibraryOrderEntry $libraryOrderEntry, String idCandidate) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$libraryOrderEntry, (String)"$libraryOrderEntry");
        Intrinsics.checkNotNullParameter((Object)idCandidate, (String)"idCandidate");
        return this$0.isArtifactId(idCandidate, $libraryOrderEntry);
    }

    private static final void perform$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void attachSources$lambda$3(List $orderEntries, File $sourcesJar) {
        Intrinsics.checkNotNullParameter((Object)$orderEntries, (String)"$orderEntries");
        Intrinsics.checkNotNullParameter((Object)$sourcesJar, (String)"$sourcesJar");
        HashSet libraries = new HashSet();
        Iterable $this$forEach$iv = $orderEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryOrderEntry it = (LibraryOrderEntry)element$iv;
            boolean bl = false;
            ContainerUtil.addIfNotNull((Collection)libraries, (Object)it.getLibrary());
        }
        InternetAttachSourceProvider.attachSourceJar((File)$sourcesJar, (Collection)libraries);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String getSourceArtifactNotation(@NotNull String artifactCoordinates, @NotNull Predicate<String> artifactIdChecker) {
        return Companion.getSourceArtifactNotation(artifactCoordinates, artifactIdChecker);
    }

    public static final /* synthetic */ void access$attachSources(GradleDownloadSourceAction $this, File sourcesJar, List orderEntries) {
        $this.attachSources(sourcesJar, orderEntries);
    }

    public static final /* synthetic */ List access$getOrderEntries$p(GradleDownloadSourceAction $this) {
        return $this.orderEntries;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleDownloadSourceAction$Companion;", "", "()V", "ANDROID_LIBRARY_SUFFIX", "", "getSourceArtifactNotation", "artifactCoordinates", "artifactIdChecker", "Ljava/util/function/Predicate;", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nGradleDownloadSourceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDownloadSourceAction.kt\norg/jetbrains/plugins/gradle/util/GradleDownloadSourceAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String getSourceArtifactNotation(@NotNull String artifactCoordinates, @NotNull Predicate<String> artifactIdChecker) {
            Intrinsics.checkNotNullParameter((Object)artifactCoordinates, (String)"artifactCoordinates");
            Intrinsics.checkNotNullParameter(artifactIdChecker, (String)"artifactIdChecker");
            String[] stringArray = new String[]{":"};
            Object it = StringsKt.split$default((CharSequence)artifactCoordinates, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            it = it.size() == 4 ? (artifactIdChecker.test((String)it.get(1)) ? it.get(0) + ":" + it.get(1) + ":" + it.get(3) : artifactCoordinates) : (it.size() == 5 ? it.get(0) + ":" + it.get(1) + ":" + it.get(4) : artifactCoordinates);
            boolean bl2 = false;
            return StringsKt.removeSuffix((String)it, (CharSequence)GradleDownloadSourceAction.ANDROID_LIBRARY_SUFFIX) + ":sources";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

