/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.wizard;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.ide.starters.local.GeneratorAsset;
import com.intellij.ide.starters.local.GeneratorTemplateFile;
import com.intellij.ide.starters.local.Library;
import com.intellij.ide.starters.local.StandardAssetsProvider;
import com.intellij.ide.starters.local.Starter;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.local.StarterPack;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterSettings;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\tH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u0004H\u0014J&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0004H\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020#H\u0016\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/javaFX/wizard/JavaFxModuleBuilder;", "Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "()V", "getAssets", "", "Lcom/intellij/ide/starters/local/GeneratorAsset;", "starter", "Lcom/intellij/ide/starters/local/Starter;", "getBuilderId", "", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getDescription", "getFilePathsToOpen", "getGeneratorContextProperties", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "dependencyConfig", "Lcom/intellij/ide/starters/local/DependencyConfig;", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getMinJavaVersion", "Lcom/intellij/util/lang/JavaVersion;", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getStarterPack", "Lcom/intellij/ide/starters/local/StarterPack;", "getTestFrameworks", "Lcom/intellij/ide/starters/shared/StarterTestRunner;", "getUnknownFxVersion", "getWeight", "", "intellij.javaFX"})
@SourceDebugExtension(value={"SMAP\nJavaFxModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaFxModuleBuilder.kt\norg/jetbrains/plugins/javaFX/wizard/JavaFxModuleBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class JavaFxModuleBuilder
extends StarterModuleBuilder {
    @NotNull
    public String getBuilderId() {
        return "javafx";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = AllIcons.FileTypes.UiForm;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"UiForm");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        return "JavaFX";
    }

    @NotNull
    public String getDescription() {
        String string = JavaFXBundle.message("javafx.module.builder.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public int getWeight() {
        return super.getWeight() + 1;
    }

    @NotNull
    protected JavaVersion getMinJavaVersion() {
        JavaVersion javaVersion = LanguageLevel.JDK_11.toJavaVersion();
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"toJavaVersion(...)");
        return javaVersion;
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        Object[] objectArray = new StarterProjectType[]{StarterSettings.getMAVEN_PROJECT(), StarterSettings.getGRADLE_PROJECT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        Object[] objectArray = new StarterLanguage[]{StarterSettings.getJAVA_STARTER_LANGUAGE(), StarterSettings.getKOTLIN_STARTER_LANGUAGE(), StarterSettings.getGROOVY_STARTER_LANGUAGE()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterTestRunner> getTestFrameworks() {
        return CollectionsKt.listOf((Object)StarterSettings.getJUNIT_TEST_RUNNER());
    }

    @NotNull
    protected StarterPack getStarterPack() {
        URL uRL = this.getDependencyConfig("/starters/javafx.pom");
        Object[] objectArray = new Library[7];
        String string = JavaFXBundle.message("library.bootstrapfx.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new Library("bootstrapfx", null, "BootstrapFX", string, "org.kordamp.bootstrapfx", "bootstrapfx-core", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, "https://github.com/kordamp/bootstrapfx", null, 4, null)), null, false, false, null, 1920, null);
        String string2 = JavaFXBundle.message("library.controlsfx.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = new Library("controlsfx", null, "ControlsFX", string2, "org.controlsfx", "controlsfx", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, "https://controlsfx.github.io/", null, 4, null)), null, false, false, null, 1920, null);
        String string3 = JavaFXBundle.message("library.formsfx.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[2] = new Library("formsfx", null, "FormsFX", string3, "com.dlsc.formsfx", "formsfx-core", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, "https://github.com/dlsc-software-consulting-gmbh/FormsFX/", null, 4, null)), null, false, false, null, 1920, null);
        String string4 = JavaFXBundle.message("library.fxgl.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[3] = new Library("fxgl", null, "FXGL", string4, "com.github.almasb", "fxgl", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, "https://github.com/AlmasB/FXGL", null, 4, null)), null, false, false, null, 1920, null);
        String string5 = JavaFXBundle.message("library.ikonli.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[4] = new Library("ikonli", null, "Ikonli", string5, "org.kordamp.ikonli", "ikonli-javafx", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.REFERENCE, "https://kordamp.org/ikonli/", null, 4, null)), null, false, false, null, 1920, null);
        String string6 = JavaFXBundle.message("library.tilesfx.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        objectArray[5] = new Library("tilesfx", null, "TilesFX", string6, "eu.hansolo", "tilesfx", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, "https://github.com/HanSolo/tilesfx", null, 4, null)), null, false, false, null, 1920, null);
        String string7 = JavaFXBundle.message("library.validatorfx.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        objectArray[6] = new Library("validatorfx", null, "ValidatorFX", string7, "net.synedra", "validatorfx", CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.WEBSITE, "https://github.com/effad/ValidatorFX", null, 4, null)), null, false, false, null, 1920, null);
        return new StarterPack("javafx", CollectionsKt.listOf((Object)new Starter("javafx", "JavaFX", uRL, CollectionsKt.listOf((Object[])objectArray))));
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        List files = new ArrayList();
        if (Intrinsics.areEqual((Object)this.getStarterContext().getProjectType(), (Object)StarterSettings.getMAVEN_PROJECT())) {
            files.add("pom.xml");
        } else if (Intrinsics.areEqual((Object)this.getStarterContext().getProjectType(), (Object)StarterSettings.getGRADLE_PROJECT())) {
            files.add("build.gradle");
        }
        String packagePath = this.getPackagePath(this.getStarterContext().getGroup(), this.getStarterContext().getArtifact());
        String samplesLanguage = this.getStarterContext().getLanguage().getId();
        String samplesExt = this.getSamplesExt(this.getStarterContext().getLanguage());
        files.add("src/main/resources/" + packagePath + "/hello-view.fxml");
        files.add("src/main/" + samplesLanguage + "/" + packagePath + "/HelloController." + samplesExt);
        files.add("src/main/" + samplesLanguage + "/" + packagePath + "/HelloApplication." + samplesExt);
        return files;
    }

    @NotNull
    protected Map<String, String> getGeneratorContextProperties(@Nullable Sdk sdk, @NotNull DependencyConfig dependencyConfig) {
        Integer sdkFeatureVersion;
        JavaSdkVersion sdkVersion;
        JavaSdkVersion javaSdkVersion;
        JavaSdkVersion javaSdkVersion2;
        Intrinsics.checkNotNullParameter((Object)dependencyConfig, (String)"dependencyConfig");
        HashMap properties = new HashMap(super.getGeneratorContextProperties(sdk, dependencyConfig));
        Sdk sdk2 = sdk;
        if (sdk2 != null) {
            Sdk it = sdk2;
            boolean bl = false;
            javaSdkVersion2 = JavaSdk.getInstance().getVersion(it);
        } else {
            javaSdkVersion2 = null;
        }
        Integer n = (javaSdkVersion = (sdkVersion = javaSdkVersion2)) != null && (javaSdkVersion = javaSdkVersion.getMaxLanguageLevel()) != null && (javaSdkVersion = javaSdkVersion.toJavaVersion()) != null ? Integer.valueOf(javaSdkVersion.feature) : (sdkFeatureVersion = null);
        if (sdkFeatureVersion == null) {
            ((Map)properties).put("javafx.version", this.getUnknownFxVersion(dependencyConfig));
        } else {
            String targetVersion = (String)dependencyConfig.getProperties().get("fx" + sdkFeatureVersion + ".version");
            Map map = properties;
            String string = targetVersion;
            if (string == null) {
                string = this.getUnknownFxVersion(dependencyConfig);
            }
            map.put("javafx.version", string);
        }
        return properties;
    }

    private final String getUnknownFxVersion(DependencyConfig dependencyConfig) {
        return (String)dependencyConfig.getProperties().get("fx.default.version");
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages;
        CustomizedMessages $this$getCustomizedMessages_u24lambda_u241 = customizedMessages = new CustomizedMessages();
        boolean bl = false;
        $this$getCustomizedMessages_u24lambda_u241.setDependenciesLabel(JavaFXBundle.message("javafx.module.additional.libraries", new Object[0]));
        return customizedMessages;
    }

    @NotNull
    protected List<GeneratorAsset> getAssets(@NotNull Starter starter) {
        Intrinsics.checkNotNullParameter((Object)starter, (String)"starter");
        FileTemplateManager ftManager = FileTemplateManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        StandardAssetsProvider standardAssetsProvider = new StandardAssetsProvider();
        List assets = new ArrayList();
        if (Intrinsics.areEqual((Object)this.getStarterContext().getProjectType(), (Object)StarterSettings.getGRADLE_PROJECT())) {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("javafx-build.gradle");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("build.gradle", fileTemplate));
            FileTemplate fileTemplate2 = ftManager.getJ2eeTemplate("javafx-settings.gradle");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("settings.gradle", fileTemplate2));
            String string = standardAssetsProvider.getGradleWrapperPropertiesLocation();
            FileTemplate fileTemplate3 = ftManager.getJ2eeTemplate("javafx-gradle-wrapper.properties");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate3, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile(string, fileTemplate3));
            assets.addAll(standardAssetsProvider.getGradlewAssets());
            if (this.getStarterContext().isCreatingNewProject()) {
                assets.addAll(standardAssetsProvider.getGradleIgnoreAssets());
            }
        } else if (Intrinsics.areEqual((Object)this.getStarterContext().getProjectType(), (Object)StarterSettings.getMAVEN_PROJECT())) {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("javafx-pom.xml");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("pom.xml", fileTemplate));
            String string = standardAssetsProvider.getMavenWrapperPropertiesLocation();
            FileTemplate fileTemplate4 = ftManager.getJ2eeTemplate("javafx-maven-wrapper.properties");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate4, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile(string, fileTemplate4));
            assets.addAll(standardAssetsProvider.getMvnwAssets());
            if (this.getStarterContext().isCreatingNewProject()) {
                assets.addAll(standardAssetsProvider.getMavenIgnoreAssets());
            }
        }
        String packagePath = this.getPackagePath(this.getStarterContext().getGroup(), this.getStarterContext().getArtifact());
        String samplesLanguage = this.getStarterContext().getLanguage().getId();
        String samplesExt = this.getSamplesExt(this.getStarterContext().getLanguage());
        if (Intrinsics.areEqual((Object)this.getStarterContext().getProjectType(), (Object)StarterSettings.getMAVEN_PROJECT())) {
            String string = "src/main/" + samplesLanguage + "/module-info.java";
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("javafx-module-info.java");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile(string, fileTemplate));
        } else {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("javafx-module-info.java");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("src/main/java/module-info.java", fileTemplate));
        }
        String string = "src/main/" + samplesLanguage + "/" + packagePath + "/HelloApplication." + samplesExt;
        FileTemplate fileTemplate = ftManager.getJ2eeTemplate("javafx-HelloApplication-" + samplesLanguage + "." + samplesExt);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        assets.add(new GeneratorTemplateFile(string, fileTemplate));
        String string2 = "src/main/" + samplesLanguage + "/" + packagePath + "/HelloController." + samplesExt;
        FileTemplate fileTemplate5 = ftManager.getJ2eeTemplate("javafx-HelloController-" + samplesLanguage + "." + samplesExt);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate5, (String)"getJ2eeTemplate(...)");
        assets.add(new GeneratorTemplateFile(string2, fileTemplate5));
        String string3 = "src/main/resources/" + packagePath + "/hello-view.fxml";
        FileTemplate fileTemplate6 = ftManager.getJ2eeTemplate("javafx-hello-view.fxml");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate6, (String)"getJ2eeTemplate(...)");
        assets.add(new GeneratorTemplateFile(string3, fileTemplate6));
        return assets;
    }
}

