/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.driver.impl;

import com.intellij.driver.impl.CallTarget;
import com.intellij.driver.impl.HardReference;
import com.intellij.driver.impl.InvokerMBean;
import com.intellij.driver.impl.RefProducer;
import com.intellij.driver.impl.Session;
import com.intellij.driver.model.LocalRefDelegate;
import com.intellij.driver.model.OnDispatcher;
import com.intellij.driver.model.ProductVersion;
import com.intellij.driver.model.RefDelegate;
import com.intellij.driver.model.RemoteRefDelegate;
import com.intellij.driver.model.transport.NewInstanceCall;
import com.intellij.driver.model.transport.Ref;
import com.intellij.driver.model.transport.RefCall;
import com.intellij.driver.model.transport.RefList;
import com.intellij.driver.model.transport.RemoteCall;
import com.intellij.driver.model.transport.RemoteCallResult;
import com.intellij.driver.model.transport.ServiceCall;
import com.intellij.driver.model.transport.UtilityCall;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.util.ExceptionUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Invoker
implements InvokerMBean {
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    public static final int NO_SESSION_ID = 0;
    static final AtomicInteger REF_SEQUENCE = new AtomicInteger(1);
    private final Map<Integer, Session> sessions;
    private final AtomicInteger sessionIdSequence;
    private final Map<String, WeakReference<Object>> adhocReferenceMap;
    private final ClearableLazyValue<IJTracer> tracer;
    private final Consumer<String> screenshotAction;
    private final String refIdPrefix;
    private final Supplier<? extends Context> timedContextSupplier;

    public Invoker(@NotNull String refIdPrefix, final @NotNull Supplier<? extends IJTracer> tracerSupplier, @NotNull Supplier<? extends Context> timedContextSupplier, @NotNull Consumer<String> screenshotAction) {
        if (refIdPrefix == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        if (tracerSupplier == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        if (timedContextSupplier == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        if (screenshotAction == null) {
            Invoker.$$$reportNull$$$0(3);
        }
        this.sessions = new ConcurrentHashMap<Integer, Session>();
        this.sessionIdSequence = new AtomicInteger(1);
        this.adhocReferenceMap = new ConcurrentHashMap<String, WeakReference<Object>>();
        this.refIdPrefix = refIdPrefix;
        this.timedContextSupplier = timedContextSupplier;
        this.tracer = new ClearableLazyValue<IJTracer>(){

            @NotNull
            protected IJTracer compute() {
                IJTracer iJTracer = (IJTracer)tracerSupplier.get();
                if (iJTracer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iJTracer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/driver/impl/Invoker$1", "compute"));
            }
        };
        this.screenshotAction = screenshotAction;
    }

    @Override
    public ProductVersion getProductVersion() {
        BuildNumber build = ApplicationInfoImpl.getShadowInstanceImpl().getBuild();
        return new ProductVersion(build.getProductCode(), build.isSnapshot(), build.getBaselineVersion(), build.asString());
    }

    @Override
    public boolean isApplicationInitialized() {
        Application application = ApplicationManager.getApplication();
        return application != null && ((ApplicationEx)application).isComponentCreated();
    }

    @Override
    public void exit() {
        ApplicationManager.getApplication().exit(true, true, false);
    }

    @Override
    @NotNull
    public RemoteCallResult invoke(@NotNull RemoteCall call) {
        ArrayList<Ref> items;
        Object result;
        if (call == null) {
            Invoker.$$$reportNull$$$0(4);
        }
        Object[] transformedArgs = this.transformArgs(call);
        if (call instanceof NewInstanceCall) {
            Class<?> targetClass = this.getTargetClass(call);
            Constructor<?> constructor = Invoker.getConstructor(call, targetClass, transformedArgs);
            LOG.debug("Creating instance of " + targetClass);
            result = this.withSemantics(call, () -> Invoker.invokeConstructor(constructor, transformedArgs));
        } else {
            Class componentType;
            Type type;
            Type[] typeArguments;
            Type returnType;
            Object instance;
            CallTarget callTarget = this.getCallTarget(call, transformedArgs);
            LOG.debug("Calling " + callTarget);
            try {
                instance = this.findInstance(call, callTarget.clazz());
            }
            catch (Exception e) {
                LOG.error("Unable to get instance for " + call);
                throw new RuntimeException("Unable to get instance for " + call, e);
            }
            if (call.getDispatcher() == OnDispatcher.EDT) {
                Object[] res = new Object[1];
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    res[0] = this.withSemantics(call, () -> Invoker.invokeMethod(callTarget, instance, transformedArgs));
                });
                result = res[0];
            } else {
                result = this.withSemantics(call, () -> Invoker.invokeMethod(callTarget, instance, transformedArgs));
            }
            Method targetMethod = callTarget.targetMethod();
            if (Collection.class.isAssignableFrom(targetMethod.getReturnType()) ? (returnType = targetMethod.getGenericReturnType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)returnType).getActualTypeArguments()).length == 1 && (type = typeArguments[0]) instanceof Class && RemoteCall.isPassByValue(componentType = (Class)type) : targetMethod.getReturnType().isArray() && RemoteCall.isPassByValue(targetMethod.getReturnType().getComponentType())) {
                return new RemoteCallResult(result);
            }
        }
        if (RemoteCall.isPassByValue(result)) {
            return new RemoteCallResult(result);
        }
        if (call.getSessionId() == 0) {
            Ref ref = this.putAdhocReference(result);
            if (result instanceof Collection) {
                ArrayList<Ref> items2 = new ArrayList<Ref>(((Collection)result).size());
                for (Object item : (Collection)result) {
                    items2.add(this.putAdhocReference(item));
                }
                return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items2));
            }
            if (result.getClass().isArray()) {
                Object[] array = (Object[])result;
                items = new ArrayList<Ref>(array.length);
                for (Object item : array) {
                    items.add(this.putAdhocReference(item));
                }
                return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items));
            }
            return new RemoteCallResult(ref);
        }
        Session session = this.sessions.get(call.getSessionId());
        Ref ref = this.putAdhocReferenceToSession(result, session);
        if (result instanceof Collection) {
            items = new ArrayList(((Collection)result).size());
            for (Object item : (Collection)result) {
                Ref child = this.putAdhocReferenceToSession(item, session);
                items.add(child);
            }
            return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items));
        }
        if (result.getClass().isArray()) {
            int length = Array.getLength(result);
            ArrayList<Ref> items3 = new ArrayList<Ref>(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(result, i);
                Ref child = this.putAdhocReferenceToSession(item, session);
                items3.add(child);
            }
            return new RemoteCallResult(new RefList(ref.id(), result.getClass().getName(), items3));
        }
        return new RemoteCallResult(ref);
    }

    @NotNull
    private static Object invokeConstructor(Constructor<?> constructor, Object[] transformedArgs) throws Exception {
        Object obj;
        try {
            obj = constructor.newInstance(transformedArgs);
        }
        catch (IllegalArgumentException ie) {
            String message = "Argument type mismatch for constructor " + constructor + " , actual types are [" + Invoker.getExpectedTypesMessage(transformedArgs) + "]";
            LOG.warn(message, (Throwable)ie);
            throw new IllegalArgumentException(message, ie);
        }
        catch (Throwable e) {
            LOG.warn("Error during remote driver call " + constructor, e);
            throw e;
        }
        if (obj == null) {
            Invoker.$$$reportNull$$$0(5);
        }
        return obj;
    }

    @NotNull
    private static String getExpectedTypesMessage(Object[] transformedArgs) {
        String string = Arrays.stream(transformedArgs).map(a -> {
            if (a == null) {
                return "null";
            }
            return a.getClass().getSimpleName();
        }).collect(Collectors.joining(", "));
        if (string == null) {
            Invoker.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static Object invokeMethod(CallTarget callTarget, Object instance, Object[] args) throws Exception {
        try {
            return callTarget.targetMethod().invoke(instance, args);
        }
        catch (IllegalArgumentException ie) {
            String message = "Argument type mismatch for call " + callTarget.targetMethod() + ", actual types are [" + Invoker.getExpectedTypesMessage(args) + "]";
            LOG.warn(message, (Throwable)ie);
            throw new IllegalArgumentException(message, ie);
        }
        catch (Throwable e) {
            LOG.warn("Error during remote driver call " + callTarget.targetMethod(), e);
            throw e;
        }
    }

    @Nullable
    private Object withSemantics(@NotNull RemoteCall call, @NotNull Callable<?> supplier) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(7);
        }
        if (supplier == null) {
            Invoker.$$$reportNull$$$0(8);
        }
        switch (call.getLockSemantics()) {
            case NO_LOCK: {
                return this.call(call, supplier);
            }
            case READ_ACTION: {
                return ReadAction.compute(() -> this.call(call, supplier));
            }
            case WRITE_ACTION: {
                return WriteAction.compute(() -> this.call(call, supplier));
            }
        }
        throw new UnsupportedOperationException("Unsupported LockSemantics " + call.getLockSemantics());
    }

    @Nullable
    private Object call(@NotNull RemoteCall call, @NotNull Callable<?> supplier) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(9);
        }
        if (supplier == null) {
            Invoker.$$$reportNull$$$0(10);
        }
        if (call.getTimedSpan() == null || call.getTimedSpan().isEmpty()) {
            try {
                return supplier.call();
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e);
                throw new IllegalStateException();
            }
        }
        SpanBuilder spanBuilder = ((IJTracer)this.tracer.getValue()).spanBuilder(call.getTimedSpan()).setParent(this.timedContextSupplier.get());
        Span span = spanBuilder.startSpan();
        try {
            Object obj = supplier.call();
            return obj;
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
        finally {
            span.end();
        }
    }

    @Override
    @NotNull
    public Ref putAdhocReference(@NotNull Object item) {
        RefDelegate delegate;
        if (item == null) {
            Invoker.$$$reportNull$$$0(11);
        }
        if (item instanceof LocalRefDelegate) {
            delegate = (LocalRefDelegate)item;
            item = ((LocalRefDelegate)delegate).getLocalValue();
        }
        if (item instanceof RemoteRefDelegate) {
            delegate = (RemoteRefDelegate)item;
            Ref ref = ((RemoteRefDelegate)delegate).getRemoteRef();
            if (ref == null) {
                Invoker.$$$reportNull$$$0(12);
            }
            return ref;
        }
        String itemId = this.refIdPrefix + REF_SEQUENCE.getAndIncrement();
        this.adhocReferenceMap.put(itemId, new WeakReference<Object>(item));
        Ref ref = RefProducer.makeRef(itemId, item);
        if (ref == null) {
            Invoker.$$$reportNull$$$0(13);
        }
        return ref;
    }

    @NotNull
    private Ref putAdhocReferenceToSession(@NotNull Object item, @NotNull Session session) {
        RefDelegate delegate;
        if (item == null) {
            Invoker.$$$reportNull$$$0(14);
        }
        if (session == null) {
            Invoker.$$$reportNull$$$0(15);
        }
        if (item instanceof LocalRefDelegate) {
            delegate = (LocalRefDelegate)item;
            item = ((LocalRefDelegate)delegate).getLocalValue();
        }
        if (item instanceof RemoteRefDelegate) {
            delegate = (RemoteRefDelegate)item;
            Ref ref = ((RemoteRefDelegate)delegate).getRemoteRef();
            if (ref == null) {
                Invoker.$$$reportNull$$$0(16);
            }
            return ref;
        }
        Ref ref = session.putReference(item);
        this.adhocReferenceMap.put(ref.id(), new WeakReference<Object>(item));
        Ref ref2 = ref;
        if (ref2 == null) {
            Invoker.$$$reportNull$$$0(17);
        }
        return ref2;
    }

    private static Constructor<?> getConstructor(@NotNull RemoteCall call, @NotNull Class<?> targetClass, Object[] transformedArgs) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(18);
        }
        if (targetClass == null) {
            Invoker.$$$reportNull$$$0(19);
        }
        int argCount = call.getArgs().length;
        List<Constructor<?>> availableConstructors = Arrays.stream(targetClass.getConstructors()).toList();
        List<Constructor> constructors = availableConstructors.stream().filter(x -> x.getParameterCount() == argCount).toList();
        if (constructors.isEmpty()) {
            throw new IllegalStateException(String.format("No constructor with parameter count %s in class %s. Available constructors: %n%s", argCount, call.getClassName(), availableConstructors.stream().map(it -> it.toString()).collect(Collectors.joining(" - " + System.lineSeparator()))));
        }
        if (constructors.size() > 1) {
            List<@Nullable Class<?>> argumentTypes = Invoker.getArgumentTypes(transformedArgs);
            for (Constructor constructor : constructors) {
                if (!Invoker.areTypesCompatible(constructor.getParameterTypes(), argumentTypes)) continue;
                return constructor;
            }
        }
        return constructors.get(0);
    }

    @NotNull
    private CallTarget getCallTarget(@NotNull RemoteCall call, Object[] transformedArgs) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(20);
        }
        Class<?> clazz = this.getTargetClass(call);
        int argCount = call.getArgs().length;
        List<Method> availableMethods = Arrays.stream(clazz.getMethods()).toList();
        List<Method> targetMethods = availableMethods.stream().filter(m -> m.getName().equals(call.getMethodName()) && argCount == m.getParameterCount()).toList();
        if (targetMethods.isEmpty()) {
            throw new IllegalStateException(String.format("No method '%s' with parameter count %s in class %s. Available methods: %n%s", call.getMethodName(), argCount, call.getClassName(), availableMethods.stream().map(it -> it.toString()).collect(Collectors.joining(" - " + System.lineSeparator()))));
        }
        if (targetMethods.size() > 1) {
            List<@Nullable Class<?>> argumentTypes = Invoker.getArgumentTypes(transformedArgs);
            for (Method method : targetMethods) {
                if (!Invoker.areTypesCompatible(method.getParameterTypes(), argumentTypes)) continue;
                return Invoker.buildCallTarget(clazz, method);
            }
        }
        return Invoker.buildCallTarget(clazz, targetMethods.get(0));
    }

    @NotNull
    private static CallTarget buildCallTarget(Class<?> clazz, Method method) {
        method.setAccessible(true);
        return new CallTarget(clazz, method);
    }

    private static @NotNull List<@Nullable Class<?>> getArgumentTypes(Object[] transformedArgs) {
        List<Class<?>> list = Arrays.stream(transformedArgs).map(a -> {
            if (a == null) {
                return null;
            }
            return a.getClass();
        }).toList();
        if (list == null) {
            Invoker.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static boolean areTypesCompatible(Class<?> @NotNull [] parameterTypes, @NotNull List<@Nullable Class<?>> argumentTypes) {
        if (argumentTypes == null) {
            Invoker.$$$reportNull$$$0(22);
        }
        if (parameterTypes == null) {
            Invoker.$$$reportNull$$$0(23);
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            Class<?> parameterType;
            Class<?> argType = argumentTypes.get(i);
            if (argType == null || ClassUtils.isAssignable(argType, parameterType = parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Class<?> getTargetClass(RemoteCall call) {
        Class<?> clazz;
        try {
            clazz = this.getClassLoader(call).loadClass(call.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No such class '" + call.getClassName() + "'", e);
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            Invoker.$$$reportNull$$$0(24);
        }
        return clazz2;
    }

    @NotNull
    private ClassLoader getClassLoader(RemoteCall call) {
        String pluginId = call.getPluginId();
        if (pluginId == null || pluginId.isEmpty()) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                Invoker.$$$reportNull$$$0(25);
            }
            return classLoader;
        }
        if (pluginId.contains("/")) {
            String mainId = StringsKt.substringBefore((String)pluginId, (String)"/", (String)pluginId);
            String moduleId = StringsKt.substringAfter((String)pluginId, (String)"/", (String)pluginId);
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)mainId));
            if (plugin == null) {
                throw new IllegalStateException("No such plugin " + mainId);
            }
            List modules = ((IdeaPluginDescriptorImpl)plugin).content.modules;
            for (PluginContentDescriptor.ModuleItem module : modules) {
                if (!Objects.equals(moduleId, module.name)) continue;
                ClassLoader classLoader = Objects.requireNonNull(module.requireDescriptor().getPluginClassLoader());
                if (classLoader == null) {
                    Invoker.$$$reportNull$$$0(26);
                }
                return classLoader;
            }
            throw new IllegalStateException("No such plugin module " + pluginId);
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
        if (plugin == null) {
            throw new IllegalStateException("No such plugin " + pluginId);
        }
        ClassLoader classLoader = plugin.getClassLoader();
        if (classLoader == null) {
            Invoker.$$$reportNull$$$0(27);
        }
        return classLoader;
    }

    @Nullable
    private Object findInstance(RemoteCall call, Class<?> clazz) {
        if (call instanceof ServiceCall) {
            Object projectInstance = null;
            Ref projectRef = ((ServiceCall)call).getProjectRef();
            if (projectRef != null) {
                projectInstance = this.getReference(call.getSessionId(), projectRef.id());
            }
            Class<?> serviceClass = clazz;
            String serviceInterface = ((ServiceCall)call).getServiceInterface();
            if (serviceInterface != null && (serviceClass = Invoker.findServiceInterface(clazz, serviceInterface)) == null) {
                throw new IllegalStateException("Unable to find interface " + serviceInterface + " for service " + clazz);
            }
            Object instance = projectInstance instanceof Project ? ((Project)projectInstance).getService(serviceClass) : ApplicationManager.getApplication().getService(serviceClass);
            return instance;
        }
        if (call instanceof RefCall) {
            Ref ref = ((RefCall)call).getRef();
            Object reference = this.getReference(call.getSessionId(), ref.id());
            if (reference == null) {
                throw new IllegalStateException("No such ref exists " + ref);
            }
            return reference;
        }
        if (call instanceof UtilityCall) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported call type " + call);
    }

    @Nullable
    private static Class<?> findServiceInterface(@NotNull Class<?> clazz, @NotNull String serviceInterface) {
        if (clazz == null) {
            Invoker.$$$reportNull$$$0(28);
        }
        if (serviceInterface == null) {
            Invoker.$$$reportNull$$$0(29);
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (!serviceInterface.equals(anInterface.getName())) continue;
            return anInterface;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            if (serviceInterface.equals(superclass.getName())) {
                return superclass;
            }
            return Invoker.findServiceInterface(superclass, serviceInterface);
        }
        return null;
    }

    private Object @NotNull [] transformArgs(@NotNull RemoteCall call) {
        if (call == null) {
            Invoker.$$$reportNull$$$0(30);
        }
        Object[] args = new Object[call.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            Object reference;
            Object arg = call.getArgs()[i];
            args[i] = arg instanceof Ref ? (reference = this.getReference(call.getSessionId(), ((Ref)arg).id())) : arg;
        }
        if (args == null) {
            Invoker.$$$reportNull$$$0(31);
        }
        return args;
    }

    @NotNull
    private Object getReference(int sessionId, String id) {
        if (sessionId != 0) {
            WeakReference<Object> adhocReference = this.adhocReferenceMap.get(id);
            if (adhocReference != null) {
                return Invoker.dereference(adhocReference, id);
            }
            Session session = this.sessions.get(sessionId);
            if (session == null) {
                throw new IllegalStateException("No such session " + sessionId);
            }
            HardReference reference = session.findReference(id);
            if (reference != null) {
                Object object = reference.value;
                if (object == null) {
                    Invoker.$$$reportNull$$$0(32);
                }
                return object;
            }
            throw new IllegalStateException("No such reference with id " + id + ". It may happen if a weak reference to the variable expires. Please use `Driver.withContext { }` for hard variable references.");
        }
        WeakReference<Object> reference = this.adhocReferenceMap.get(id);
        if (reference == null) {
            throw new IllegalStateException("No such variable " + id);
        }
        return Invoker.dereference(reference, id);
    }

    @NotNull
    private static Object dereference(@NotNull WeakReference<Object> reference, String id) {
        Object weakTarget;
        if (reference == null) {
            Invoker.$$$reportNull$$$0(33);
        }
        if ((weakTarget = reference.get()) == null) {
            throw new IllegalStateException("Weak reference to variable " + id + " expired. Please use `Driver.withContext { }` for hard variable references.");
        }
        Object t = weakTarget;
        if (t == null) {
            Invoker.$$$reportNull$$$0(34);
        }
        return t;
    }

    @Override
    public int newSession() {
        int id = this.sessionIdSequence.getAndIncrement();
        this.sessions.put(id, new Session(this.refIdPrefix));
        return id;
    }

    @Override
    public int newSession(int id) {
        this.sessions.put(id, new Session(this.refIdPrefix));
        return id;
    }

    @Override
    public void cleanup(int sessionId) {
        this.sessions.remove(sessionId);
        List<String> expiredKeys = this.adhocReferenceMap.entrySet().stream().filter(entry -> ((WeakReference)entry.getValue()).get() == null).map(Map.Entry::getKey).toList();
        for (String key : expiredKeys) {
            this.adhocReferenceMap.remove(key);
        }
    }

    @Override
    public void takeScreenshot(@Nullable String outFolder) {
        this.screenshotAction.accept(outFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 12, 13, 16, 17, 21, 24, 25, 26, 27, 31, 32, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refIdPrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracerSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timedContextSupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenshotAction";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 18: 
            case 20: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/driver/impl/Invoker";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/driver/impl/Invoker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeConstructor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "putAdhocReference";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "putAdhocReferenceToSession";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClass";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "transformArgs";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "dereference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withSemantics";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "call";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putAdhocReference";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putAdhocReferenceToSession";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCallTarget";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "areTypesCompatible";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findServiceInterface";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "transformArgs";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 12, 13, 16, 17, 21, 24, 25, 26, 27, 31, 32, 34 -> new IllegalStateException(string);
        };
    }
}

