/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.google.gson.Gson;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.SpanBuilderWithSystemInfoAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import org.jetbrains.annotations.NotNull;

public abstract class PerformanceCommand
extends AbstractCommand {
    private static final String PREFIX = "%";
    private static final Gson gson = new Gson();
    private final Tracer tracer;

    public PerformanceCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            PerformanceCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
        this.tracer = this.isWarmupMode() != false ? PerformanceTestSpan.WARMUP_TRACER : PerformanceTestSpan.TRACER;
    }

    public PerformanceCommand(@NotNull String text2, int line, boolean executeInAwt) {
        if (text2 == null) {
            PerformanceCommand.$$$reportNull$$$0(1);
        }
        super(text2, line, executeInAwt);
        this.tracer = this.isWarmupMode() != false ? PerformanceTestSpan.WARMUP_TRACER : PerformanceTestSpan.TRACER;
    }

    protected abstract String getName();

    protected String getPrefix() {
        return PREFIX + this.getName();
    }

    protected Boolean isWarmupMode() {
        return this.extractCommandArgument(this.getPrefix()).contains("WARMUP");
    }

    protected Boolean systemMetricsEnabled() {
        return this.extractCommandArgument(this.getPrefix()).contains("ENABLE_SYSTEM_METRICS");
    }

    private SpanBuilder wrapIfNeed(SpanBuilder spanBuilder) {
        if (this.systemMetricsEnabled().booleanValue()) {
            return new SpanBuilderWithSystemInfoAttributes(spanBuilder);
        }
        return spanBuilder;
    }

    protected Span startSpan(String name) {
        SpanBuilder spanBuilder = this.wrapIfNeed(this.tracer.spanBuilder(name));
        return spanBuilder.startSpan();
    }

    protected <T> T deserializeOptionsFromJson(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/PerformanceCommand", "<init>"));
    }
}

