/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.apps;

import com.amazon.ion.IonCatalog;
import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ion.system.SimpleCatalog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

abstract class BaseApp {
    protected SimpleCatalog myCatalog = new SimpleCatalog();
    protected IonSystem mySystem = IonSystemBuilder.standard().withCatalog(this.myCatalog).build();

    BaseApp() {
    }

    protected static byte[] loadAsByteArray(InputStream in) throws IOException {
        int cnt;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((cnt = in.read(buf)) != -1) {
            bos.write(buf, 0, cnt);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadAsByteArray(File file2) throws FileNotFoundException, IOException {
        long len = file2.length();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + file2);
        }
        byte[] buffer = new byte[(int)len];
        try (FileInputStream in = new FileInputStream(file2);){
            int readBytesCount = in.read(buffer);
            if ((long)readBytesCount != len || in.read() != -1) {
                System.err.println("Read the wrong number of bytes from " + file2);
                byte[] byArray = null;
                return byArray;
            }
        }
        return buffer;
    }

    public void doMain(String[] args2) {
        int firstFileIndex = this.processOptions(args2);
        int fileCount = args2.length - firstFileIndex;
        String[] files2 = new String[fileCount];
        System.arraycopy(args2, firstFileIndex, files2, 0, fileCount);
        if (this.optionsAreValid(files2)) {
            this.processFiles(files2);
        }
    }

    protected int processOptions(String[] args2) {
        return 0;
    }

    protected boolean optionsAreValid(String[] filePaths) {
        return true;
    }

    protected void processFiles(String[] filePaths) {
        if (filePaths.length == 0) {
            this.processStdIn();
        } else {
            for (int i2 = 0; i2 < filePaths.length; ++i2) {
                String filePath = filePaths[i2];
                this.processFile(filePath);
            }
        }
    }

    protected boolean processFile(String path) {
        File file2 = new File(path);
        if (file2.canRead() && file2.isFile()) {
            try {
                this.process(file2);
                return true;
            }
            catch (IonException e2) {
                System.err.println("An error occurred while processing " + path);
                System.err.println(e2.getMessage());
            }
            catch (IOException e3) {
                System.err.println("An error occurred while processing " + path);
                System.err.println(e3.getMessage());
            }
        } else {
            System.err.println("Skipping unreadable file: " + path);
        }
        return false;
    }

    protected void processStdIn() {
        try {
            byte[] buffer = BaseApp.loadAsByteArray(System.in);
            IonReader reader = this.mySystem.newReader(buffer);
            this.process(reader);
        }
        catch (IonException e2) {
            System.err.println("An error occurred while processing stdin");
            System.err.println(e2.getMessage());
        }
        catch (IOException e3) {
            System.err.println("An error occurred while processing stdin");
            System.err.println(e3.getMessage());
        }
    }

    protected void process(File file2) throws IOException, IonException {
        byte[] buffer = BaseApp.loadAsByteArray(file2);
        IonReader reader = this.mySystem.newReader(buffer);
        this.process(file2, reader);
    }

    protected void process(File inputFile, IonReader reader) throws IOException, IonException {
        this.process(reader);
    }

    protected void process(IonReader reader) throws IOException, IonException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCatalog(String catalogPath) {
        System.err.println("Loading catalog from " + catalogPath);
        File catalogFile = new File(catalogPath);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(catalogFile));){
            IonReader reader = this.mySystem.newReader(in);
            while (reader.next() != null) {
                SymbolTable symtab = this.mySystem.newSharedSymbolTable(reader, true);
                this.myCatalog.putTable(symtab);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Error loading catalog from " + catalogPath + ": " + e2.getMessage(), e2);
        }
        IonCatalog catalog = this.mySystem.getCatalog();
        assert (this.myCatalog == catalog);
    }

    protected SymbolTable getLatestSharedSymtab(String name) {
        IonCatalog catalog = this.mySystem.getCatalog();
        SymbolTable table = catalog.getTable(name);
        if (table == null) {
            String message = "There's no symbol table in the catalog named " + name;
            throw new RuntimeException(message);
        }
        this.logDebug("Found shared symbol table " + name + "@" + table.getVersion());
        return table;
    }

    protected void logDebug(String message) {
        System.err.println(message);
    }
}

