/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0002H\u0007\u001a\u001b\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u0019\u0010\f\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u0019\u0010\r\u001a\u00020\u0002*\u00020\u00022\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a:\u0010\u0012\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062#\u0010\u0013\u001a\u001f\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00020\u0014\u00a2\u0006\u0002\b\u0015H\u0082\b\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0006*\u00020\u0002\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u0002*\u00020\u001a\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0002*\u00020\u001a\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0002*\u00020\u001a\u001a \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u001e*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010 \u001a\u00020\u0006\u001a\f\u0010!\u001a\u0004\u0018\u00010\u001a*\u00020\u0002\u001a\f\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\u0014\u0010#\u001a\u00020$*\u00020\u00022\u0006\u0010%\u001a\u00020\u0017H\u0007\u001a\u0014\u0010&\u001a\u00020$*\u00020\u00022\u0006\u0010%\u001a\u00020\u0006H\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006'"}, d2={"isFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "findDirectory", "relativePath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "findDocument", "Lcom/intellij/openapi/editor/Document;", "findFile", "findFileOrDirectory", "findOrCreateDirectory", "findOrCreateFile", "findPsiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getResolvedVirtualFile", "getChild", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "readBytes", "", "readText", "refreshAndFindVirtualDirectory", "Ljava/nio/file/Path;", "refreshAndFindVirtualFile", "refreshAndFindVirtualFileOrDirectory", "relativizeToClosestAncestor", "Lkotlin/Pair;", "resolveFromRootOrRelative", "absoluteOrRelativeFilePath", "toNioPathOrNull", "validOrNull", "writeBytes", "", "content", "writeText", "intellij.platform.core"})
@JvmName(name="VirtualFileUtil")
@SourceDebugExtension(value={"SMAP\nVirtualFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n80#1,4:204\n84#1,12:212\n80#1,4:224\n84#1,12:232\n80#1,4:244\n84#1,12:252\n1#2:199\n1549#3:200\n1620#3,3:201\n1549#3:208\n1620#3,3:209\n1549#3:228\n1620#3,3:229\n1549#3:248\n1620#3,3:249\n*S KotlinDebug\n*F\n+ 1 VirtualFileUtil.kt\ncom/intellij/openapi/vfs/VirtualFileUtil\n*L\n100#1:204,4\n100#1:212,12\n133#1:224,4\n133#1:232,12\n151#1:244,4\n151#1:252,12\n83#1:200\n83#1:201,3\n100#1:208\n100#1:209,3\n133#1:228\n133#1:229,3\n151#1:248\n151#1:249,3\n*E\n"})
public final class VirtualFileUtil {
    @Nullable
    public static final VirtualFile validOrNull(@NotNull VirtualFile $this$validOrNull) {
        Intrinsics.checkNotNullParameter($this$validOrNull, "<this>");
        return $this$validOrNull.isValid() ? $this$validOrNull : null;
    }

    public static final boolean isFile(@NotNull VirtualFile $this$isFile) {
        Intrinsics.checkNotNullParameter($this$isFile, "<this>");
        return $this$isFile.isValid() && !$this$isFile.isDirectory();
    }

    @NotNull
    public static final String readText(@NotNull VirtualFile $this$readText) {
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        String string2 = VfsUtilCore.loadText($this$readText);
        Intrinsics.checkNotNullExpressionValue(string2, "loadText(...)");
        return string2;
    }

    @RequiresWriteLock
    public static final void writeText(@NotNull VirtualFile $this$writeText, @NotNull String content) {
        Intrinsics.checkNotNullParameter($this$writeText, "<this>");
        Intrinsics.checkNotNullParameter(content, "content");
        VfsUtilCore.saveText($this$writeText, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(@NotNull VirtualFile $this$readBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        Closeable closeable = $this$readBytes.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            byArray = ByteStreamsKt.readBytes(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return byArray;
    }

    @RequiresWriteLock
    public static final void writeBytes(@NotNull VirtualFile $this$writeBytes, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter($this$writeBytes, "<this>");
        Intrinsics.checkNotNullParameter(content, "content");
        $this$writeBytes.setBinaryContent(content);
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull VirtualFile $this$toNioPathOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter($this$toNioPathOrNull, "<this>");
        Object object2 = $this$toNioPathOrNull;
        try {
            VirtualFile $this$toNioPathOrNull_u24lambda_u241 = object2;
            boolean bl2 = false;
            object = Result.constructor-impl($this$toNioPathOrNull_u24lambda_u241.toNioPath());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        return (Path)(Result.isFailure-impl(object2) ? null : object2);
    }

    @RequiresReadLock
    @Nullable
    public static final Document findDocument(@NotNull VirtualFile $this$findDocument) {
        Intrinsics.checkNotNullParameter($this$findDocument, "<this>");
        return FileDocumentManager.getInstance().getDocument($this$findDocument);
    }

    @RequiresReadLock
    @Nullable
    public static final PsiFile findPsiFile(@NotNull VirtualFile $this$findPsiFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$findPsiFile, "<this>");
        Intrinsics.checkNotNullParameter(project, "project");
        return PsiManager.getInstance(project).findFile($this$findPsiFile);
    }

    private static final Pair<VirtualFile, Path> relativizeToClosestAncestor(VirtualFile $this$relativizeToClosestAncestor, String relativePath) {
        Path basePath = Path.of($this$relativizeToClosestAncestor.getPath(), new String[0]);
        Intrinsics.checkNotNull(basePath);
        Pair<Path, Path> pair = NioPathUtil.relativizeToClosestAncestor(basePath, relativePath);
        Path normalizedBasePath = pair.component1();
        Path normalizedRelativePath = pair.component2();
        Ref.ObjectRef baseVirtualFile = new Ref.ObjectRef();
        baseVirtualFile.element = $this$relativizeToClosestAncestor;
        int n2 = basePath.getNameCount() - normalizedBasePath.getNameCount();
        int n3 = 0;
        while (n3 < n2) {
            int it = n3++;
            boolean bl2 = false;
            if (((VirtualFile)baseVirtualFile.element).getParent() == null) {
                Object cfr_ignored_0 = baseVirtualFile.element;
                Ref.ObjectRef objectRef = baseVirtualFile;
                boolean bl3 = false;
                Ref.ObjectRef objectRef2 = objectRef;
                String string2 = StringsKt.trimMargin$default("\n        |Cannot resolve base virtual file for " + baseVirtualFile.element + "\n        |  basePath = " + $this$relativizeToClosestAncestor.getPath() + "\n        |  relativePath = " + relativePath + "\n      ", null, 1, null);
                throw new IllegalStateException(string2.toString());
            }
            baseVirtualFile.element = baseVirtualFile.element;
        }
        return TuplesKt.to(baseVirtualFile.element, normalizedRelativePath);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getResolvedVirtualFile(VirtualFile $this$getResolvedVirtualFile, String relativePath, Function3<? super VirtualFile, ? super String, ? super Boolean, ? extends VirtualFile> getChild) {
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile, relativePath);
        VirtualFile baseVirtualFile = pair.component1();
        Path normalizedRelativePath = pair.component2();
        VirtualFile virtualFile = baseVirtualFile;
        if (((CharSequence)((Object)normalizedRelativePath).toString()).length() > 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = normalizedRelativePath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                collection.add(it.toString());
            }
            List names = (List)destination$iv$iv;
            Iterator iterator2 = names.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int i2 = n2++;
                String name = (String)iterator2.next();
                if (!virtualFile.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile + "\n          |  basePath = " + $this$getResolvedVirtualFile.getPath() + "\n          |  relativePath = " + relativePath + "\n        ", null, 1, null));
                }
                virtualFile = getChild.invoke(virtualFile, name, (Boolean)(i2 == CollectionsKt.getLastIndex(names) ? 1 : 0));
            }
        }
        return virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFileOrDirectory(@NotNull VirtualFile $this$findFileOrDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findFileOrDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findFileOrDirectory;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = pair.component1();
        Path normalizedRelativePath$iv = pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = names$iv.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                void name;
                VirtualFile virtualFile;
                int i$iv = n2++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        ", null, 1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex(names$iv)) {
                    // empty if block
                }
                String string2 = name$iv;
                VirtualFile $this$findFileOrDirectory_u24lambda_u245 = virtualFile$iv;
                boolean bl3 = false;
                VirtualFile virtualFile2 = virtualFile = $this$findFileOrDirectory_u24lambda_u245.findChild((String)name);
                if (virtualFile2 == null) {
                    return null;
                }
                Intrinsics.checkNotNull(virtualFile2);
                virtualFile$iv = virtualFile;
            }
        }
        return virtualFile$iv;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findFile(@NotNull VirtualFile $this$findFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findFile, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory($this$findFile, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected file instead of directory: " + file2 + "\n      |  basePath = " + $this$findFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return file2;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findDirectory(@NotNull VirtualFile $this$findDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile virtualFile = VirtualFileUtil.findFileOrDirectory($this$findDirectory, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        if (!directory.isDirectory()) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected directory instead of file: " + directory + "\n      |  basePath = " + $this$findDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return directory;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateFile(@NotNull VirtualFile $this$findOrCreateFile, @NotNull String relativePath) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter($this$findOrCreateFile, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findOrCreateFile;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = pair.component1();
        Path normalizedRelativePath$iv = pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = names$iv.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                VirtualFile virtualFile;
                void name;
                VirtualFile virtualFile2;
                int i$iv = n2++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        ", null, 1, null));
                }
                boolean bl3 = i$iv == CollectionsKt.getLastIndex(names$iv);
                String string2 = name$iv;
                VirtualFile $this$findOrCreateFile_u24lambda_u246 = virtualFile$iv;
                boolean bl4 = false;
                VirtualFile virtualFile3 = virtualFile2 = $this$findOrCreateFile_u24lambda_u246.findChild((String)name);
                if (virtualFile3 == null) {
                    void isLast;
                    VirtualFile virtualFile4 = isLast == true ? $this$findOrCreateFile_u24lambda_u246.createChildData($this$findOrCreateFile_u24lambda_u246.getFileSystem(), (String)name) : $this$findOrCreateFile_u24lambda_u246.createChildDirectory($this$findOrCreateFile_u24lambda_u246.getFileSystem(), (String)name);
                    Intrinsics.checkNotNull(virtualFile4);
                    virtualFile = virtualFile4;
                } else {
                    Intrinsics.checkNotNull(virtualFile3);
                    virtualFile = virtualFile2;
                }
                virtualFile$iv = virtualFile;
            }
        }
        if (!VirtualFileUtil.isFile(file2 = virtualFile$iv)) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected file instead of directory: " + file2 + "\n      |  basePath = " + $this$findOrCreateFile.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile findOrCreateDirectory(@NotNull VirtualFile $this$findOrCreateDirectory, @NotNull String relativePath) {
        VirtualFile directory;
        Intrinsics.checkNotNullParameter($this$findOrCreateDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFile $this$getResolvedVirtualFile$iv = $this$findOrCreateDirectory;
        boolean $i$f$getResolvedVirtualFile = false;
        Pair<VirtualFile, Path> pair = VirtualFileUtil.relativizeToClosestAncestor($this$getResolvedVirtualFile$iv, relativePath);
        VirtualFile baseVirtualFile$iv = pair.component1();
        Path normalizedRelativePath$iv = pair.component2();
        VirtualFile virtualFile$iv = baseVirtualFile$iv;
        if (((CharSequence)((Object)normalizedRelativePath$iv).toString()).length() > 0) {
            void $this$mapTo$iv$iv$iv;
            Iterable $this$map$iv$iv = normalizedRelativePath$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Path path = (Path)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it$iv);
                collection.add(it$iv.toString());
            }
            List names$iv = (List)destination$iv$iv$iv;
            Iterator iterator2 = names$iv.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                VirtualFile virtualFile;
                void name;
                VirtualFile virtualFile2;
                int i$iv = n2++;
                String name$iv = (String)iterator2.next();
                if (!virtualFile$iv.isDirectory()) {
                    throw new IOException(StringsKt.trimMargin$default("\n          |Expected directory instead of file: " + virtualFile$iv + "\n          |  basePath = " + $this$getResolvedVirtualFile$iv.getPath() + "\n          |  relativePath = " + relativePath + "\n        ", null, 1, null));
                }
                if (i$iv == CollectionsKt.getLastIndex(names$iv)) {
                    // empty if block
                }
                String string2 = name$iv;
                VirtualFile $this$findOrCreateDirectory_u24lambda_u247 = virtualFile$iv;
                boolean bl3 = false;
                VirtualFile virtualFile3 = virtualFile2 = $this$findOrCreateDirectory_u24lambda_u247.findChild((String)name);
                if (virtualFile3 == null) {
                    VirtualFile virtualFile4 = $this$findOrCreateDirectory_u24lambda_u247.createChildDirectory($this$findOrCreateDirectory_u24lambda_u247.getFileSystem(), (String)name);
                    virtualFile = virtualFile4;
                    Intrinsics.checkNotNullExpressionValue(virtualFile4, "createChildDirectory(...)");
                } else {
                    Intrinsics.checkNotNull(virtualFile3);
                    virtualFile = virtualFile2;
                }
                virtualFile$iv = virtualFile;
            }
        }
        if (!(directory = virtualFile$iv).isDirectory()) {
            throw new IOException(StringsKt.trimMargin$default("\n      |Expected directory instead of file: " + directory + "\n      |  basePath = " + $this$findOrCreateDirectory.getPath() + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null));
        }
        return directory;
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualFileOrDirectory(@NotNull Path $this$refreshAndFindVirtualFileOrDirectory) {
        Intrinsics.checkNotNullParameter($this$refreshAndFindVirtualFileOrDirectory, "<this>");
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue(virtualFileManager, "getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        return fileManager.refreshAndFindFileByNioPath($this$refreshAndFindVirtualFileOrDirectory);
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualFile(@NotNull Path $this$refreshAndFindVirtualFile) {
        Intrinsics.checkNotNullParameter($this$refreshAndFindVirtualFile, "<this>");
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory($this$refreshAndFindVirtualFile);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!VirtualFileUtil.isFile(file2)) {
            throw new IOException("Expected file instead of directory: " + $this$refreshAndFindVirtualFile);
        }
        return file2;
    }

    @Nullable
    public static final VirtualFile refreshAndFindVirtualDirectory(@NotNull Path $this$refreshAndFindVirtualDirectory) {
        Intrinsics.checkNotNullParameter($this$refreshAndFindVirtualDirectory, "<this>");
        VirtualFile virtualFile = VirtualFileUtil.refreshAndFindVirtualFileOrDirectory($this$refreshAndFindVirtualDirectory);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        if (!file2.isDirectory()) {
            throw new IOException("Expected directory instead of file: " + $this$refreshAndFindVirtualDirectory);
        }
        return file2;
    }

    @Nullable
    public static final VirtualFile resolveFromRootOrRelative(@NotNull VirtualFile $this$resolveFromRootOrRelative, @NotNull String absoluteOrRelativeFilePath) {
        Intrinsics.checkNotNullParameter($this$resolveFromRootOrRelative, "<this>");
        Intrinsics.checkNotNullParameter(absoluteOrRelativeFilePath, "absoluteOrRelativeFilePath");
        VirtualFile virtualFile = $this$resolveFromRootOrRelative.getFileSystem().findFileByPath(absoluteOrRelativeFilePath);
        if (virtualFile == null) {
            virtualFile = $this$resolveFromRootOrRelative.findFileByRelativePath(absoluteOrRelativeFilePath);
        }
        return virtualFile;
    }
}

