/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.DynamicBundle;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/util/LocalizationUtil;", "", "()V", "Companion", "intellij.platform.core"})
@ApiStatus.Internal
public final class LocalizationUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u0004J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/LocalizationUtil$Companion;", "", "()V", "convertPathToLocaleSuffixUsage", "Ljava/nio/file/Path;", "path", "locale", "Ljava/util/Locale;", "withRegion", "", "convertPathToLocalizationFolderUsage", "getFolderLocalizedPaths", "", "getLocalizedPaths", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "getResourceAsStream", "Ljava/io/InputStream;", "defaultLoader", "intellij.platform.core"})
    @SourceDebugExtension(value={"SMAP\nLocalizationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/util/LocalizationUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ClassLoader getPluginClassLoader() {
            DynamicBundle.LanguageBundleEP languageBundleEP = DynamicBundle.findLanguageBundle();
            return languageBundleEP != null && (languageBundleEP = languageBundleEP.pluginDescriptor) != null ? languageBundleEP.getPluginClassLoader() : null;
        }

        private final Path convertPathToLocalizationFolderUsage(Path path, Locale locale, boolean withRegion) {
            String localizationFolderName = "localization";
            Path path2 = Paths.get(localizationFolderName, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            Path result2 = path2.resolve(locale.getLanguage());
            if (withRegion) {
                String string2 = locale.getCountry();
                Intrinsics.checkNotNullExpressionValue(string2, "getCountry(...)");
                if (((CharSequence)string2).length() > 0) {
                    result2 = result2.resolve(locale.getCountry());
                }
            }
            Path path3 = result2 = result2.resolve(path);
            Intrinsics.checkNotNull(path3);
            return path3;
        }

        private final Path convertPathToLocaleSuffixUsage(Path path, Locale locale, boolean withRegion) {
            Path path2;
            if (locale == null) {
                return path;
            }
            StringBuilder fileName = new StringBuilder(PathsKt.getNameWithoutExtension(path));
            String extension = PathsKt.getExtension(path);
            Path path3 = path.getParent();
            if (path3 == null) {
                Path path4 = Paths.get("", new String[0]);
                path2 = path4;
                Intrinsics.checkNotNullExpressionValue(path4, "get(...)");
            } else {
                path2 = path3;
            }
            Path foldersPath = path2;
            String language = locale.getLanguage();
            Intrinsics.checkNotNull(language);
            if (!(((CharSequence)language).length() == 0)) {
                fileName.append('_').append(language);
                String country = locale.getCountry();
                Intrinsics.checkNotNull(country);
                if (((CharSequence)country).length() > 0 && withRegion) {
                    fileName.append('_').append(country);
                }
            }
            if (((CharSequence)extension).length() > 0) {
                fileName.append(".").append(extension);
            }
            Path result2 = foldersPath.resolve(fileName.toString());
            Intrinsics.checkNotNull(result2);
            return result2;
        }

        @Nullable
        public final InputStream getResourceAsStream(@Nullable ClassLoader defaultLoader, @NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            List<Path> localizedPaths = this.getLocalizedPaths(path);
            for (Path localizedPath : localizedPaths) {
                InputStream inputStream;
                String pathString = StringsKt.replace$default(((Object)localizedPath).toString(), '\\', '/', false, 4, null);
                Object object = this.getPluginClassLoader();
                if (object != null && (inputStream = ((ClassLoader)object).getResourceAsStream(pathString)) != null) {
                    InputStream it = inputStream;
                    boolean bl2 = false;
                    return it;
                }
                if (defaultLoader == null || (object = defaultLoader.getResourceAsStream(pathString)) == null) continue;
                Object it = object;
                boolean bl3 = false;
                return it;
            }
            return null;
        }

        @NotNull
        public final List<Path> getLocalizedPaths(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            List result2 = new ArrayList();
            Locale locale = DynamicBundle.getLocale();
            Intrinsics.checkNotNullExpressionValue(locale, "getLocale(...)");
            result2.add(this.convertPathToLocalizationFolderUsage(path, locale, true));
            result2.add(this.convertPathToLocaleSuffixUsage(path, DynamicBundle.getLocale(), true));
            Locale locale2 = DynamicBundle.getLocale();
            Intrinsics.checkNotNullExpressionValue(locale2, "getLocale(...)");
            result2.add(this.convertPathToLocalizationFolderUsage(path, locale2, false));
            result2.add(this.convertPathToLocaleSuffixUsage(path, DynamicBundle.getLocale(), false));
            result2.add(path);
            return result2;
        }

        @NotNull
        public final List<Path> getFolderLocalizedPaths(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            List result2 = new ArrayList();
            Locale locale = DynamicBundle.getLocale();
            Intrinsics.checkNotNullExpressionValue(locale, "getLocale(...)");
            result2.add(this.convertPathToLocalizationFolderUsage(path, locale, true));
            Locale locale2 = DynamicBundle.getLocale();
            Intrinsics.checkNotNullExpressionValue(locale2, "getLocale(...)");
            result2.add(this.convertPathToLocalizationFolderUsage(path, locale2, false));
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

