/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import com.intellij.util.containers.HashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

final class ConcurrentWeakHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    ConcurrentWeakHashMap(float loadFactor) {
        super(16, loadFactor, DEFAULT_CONCURRENCY_LEVEL, HashingStrategy.canonical());
    }

    ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentWeakHashMap.$$$reportNull$$$0(0);
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    ConcurrentWeakHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentWeakHashMap.$$$reportNull$$$0(1);
        }
        super(hashingStrategy);
    }

    @Override
    @NotNull
    protected ConcurrentRefHashMap.KeyReference<K> createKeyReference(@NotNull K key, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (key == null) {
            ConcurrentWeakHashMap.$$$reportNull$$$0(2);
        }
        if (hashingStrategy == null) {
            ConcurrentWeakHashMap.$$$reportNull$$$0(3);
        }
        return new WeakKey(key, hashingStrategy.hashCode(key), hashingStrategy, this.myReferenceQueue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/ConcurrentWeakHashMap";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createKeyReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WeakKey<K>
    extends WeakReference<K>
    implements ConcurrentRefHashMap.KeyReference<K> {
        private final int myHash;
        @NotNull
        private final HashingStrategy<? super K> myStrategy;

        private WeakKey(@NotNull K k2, int hash, @NotNull HashingStrategy<? super K> strategy, @NotNull ReferenceQueue<K> q2) {
            if (k2 == null) {
                WeakKey.$$$reportNull$$$0(0);
            }
            if (strategy == null) {
                WeakKey.$$$reportNull$$$0(1);
            }
            if (q2 == null) {
                WeakKey.$$$reportNull$$$0(2);
            }
            super(k2, q2);
            this.myStrategy = strategy;
            this.myHash = hash;
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof ConcurrentRefHashMap.KeyReference)) {
                return false;
            }
            Object t2 = this.get();
            Object u2 = ((ConcurrentRefHashMap.KeyReference)o2).get();
            if (t2 == null || u2 == null) {
                return false;
            }
            return t2 == u2 || this.myStrategy.equals(t2, u2);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "k";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "strategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "q";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/ConcurrentWeakHashMap$WeakKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

