/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForwardIndexAccessor<Key, Value, DataType>
implements ForwardIndexAccessor<Key, Value> {
    @NotNull
    private final DataExternalizer<DataType> myDataTypeExternalizer;
    private static final ThreadLocalCachedByteArray ourSpareByteArrayForKeys = new ThreadLocalCachedByteArray();
    private static final ThreadLocalCachedByteArray ourSpareByteArrayForValues = new ThreadLocalCachedByteArray();

    public AbstractForwardIndexAccessor(@NotNull DataExternalizer<DataType> externalizer) {
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(0);
        }
        this.myDataTypeExternalizer = externalizer;
    }

    protected abstract InputDataDiffBuilder<Key, Value> createDiffBuilder(int var1, @Nullable DataType var2) throws IOException;

    @Nullable
    public DataType deserializeData(@Nullable ByteArraySequence sequence) throws IOException {
        if (sequence == null) {
            return null;
        }
        return AbstractForwardIndexAccessor.deserializeFromByteSeq(sequence, this.myDataTypeExternalizer);
    }

    @Override
    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId, @Nullable ByteArraySequence sequence) throws IOException {
        InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.createDiffBuilder(inputId, this.deserializeData(sequence));
        if (inputDataDiffBuilder == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(1);
        }
        return inputDataDiffBuilder;
    }

    @Nullable
    public abstract DataType convertToDataType(@NotNull InputData<Key, Value> var1);

    @Override
    @Nullable
    public ByteArraySequence serializeIndexedData(@NotNull InputData<Key, Value> data2) throws IOException {
        if (data2 == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(2);
        }
        return this.serializeIndexedData(this.convertToDataType(data2));
    }

    @Nullable
    public ByteArraySequence serializeIndexedData(@Nullable DataType data2) throws IOException {
        if (data2 == null) {
            return null;
        }
        return AbstractForwardIndexAccessor.serializeValueToByteSeq(data2, this.myDataTypeExternalizer, this.getBufferInitialSize(data2));
    }

    protected int getBufferInitialSize(@NotNull DataType dataType) {
        if (dataType == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(3);
        }
        return 4;
    }

    public static <Data> ByteArraySequence serializeKeyToByteSeq(Data data2, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize) throws IOException {
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(4);
        }
        return AbstractForwardIndexAccessor.serializeToByteSeq(data2, externalizer, bufferInitialSize, ourSpareByteArrayForKeys);
    }

    public static <Data> ByteArraySequence serializeValueToByteSeq(Data data2, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize) throws IOException {
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(5);
        }
        return AbstractForwardIndexAccessor.serializeToByteSeq(data2, externalizer, bufferInitialSize, ourSpareByteArrayForValues);
    }

    @Nullable
    public static <Data> ByteArraySequence serializeToByteSeq(Data data2, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize, @NotNull ThreadLocalCachedByteArray cachedBufferToUse) throws IOException {
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(6);
        }
        if (cachedBufferToUse == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(7);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(s2 -> cachedBufferToUse.getBuffer(s2), bufferInitialSize);
        DataOutputStream stream = new DataOutputStream(out);
        externalizer.save(stream, data2);
        return out.size() == 0 ? null : out.toByteArraySequence();
    }

    public static <Data> Data deserializeFromByteSeq(@NotNull ByteArraySequence bytes, @NotNull DataExternalizer<Data> externalizer) throws IOException {
        if (bytes == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(8);
        }
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(9);
        }
        return externalizer.read(bytes.toInputStream());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/AbstractForwardIndexAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedBufferToUse";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/AbstractForwardIndexAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffBuilder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexedData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBufferInitialSize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serializeKeyToByteSeq";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeValueToByteSeq";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializeToByteSeq";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserializeFromByteSeq";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

