/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.dev.durablemaps;

import com.intellij.openapi.util.ThrowableComputable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface Compactable<C extends Compactable<C>> {
    @NotNull
    public CompactionScore compactionScore() throws IOException;

    @NotNull
    public <C1 extends C> C1 compact(@NotNull ThrowableComputable<C1, ? extends IOException> var1) throws IOException;

    public static class CompactionIsRequiredException
    extends IOException {
        public CompactionIsRequiredException(String message) {
            super(message);
        }

        public CompactionIsRequiredException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CompactionScore {
        private final double score;

        public CompactionScore(double score) {
            this.score = score;
        }

        public double score() {
            return this.score;
        }

        public boolean compactionNotNeeded() {
            return this.score < 0.1;
        }

        public boolean compactionNeeded() {
            return this.score > 0.5;
        }

        public boolean compactionNeededUrgently() {
            return this.score > 0.9;
        }

        public String toString() {
            return "CompactionScore[=" + this.score + ']';
        }
    }
}

