/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ThreeState;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016J&\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010)H\u0016J\"\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010)J&\u0010,\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020\u00122\b\u0010-\u001a\u0004\u0018\u00010\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010)H\u0016J4\u0010.\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00122\b\u0010-\u001a\u0004\u0018\u00010\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010)2\u0006\u00100\u001a\u00020\u001bJ\u0014\u00101\u001a\u00020\u00182\f\u00102\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\b\u00103\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/util/xmlb/BeanBinding;", "Lcom/intellij/util/xmlb/NotNullDeserializeBinding;", "beanClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "bindings", "", "Lcom/intellij/util/xmlb/NestedBinding;", "[Lcom/intellij/util/xmlb/NestedBinding;", "compareByFields", "Lcom/intellij/util/ThreeState;", "tagName", "", "computeBindingWeights", "Lit/unimi/dsi/fastutil/objects/Object2FloatMap;", "accessorNameTracker", "", "deserialize", "", "context", "element", "Lcom/intellij/util/xml/dom/XmlElement;", "Lorg/jdom/Element;", "deserializeInto", "", "result", "equalByFields", "", "currentValue", "defaultValue", "filter", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "init", "originalType", "Ljava/lang/reflect/Type;", "serializer", "Lcom/intellij/util/xmlb/Serializer;", "isBoundTo", "newInstance", "serialize", "o", "Lcom/intellij/util/xmlb/SerializationFilter;", "bean", "createElementIfEmpty", "serializeInto", "preCreatedElement", "serializePropertyInto", "binding", "isFilterPropertyItself", "sortBindings", "weights", "toString", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBeanBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeanBinding.kt\ncom/intellij/util/xmlb/BeanBinding\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
public class BeanBinding
extends NotNullDeserializeBinding {
    @JvmField
    @NotNull
    public final Class<?> beanClass;
    @NotNull
    private final String tagName;
    @JvmField
    @Nullable
    public NestedBinding[] bindings;
    @JvmField
    @NotNull
    public ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(beanClass, "beanClass");
        this.beanClass = beanClass;
        this.compareByFields = ThreeState.UNSURE;
        boolean bl3 = bl2 = !this.beanClass.isArray();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-BeanBinding$42 = false;
            String $i$a$-assert-BeanBinding$42 = "Bean is an array: " + this.beanClass;
            throw new AssertionError((Object)$i$a$-assert-BeanBinding$42);
        }
        boolean bl4 = bl2 = !this.beanClass.isPrimitive();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-BeanBinding$52 = false;
            String $i$a$-assert-BeanBinding$52 = "Bean is primitive type: " + this.beanClass;
            throw new AssertionError((Object)$i$a$-assert-BeanBinding$52);
        }
        this.tagName = BeanBindingKt.access$getTagName(this.beanClass);
        boolean bl5 = bl2 = !StringsKt.isBlank(this.tagName);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string2 = "Bean name is empty: " + this.beanClass;
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        boolean bl3 = bl2 = this.bindings == null;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Property classAnnotation = this.beanClass.getAnnotation(Property.class);
        List<MutableAccessor> list = XmlSerializerUtil.getAccessors(this.beanClass);
        Intrinsics.checkNotNullExpressionValue(list, "getAccessors(...)");
        List<MutableAccessor> accessors = list;
        NestedBinding[] result2 = accessors.isEmpty() ? NestedBinding.EMPTY_ARRAY : new NestedBinding[accessors.size()];
        int n2 = result2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MutableAccessor mutableAccessor = accessors.get(i2);
            Intrinsics.checkNotNullExpressionValue(mutableAccessor, "get(...)");
            Object object = classAnnotation;
            if (object == null || (object = object.style()) == null) {
                object = Property.Style.OPTION_TAG;
            }
            NestedBinding binding = BeanBindingKt.access$createBinding(mutableAccessor, serializer2, (Property.Style)((Object)object));
            binding.init(originalType, serializer2);
            result2[i2] = binding;
        }
        this.bindings = result2;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o2, @Nullable Object context, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(o2, "o");
        return this.serializeInto(o2, context == null ? null : new Element(this.tagName), filter2);
    }

    @Nullable
    public final Element serialize(@NotNull Object bean, boolean createElementIfEmpty, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(bean, "bean");
        return this.serializeInto(bean, createElementIfEmpty ? new Element(this.tagName) : null, filter2);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o2, @Nullable Element preCreatedElement, @Nullable SerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(o2, "o");
        Element element = preCreatedElement;
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            if (o2 instanceof SerializationFilter && !((SerializationFilter)o2).accepts(binding.getAccessor(), o2)) continue;
            element = this.serializePropertyInto(binding, o2, element, filter2, true);
        }
        return element;
    }

    @Nullable
    public final Element serializePropertyInto(@NotNull NestedBinding binding, @NotNull Object o2, @Nullable Element preCreatedElement, @Nullable SerializationFilter filter2, boolean isFilterPropertyItself) {
        Object node;
        Intrinsics.checkNotNullParameter(binding, "binding");
        Intrinsics.checkNotNullParameter(o2, "o");
        Element element = preCreatedElement;
        MutableAccessor mutableAccessor = binding.getAccessor();
        Intrinsics.checkNotNullExpressionValue(mutableAccessor, "getAccessor(...)");
        MutableAccessor accessor = mutableAccessor;
        Property property = accessor.getAnnotation(Property.class);
        if (property == null || !property.alwaysWrite()) {
            SerializationFilter propertyFilter;
            if (filter2 != null && isFilterPropertyItself && (filter2 instanceof SkipDefaultsSerializationFilter ? ((SkipDefaultsSerializationFilter)filter2).equal(binding, o2) : !filter2.accepts(accessor, o2))) {
                return element;
            }
            if (property != null && (propertyFilter = XmlSerializerUtil.getPropertyFilter(property)) != null && !propertyFilter.accepts(accessor, o2)) {
                return element;
            }
        }
        if (element == null) {
            element = new Element(this.tagName);
        }
        if ((node = binding.serialize(o2, element, filter2)) != null) {
            if (node instanceof Attribute) {
                element.setAttribute((Attribute)node);
            } else {
                Binding.addContent(element, node);
            }
        }
        return element;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Object instance = this.newInstance();
        this.deserializeInto(instance, element);
        return instance;
    }

    public final void deserializeInto(@NotNull Object result2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNull(this.bindings);
        NestedBinding[] nestedBindingArray = this.bindings;
        Intrinsics.checkNotNull(this.bindings);
        int n2 = this.bindings.length;
        BeanBindingKt.deserializeBeanInto(result2, element, nestedBindingArray, 0, n2, null);
    }

    public final void deserializeInto(@NotNull Object result2, @NotNull XmlElement element) {
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNull(this.bindings);
        Intrinsics.checkNotNull(this.bindings);
        BeanBindingKt.deserializeBeanInto(result2, element, this.bindings, 0, this.bindings.length);
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull XmlElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Object instance = this.newInstance();
        Intrinsics.checkNotNull(this.bindings);
        BeanBindingKt.deserializeBeanInto$default(instance, element, this.bindings, 0, 0, 24, null);
        return instance;
    }

    @NotNull
    public Object newInstance() {
        try {
            Constructor<?> constructor = this.beanClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object obj = constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue(obj, "newInstance(...)");
            return obj;
        }
        catch (InvocationTargetException e2) {
            Throwable throwable = e2.getTargetException();
            if (throwable == null) {
                throwable = e2;
            }
            throw throwable;
        }
    }

    public final boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter2) {
        Intrinsics.checkNotNullParameter(currentValue, "currentValue");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            MutableAccessor accessor;
            Intrinsics.checkNotNullExpressionValue(binding.getAccessor(), "getAccessor(...)");
            if (filter2.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Object2FloatMap<String> computeBindingWeights(@NotNull Set<String> accessorNameTracker) {
        Intrinsics.checkNotNullParameter(accessorNameTracker, "accessorNameTracker");
        Object2FloatOpenHashMap<String> weights = new Object2FloatOpenHashMap<String>(accessorNameTracker.size());
        float weight = 0.0f;
        Intrinsics.checkNotNull(this.bindings);
        float step = (float)this.bindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put(name, weight);
            weight += step;
        }
        weight = 0.0f;
        Intrinsics.checkNotNull(this.bindings);
        for (NestedBinding binding : this.bindings) {
            String name;
            Intrinsics.checkNotNullExpressionValue(binding.getAccessor().getName(), "getName(...)");
            if (!weights.containsKey(name)) {
                weights.put(name, weight);
            }
            float f2 = weight;
            weight = f2 + 1.0f;
        }
        return weights;
    }

    public final void sortBindings(@NotNull Object2FloatMap<String> weights) {
        Intrinsics.checkNotNullParameter(weights, "weights");
        Intrinsics.checkNotNull(this.bindings);
        Arrays.sort(this.bindings, (arg_0, arg_1) -> BeanBinding.sortBindings$lambda$3(new Function2<NestedBinding, NestedBinding, Integer>(weights){
            final /* synthetic */ Object2FloatMap<String> $weights;
            {
                this.$weights = $weights;
                super(2);
            }

            @NotNull
            public final Integer invoke(NestedBinding o1, NestedBinding o2) {
                String string2 = o1.getAccessor().getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                String n1 = string2;
                String string3 = o2.getAccessor().getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                String n2 = string3;
                float w1 = this.$weights.getFloat(n1);
                float w2 = this.$weights.getFloat(n2);
                return (int)(w1 - w2);
            }
        }, arg_0, arg_1));
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return Intrinsics.areEqual(element.getName(), this.tagName);
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return Intrinsics.areEqual(element.name, this.tagName);
    }

    @NotNull
    public String toString() {
        return "BeanBinding[" + this.beanClass.getName() + ", tagName=" + this.tagName + ']';
    }

    private static final int sortBindings$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

