/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.BeanBindingKt;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Property;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlSerializerUtil {
    private XmlSerializerUtil() {
    }

    public static <T> void copyBean(@NotNull T from, @NotNull T to) {
        if (from == null) {
            XmlSerializerUtil.$$$reportNull$$$0(0);
        }
        if (to == null) {
            XmlSerializerUtil.$$$reportNull$$$0(1);
        }
        assert (from.getClass().isAssignableFrom(to.getClass())) : "Beans of different classes specified: Cannot assign " + from.getClass() + " to " + to.getClass();
        for (MutableAccessor accessor : BeanBindingKt.getBeanAccessors(from.getClass())) {
            accessor.set(to, accessor.read(from));
        }
    }

    public static <T> T createCopy(@NotNull T from) {
        if (from == null) {
            XmlSerializerUtil.$$$reportNull$$$0(2);
        }
        try {
            Object to = ReflectionUtil.newInstance(from.getClass());
            XmlSerializerUtil.copyBean(from, to);
            return (T)to;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        if (aClass == null) {
            XmlSerializerUtil.$$$reportNull$$$0(3);
        }
        List<MutableAccessor> list = BeanBindingKt.getBeanAccessors(aClass);
        if (list == null) {
            XmlSerializerUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    static SerializationFilter getPropertyFilter(@NotNull Property property) {
        Class<? extends SerializationFilter> filter2;
        if (property == null) {
            XmlSerializerUtil.$$$reportNull$$$0(5);
        }
        return (filter2 = property.filter()) == SerializationFilter.class ? null : ReflectionUtil.newInstance(filter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/XmlSerializerUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/XmlSerializerUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyBean";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyFilter";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

