/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.Double2ObjectFunction;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import it.unimi.dsi.fastutil.doubles.Z;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.r;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;

public class Double2ObjectOpenHashMap<V>
extends it.unimi.dsi.fastutil.doubles.b<V>
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient double[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Double2ObjectMap.FastEntrySet<V> entries;
    protected transient DoubleSet keys;
    protected transient ObjectCollection<V> values;

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
        double2ObjectOpenHashMap.minN = double2ObjectOpenHashMap.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new double[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public Double2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(Map<? extends Double, ? extends V> m2, float f2) {
        this(m2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((it.unimi.dsi.fastutil.doubles.b)this).putAll((Map<Double, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(Map<? extends Double, ? extends V> m2) {
        this((Map<Double, V>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(Double2ObjectMap<V> m2, float f2) {
        this(m2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((it.unimi.dsi.fastutil.doubles.b)this).putAll((Map<Double, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(Double2ObjectMap<V> m2) {
        this((Double2ObjectMap<V>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(double[] k2, V[] v2, float f2) {
        this(k2.length, (float)var3_3);
        void var3_3;
        if (k2.length != v2.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v2.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v2[i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Double2ObjectOpenHashMap(double[] k2, V[] v2) {
        this((double[])var1_1, (V[])var2_2, 0.75f);
        void var2_2;
        void var1_1;
    }

    private int a() {
        if (this.containsNullKey) {
            return this.size - 1;
        }
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private V a(int n2) {
        V v2 = this.value[n2];
        this.value[n2] = null;
        --this.size;
        int n3 = n2;
        Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
        double[] dArray = double2ObjectOpenHashMap.key;
        block0: while (true) {
            double d2;
            int n4 = n3;
            n3 = n4 + 1 & double2ObjectOpenHashMap.mask;
            while (true) {
                if (Double.doubleToLongBits(d2 = dArray[n3]) == 0L) break block0;
                int n5 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & double2ObjectOpenHashMap.mask;
                if (n4 > n3 ? n4 >= n5 && n5 > n3 : n4 >= n5 || n5 > n3) break;
                n3 = n3 + 1 & double2ObjectOpenHashMap.mask;
            }
            dArray[n4] = d2;
            double2ObjectOpenHashMap.value[n4] = double2ObjectOpenHashMap.value[n3];
        }
        dArray[n4] = 0.0;
        double2ObjectOpenHashMap.value[n4] = null;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            Double2ObjectOpenHashMap double2ObjectOpenHashMap2 = this;
            double2ObjectOpenHashMap2.rehash(double2ObjectOpenHashMap2.n / 2);
        }
        return v2;
    }

    private V b() {
        this.containsNullKey = false;
        V v2 = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
            double2ObjectOpenHashMap.rehash(double2ObjectOpenHashMap.n / 2);
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Double, ? extends V> m2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m2.size());
        } else {
            Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
            long l2 = double2ObjectOpenHashMap.size() + m2.size();
            Double2ObjectOpenHashMap double2ObjectOpenHashMap2 = double2ObjectOpenHashMap;
            int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / double2ObjectOpenHashMap2.f))));
            if (n2 > double2ObjectOpenHashMap2.n) {
                double2ObjectOpenHashMap2.rehash(n2);
            }
        }
        super.putAll(var1_1);
    }

    private int a(double d2) {
        if (Double.doubleToLongBits(d2) == 0L) {
            if (this.containsNullKey) {
                return this.n;
            }
            return -(this.n + 1);
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.mask;
        double d3 = this.key[n2];
        if (Double.doubleToLongBits(d3) == 0L) {
            return -(n2 + 1);
        }
        if (Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3)) {
            return n2;
        }
        do {
            if (Double.doubleToLongBits(d3 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return -(n2 + 1);
        } while (Double.doubleToLongBits(d2) != Double.doubleToLongBits(d3));
        return n2;
    }

    private void a(int n2, double d2, V v2) {
        if (n2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[n2] = d2;
        this.value[n2] = v2;
        if (this.size++ >= this.maxFill) {
            Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
            double2ObjectOpenHashMap.rehash(HashCommon.arraySize(double2ObjectOpenHashMap.size + 1, this.f));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(double k2, V v2) {
        void var3_3;
        int n2 = this.a(k2);
        if (n2 < 0) {
            void var1_1;
            this.a(-n2 - 1, (double)var1_1, v2);
            return this.defRetValue;
        }
        V v3 = this.value[n2];
        this.value[n2] = var3_3;
        return v3;
    }

    @Override
    public V remove(double k2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNullKey) {
                return this.b();
            }
            return this.defRetValue;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return this.defRetValue;
        }
        if (Double.doubleToLongBits(k2) == Double.doubleToLongBits(d2)) {
            return this.a(n2);
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (Double.doubleToLongBits(k2) != Double.doubleToLongBits(d2));
        return this.a(n2);
    }

    @Override
    public V get(double k2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNullKey) {
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return this.defRetValue;
        }
        if (Double.doubleToLongBits(k2) == Double.doubleToLongBits(d2)) {
            return this.value[n2];
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (Double.doubleToLongBits(k2) != Double.doubleToLongBits(d2));
        return this.value[n2];
    }

    @Override
    public boolean containsKey(double k2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            return this.containsNullKey;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return false;
        }
        if (Double.doubleToLongBits(k2) == Double.doubleToLongBits(d2)) {
            return true;
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToLongBits(k2) != Double.doubleToLongBits(d2));
        return true;
    }

    @Override
    public boolean containsValue(Object v2) {
        V[] VArray = this.value;
        double[] dArray = this.key;
        if (this.containsNullKey && Objects.equals(VArray[this.n], v2)) {
            return true;
        }
        int n2 = this.n;
        while (n2-- != 0) {
            if (Double.doubleToLongBits(dArray[n2]) == 0L || !Objects.equals(VArray[n2], v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getOrDefault(double k2, V defaultValue) {
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNullKey) {
                return this.value[this.n];
            }
            return defaultValue;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return defaultValue;
        }
        if (Double.doubleToLongBits(k2) == Double.doubleToLongBits(d2)) {
            return this.value[n2];
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return defaultValue;
        } while (Double.doubleToLongBits(k2) != Double.doubleToLongBits(d2));
        return this.value[n2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(double k2, V v2) {
        void var3_2;
        void var1_1;
        int n2 = this.a(k2);
        if (n2 >= 0) {
            return this.value[n2];
        }
        this.a(-n2 - 1, (double)var1_1, var3_2);
        return this.defRetValue;
    }

    @Override
    public boolean remove(double k2, Object v2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNullKey && Objects.equals(v2, this.value[this.n])) {
                this.b();
                return true;
            }
            return false;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return false;
        }
        if (Double.doubleToLongBits(k2) == Double.doubleToLongBits(d2) && Objects.equals(v2, this.value[n2])) {
            this.a(n2);
            return true;
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToLongBits(k2) != Double.doubleToLongBits(d2) || !Objects.equals(v2, this.value[n2]));
        this.a(n2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(double k2, V oldValue, V v2) {
        void var3_3;
        void var1_1;
        int n2 = this.a((double)var1_1);
        if (n2 < 0 || !Objects.equals(var3_3, this.value[n2])) {
            return false;
        }
        this.value[n2] = v2;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(double k2, V v2) {
        void var3_3;
        void var1_1;
        int n2 = this.a((double)var1_1);
        if (n2 < 0) {
            return this.defRetValue;
        }
        V v3 = this.value[n2];
        this.value[n2] = var3_3;
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfAbsent(double k2, DoubleFunction<? extends V> mappingFunction) {
        void var1_1;
        Object r2;
        Objects.requireNonNull(mappingFunction);
        int n2 = this.a(k2);
        if (n2 >= 0) {
            return this.value[n2];
        }
        r2 = r2.apply(k2);
        this.a(-n2 - 1, (double)var1_1, r2);
        return (V)r2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfAbsent(double key, Double2ObjectFunction<? extends V> mappingFunction) {
        void var1_1;
        Object v2;
        Objects.requireNonNull(mappingFunction);
        int n2 = this.a(key);
        if (n2 >= 0) {
            return this.value[n2];
        }
        if (!mappingFunction.containsKey(key)) {
            return this.defRetValue;
        }
        v2 = v2.get(key);
        this.a(-n2 - 1, (double)var1_1, v2);
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfPresent(double k2, BiFunction<? super Double, ? super V, ? extends V> remappingFunction) {
        Object r2;
        Objects.requireNonNull(remappingFunction);
        int n2 = this.a(k2);
        if (n2 < 0) {
            return this.defRetValue;
        }
        if (this.value[n2] == null) {
            return this.defRetValue;
        }
        if ((r2 = r2.apply(k2, this.value[n2])) == null) {
            void var1_1;
            if (Double.doubleToLongBits((double)var1_1) == 0L) {
                this.b();
            } else {
                this.a(n2);
            }
            return this.defRetValue;
        }
        this.value[n2] = r2;
        return this.value[n2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V compute(double k2, BiFunction<? super Double, ? super V, ? extends V> remappingFunction) {
        Object r2;
        Objects.requireNonNull(remappingFunction);
        int n2 = this.a(k2);
        r2 = r2.apply(k2, n2 >= 0 ? (Object)this.value[n2] : null);
        if (r2 == null) {
            if (n2 >= 0) {
                if (Double.doubleToLongBits(k2) == 0L) {
                    this.b();
                } else {
                    this.a(n2);
                }
            }
            return this.defRetValue;
        }
        if (n2 < 0) {
            void var1_1;
            this.a(-n2 - 1, (double)var1_1, r2);
            return (V)r2;
        }
        this.value[n2] = r2;
        return this.value[n2];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V merge(double k2, V v2, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V v3;
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(v2);
        int n2 = this.a(k2);
        if (n2 < 0 || this.value[n2] == null) {
            if (n2 < 0) {
                this.a(-n2 - 1, k2, v2);
            } else {
                this.value[n2] = v2;
            }
            return v2;
        }
        if ((v3 = remappingFunction.apply(this.value[n2], v3)) == null) {
            void var1_1;
            if (Double.doubleToLongBits((double)var1_1) == 0L) {
                this.b();
            } else {
                this.a(n2);
            }
            return this.defRetValue;
        }
        this.value[n2] = v3;
        return this.value[n2];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0.0);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Double2ObjectMap.FastEntrySet<V> double2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new h(this, 0);
        }
        return this.entries;
    }

    @Override
    public DoubleSet keySet() {
        if (this.keys == null) {
            this.keys = new e(this, 0);
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new r<V>(this){
                private /* synthetic */ Double2ObjectOpenHashMap a;
                {
                    this.a = double2ObjectOpenHashMap;
                }

                @Override
                public final ObjectIterator<V> iterator() {
                    return new k(this.a);
                }

                @Override
                public final ObjectSpliterator<V> spliterator() {
                    return new l(this.a);
                }

                @Override
                public final void forEach(Consumer<? super V> consumer2) {
                    if (this.a.containsNullKey) {
                        consumer2.accept(this.a.value[this.a.n]);
                    }
                    int n2 = this.a.n;
                    while (n2-- != 0) {
                        if (Double.doubleToLongBits(this.a.key[n2]) == 0L) continue;
                        consumer2.accept(this.a.value[n2]);
                    }
                }

                @Override
                public final int size() {
                    return this.a.size;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean contains(Object v2) {
                    void var1_1;
                    return ((it.unimi.dsi.fastutil.doubles.b)this.a).containsValue(var1_1);
                }

                @Override
                public final void clear() {
                    this.a.clear();
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
        return double2ObjectOpenHashMap.trim(double2ObjectOpenHashMap.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        double[] dArray = this.key;
        V[] VArray = this.value;
        int n2 = newN - 1;
        double[] dArray2 = new double[newN + 1];
        Object[] objectArray = new Object[newN + 1];
        int n3 = this.n;
        int n4 = this.a();
        while (n4-- != 0) {
            while (Double.doubleToLongBits(dArray[--n3]) == 0L) {
            }
            int n5 = (int)HashCommon.mix(Double.doubleToRawLongBits(dArray[n3])) & n2;
            if (Double.doubleToLongBits(dArray2[n5]) != 0L) {
                while (Double.doubleToLongBits(dArray2[n5 = n5 + 1 & n2]) != 0L) {
                }
            }
            dArray2[n5] = dArray[n3];
            objectArray[n5] = VArray[n3];
        }
        objectArray[newN] = VArray[this.n];
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = dArray2;
        this.value = objectArray;
    }

    public Double2ObjectOpenHashMap<V> clone() {
        Double2ObjectOpenHashMap double2ObjectOpenHashMap;
        try {
            double2ObjectOpenHashMap = (Double2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        double2ObjectOpenHashMap.keys = null;
        double2ObjectOpenHashMap.values = null;
        double2ObjectOpenHashMap.entries = null;
        double2ObjectOpenHashMap.containsNullKey = this.containsNullKey;
        double2ObjectOpenHashMap.key = (double[])this.key.clone();
        double2ObjectOpenHashMap.value = (Object[])this.value.clone();
        return double2ObjectOpenHashMap;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.a();
        int n4 = 0;
        while (n3-- != 0) {
            while (Double.doubleToLongBits(this.key[n4]) == 0L) {
                ++n4;
            }
            int n5 = HashCommon.double2int(this.key[n4]);
            Double2ObjectOpenHashMap double2ObjectOpenHashMap = this;
            if (double2ObjectOpenHashMap != double2ObjectOpenHashMap.value[n4]) {
                n5 ^= this.value[n4] == null ? 0 : this.value[n4].hashCode();
            }
            n2 += n5;
            ++n4;
        }
        if (this.containsNullKey) {
            n2 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        double[] dArray = this.key;
        V[] VArray = this.value;
        a a2 = new a(this, 0);
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            int n3 = a2.a();
            s2.writeDouble(dArray[n3]);
            s2.writeObject(VArray[n3]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n + 1];
        double[] dArray = this.key;
        this.value = new Object[this.n + 1];
        Object[] objectArray = this.value;
        int n2 = this.size;
        while (n2-- != 0) {
            int n3;
            double d2 = s2.readDouble();
            Object object = s2.readObject();
            if (Double.doubleToLongBits(d2) == 0L) {
                n3 = this.n;
                this.containsNullKey = true;
            } else {
                n3 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.mask;
                while (Double.doubleToLongBits(dArray[n3]) != 0L) {
                    n3 = n3 + 1 & this.mask;
                }
            }
            dArray[n3] = d2;
            objectArray[n3] = object;
        }
    }

    final class h
    extends AbstractObjectSet<Double2ObjectMap.Entry<V>>
    implements Double2ObjectMap.FastEntrySet<V> {
        private /* synthetic */ Double2ObjectOpenHashMap a;

        private h(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.a = double2ObjectOpenHashMap;
        }

        @Override
        public final ObjectIterator<Double2ObjectMap.Entry<V>> iterator() {
            return new a(this.a, 0);
        }

        @Override
        public final ObjectIterator<Double2ObjectMap.Entry<V>> a() {
            return new c(this.a, 0);
        }

        @Override
        public final ObjectSpliterator<Double2ObjectMap.Entry<V>> spliterator() {
            return new b(this.a);
        }

        @Override
        public final boolean contains(Object o2) {
            Map.Entry entry;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if ((entry = (Map.Entry)entry).getKey() == null || !(entry.getKey() instanceof Double)) {
                return false;
            }
            double d2 = (Double)entry.getKey();
            entry = entry.getValue();
            if (Double.doubleToLongBits(d2) == 0L) {
                return this.a.containsNullKey && Objects.equals(this.a.value[this.a.n], entry);
            }
            double[] dArray = this.a.key;
            int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.a.mask;
            double d3 = this.a.key[n2];
            if (Double.doubleToLongBits(d3) == 0L) {
                return false;
            }
            if (Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3)) {
                return Objects.equals(this.a.value[n2], entry);
            }
            do {
                if (Double.doubleToLongBits(d3 = dArray[n2 = n2 + 1 & this.a.mask]) != 0L) continue;
                return false;
            } while (Double.doubleToLongBits(d2) != Double.doubleToLongBits(d3));
            return Objects.equals(this.a.value[n2], entry);
        }

        @Override
        public final boolean remove(Object o2) {
            Map.Entry entry;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            if ((entry = (Map.Entry)entry).getKey() == null || !(entry.getKey() instanceof Double)) {
                return false;
            }
            double d2 = (Double)entry.getKey();
            entry = entry.getValue();
            if (Double.doubleToLongBits(d2) == 0L) {
                if (this.a.containsNullKey && Objects.equals(this.a.value[this.a.n], entry)) {
                    this.a.b();
                    return true;
                }
                return false;
            }
            double[] dArray = this.a.key;
            int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.a.mask;
            double d3 = this.a.key[n2];
            if (Double.doubleToLongBits(d3) == 0L) {
                return false;
            }
            if (Double.doubleToLongBits(d3) == Double.doubleToLongBits(d2)) {
                if (Objects.equals(this.a.value[n2], entry)) {
                    this.a.a(n2);
                    return true;
                }
                return false;
            }
            do {
                if (Double.doubleToLongBits(d3 = dArray[n2 = n2 + 1 & this.a.mask]) != 0L) continue;
                return false;
            } while (Double.doubleToLongBits(d3) != Double.doubleToLongBits(d2) || !Objects.equals(this.a.value[n2], entry));
            this.a.a(n2);
            return true;
        }

        @Override
        public final int size() {
            return this.a.size;
        }

        @Override
        public final void clear() {
            this.a.clear();
        }

        @Override
        public final void forEach(Consumer<? super Double2ObjectMap.Entry<V>> consumer2) {
            if (this.a.containsNullKey) {
                consumer2.accept(new g(this.a, this.a.n));
            }
            int n2 = this.a.n;
            while (n2-- != 0) {
                if (Double.doubleToLongBits(this.a.key[n2]) == 0L) continue;
                consumer2.accept(new g(this.a, n2));
            }
        }

        @Override
        public final void a(Consumer<? super Double2ObjectMap.Entry<V>> consumer2) {
            g g2 = new g(this.a);
            if (this.a.containsNullKey) {
                g2.a = this.a.n;
                consumer2.accept(g2);
            }
            int n2 = this.a.n;
            while (n2-- != 0) {
                if (Double.doubleToLongBits(this.a.key[n2]) == 0L) continue;
                g2.a = n2;
                consumer2.accept(g2);
            }
        }

        /* synthetic */ h(Double2ObjectOpenHashMap double2ObjectOpenHashMap, byte by) {
            this(double2ObjectOpenHashMap);
        }
    }

    final class e
    extends it.unimi.dsi.fastutil.doubles.f {
        private /* synthetic */ Double2ObjectOpenHashMap a;

        private e(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.a = double2ObjectOpenHashMap;
        }

        @Override
        public final DoubleIterator iterator() {
            return new d(this.a);
        }

        @Override
        public final DoubleSpliterator spliterator() {
            return new f(this.a);
        }

        @Override
        public final void forEach(DoubleConsumer consumer2) {
            if (this.a.containsNullKey) {
                consumer2.accept(this.a.key[this.a.n]);
            }
            int n2 = this.a.n;
            while (n2-- != 0) {
                double d2 = this.a.key[n2];
                if (Double.doubleToLongBits(d2) == 0L) continue;
                consumer2.accept(d2);
            }
        }

        @Override
        public final int size() {
            return this.a.size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(double k2) {
            void var1_1;
            return ((it.unimi.dsi.fastutil.doubles.b)this.a).containsKey((double)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(double k2) {
            void var1_1;
            int n2 = this.a.size;
            this.a.remove((double)var1_1);
            return this.a.size != n2;
        }

        @Override
        public final void clear() {
            this.a.clear();
        }

        /* synthetic */ e(Double2ObjectOpenHashMap double2ObjectOpenHashMap, byte by) {
            this(double2ObjectOpenHashMap);
        }
    }

    final class a
    extends i
    implements ObjectIterator {
        private g a;
        private /* synthetic */ Double2ObjectOpenHashMap b;

        private a(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, (byte)0);
        }

        @Override
        public final void remove() {
            super.remove();
            this.a.a = -1;
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer2 = (Consumer)object;
            object = this;
            ((a)object).a = new g(((a)object).b, n3);
            consumer2.accept(((a)object).a);
        }

        @Override
        public final /* synthetic */ Object next() {
            a a2 = this;
            this.a = new g(a2.b, a2.a());
            return this.a;
        }

        /* synthetic */ a(Double2ObjectOpenHashMap double2ObjectOpenHashMap, byte by) {
            this(double2ObjectOpenHashMap);
        }
    }

    final class l
    extends j
    implements ObjectSpliterator {
        private /* synthetic */ Double2ObjectOpenHashMap b;

        l(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap);
        }

        private l(Double2ObjectOpenHashMap double2ObjectOpenHashMap, int n2, int n3, boolean bl2) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, n2, n3, bl2);
        }

        @Override
        public final int characteristics() {
            if (this.a) {
                return 0;
            }
            return 64;
        }

        final /* synthetic */ j a(int n2, int n3, boolean bl2) {
            boolean bl3 = bl2;
            int n4 = n3;
            n3 = n2;
            l l2 = this;
            return new l(l2.b, n3, n4, bl3);
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer2 = (Consumer)object;
            object = this;
            consumer2.accept(((l)object).b.value[n3]);
        }

        public final /* synthetic */ ObjectSpliterator a() {
            return (ObjectSpliterator)super.b();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return (Spliterator)super.b();
        }
    }

    final class k
    extends i
    implements ObjectIterator {
        private /* synthetic */ Double2ObjectOpenHashMap a;

        public k(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.a = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, (byte)0);
        }

        @Override
        public final V next() {
            return this.a.value[this.a()];
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer2 = (Consumer)object;
            object = this;
            consumer2.accept(((k)object).a.value[n3]);
        }
    }

    final class f
    extends j
    implements DoubleSpliterator {
        private /* synthetic */ Double2ObjectOpenHashMap b;

        f(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap);
        }

        private f(Double2ObjectOpenHashMap double2ObjectOpenHashMap, int n2, int n3, boolean bl2) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, n2, n3, bl2);
        }

        @Override
        public final int characteristics() {
            if (this.a) {
                return 257;
            }
            return 321;
        }

        final /* synthetic */ j a(int n2, int n3, boolean bl2) {
            boolean bl3 = bl2;
            int n4 = n3;
            n3 = n2;
            f f2 = this;
            return new f(f2.b, n3, n4, bl3);
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            DoubleConsumer doubleConsumer = (DoubleConsumer)object;
            object = this;
            doubleConsumer.accept(((f)object).b.key[n3]);
        }

        @Override
        public final /* synthetic */ DoubleSpliterator i_() {
            return (DoubleSpliterator)super.b();
        }

        @Override
        public final /* synthetic */ Spliterator.OfDouble trySplit() {
            return (Spliterator.OfDouble)super.b();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return (Spliterator.OfPrimitive)super.b();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return (Spliterator)super.b();
        }
    }

    final class d
    extends i
    implements DoubleIterator {
        private /* synthetic */ Double2ObjectOpenHashMap a;

        public d(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.a = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, (byte)0);
        }

        @Override
        public final double nextDouble() {
            return this.a.key[this.a()];
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            DoubleConsumer doubleConsumer = (DoubleConsumer)object;
            object = this;
            doubleConsumer.accept(((d)object).a.key[n3]);
        }
    }

    final class b
    extends j
    implements ObjectSpliterator {
        private /* synthetic */ Double2ObjectOpenHashMap b;

        b(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap);
        }

        private b(Double2ObjectOpenHashMap double2ObjectOpenHashMap, int n2, int n3, boolean bl2) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, n2, n3, bl2);
        }

        @Override
        public final int characteristics() {
            if (this.a) {
                return 1;
            }
            return 65;
        }

        final /* synthetic */ j a(int n2, int n3, boolean bl2) {
            boolean bl3 = bl2;
            int n4 = n3;
            n3 = n2;
            b b2 = this;
            return new b(b2.b, n3, n4, bl3);
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer2 = (Consumer)object;
            object = this;
            consumer2.accept(new g(((b)object).b, n3));
        }

        public final /* synthetic */ ObjectSpliterator a() {
            return (ObjectSpliterator)super.b();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return (Spliterator)super.b();
        }
    }

    abstract class j<ConsumerType, SplitType extends j<ConsumerType, SplitType>> {
        private int b = 0;
        private int c;
        private int d;
        private boolean e;
        boolean a;
        private /* synthetic */ Double2ObjectOpenHashMap f;

        j(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.f = double2ObjectOpenHashMap;
            this.c = this.f.n;
            this.d = 0;
            this.e = this.f.containsNullKey;
            this.a = false;
        }

        j(Double2ObjectOpenHashMap double2ObjectOpenHashMap, int n2, int n3, boolean bl2) {
            this.f = double2ObjectOpenHashMap;
            this.c = this.f.n;
            this.d = 0;
            this.e = this.f.containsNullKey;
            this.a = false;
            this.b = n2;
            this.c = n3;
            this.e = bl2;
            this.a = true;
        }

        abstract void a(ConsumerType var1, int var2);

        abstract SplitType a(int var1, int var2, boolean var3);

        public boolean tryAdvance(ConsumerType action) {
            if (this.e) {
                this.e = false;
                ++this.d;
                this.a(action, this.f.n);
                return true;
            }
            double[] dArray = this.f.key;
            while (this.b < this.c) {
                if (Double.doubleToLongBits(dArray[this.b]) != 0L) {
                    ++this.d;
                    this.a(action, this.b++);
                    return true;
                }
                ++this.b;
            }
            return false;
        }

        public void forEachRemaining(ConsumerType action) {
            if (this.e) {
                this.e = false;
                ++this.d;
                this.a(action, this.f.n);
            }
            double[] dArray = this.f.key;
            while (this.b < this.c) {
                if (Double.doubleToLongBits(dArray[this.b]) != 0L) {
                    this.a(action, this.b);
                    ++this.d;
                }
                ++this.b;
            }
        }

        public long estimateSize() {
            if (!this.a) {
                return this.f.size - this.d;
            }
            return Math.min((long)(this.f.size - this.d), (long)((double)this.f.a() / (double)this.f.n * (double)(this.c - this.b)) + (long)(this.e ? 1 : 0));
        }

        public final SplitType b() {
            if (this.b >= this.c - 1) {
                return null;
            }
            int n2 = this.c - this.b >> 1;
            if (n2 <= 1) {
                return null;
            }
            n2 = this.b + n2;
            int n3 = this.b;
            int n4 = n2;
            SplitType SplitType = this.a(n3, n4, this.e);
            this.b = n2;
            this.e = false;
            this.a = true;
            return SplitType;
        }
    }

    final class c
    extends i
    implements ObjectIterator {
        private final g a;
        private /* synthetic */ Double2ObjectOpenHashMap b;

        private c(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.b = double2ObjectOpenHashMap;
            super(double2ObjectOpenHashMap, (byte)0);
            this.a = new g(this.b);
        }

        final /* synthetic */ void a(Object object, int n2) {
            int n3 = n2;
            Consumer consumer2 = (Consumer)object;
            object = this;
            this.a.a = n3;
            consumer2.accept(((c)object).a);
        }

        @Override
        public final /* synthetic */ Object next() {
            c c2 = this;
            this.a.a = c2.a();
            return c2.a;
        }

        /* synthetic */ c(Double2ObjectOpenHashMap double2ObjectOpenHashMap, byte by) {
            this(double2ObjectOpenHashMap);
        }
    }

    abstract class i<ConsumerType> {
        private int a;
        private int b;
        private int c;
        private boolean d;
        private DoubleArrayList e;
        private /* synthetic */ Double2ObjectOpenHashMap f;

        private i(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.f = double2ObjectOpenHashMap;
            this.a = this.f.n;
            this.b = -1;
            this.c = this.f.size;
            this.d = this.f.containsNullKey;
        }

        abstract void a(ConsumerType var1, int var2);

        public boolean hasNext() {
            return this.c != 0;
        }

        public final int a() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                return this.b;
            }
            double[] dArray = this.f.key;
            do {
                if (--this.a >= 0) continue;
                this.b = Integer.MIN_VALUE;
                double d2 = this.e.getDouble(-this.a - 1);
                int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.f.mask;
                while (Double.doubleToLongBits(d2) != Double.doubleToLongBits(dArray[n2])) {
                    n2 = n2 + 1 & this.f.mask;
                }
                return n2;
            } while (Double.doubleToLongBits(dArray[this.a]) == 0L);
            this.b = this.a;
            return this.b;
        }

        public void forEachRemaining(ConsumerType action) {
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                this.a(action, this.b);
                --this.c;
            }
            double[] dArray = this.f.key;
            while (this.c != 0) {
                if (--this.a < 0) {
                    this.b = Integer.MIN_VALUE;
                    double d2 = this.e.getDouble(-this.a - 1);
                    int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.f.mask;
                    while (Double.doubleToLongBits(d2) != Double.doubleToLongBits(dArray[n2])) {
                        n2 = n2 + 1 & this.f.mask;
                    }
                    this.a(action, n2);
                    --this.c;
                    continue;
                }
                if (Double.doubleToLongBits(dArray[this.a]) == 0L) continue;
                this.b = this.a;
                this.a(action, this.b);
                --this.c;
            }
        }

        public void remove() {
            block9: {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                if (this.b == this.f.n) {
                    this.f.containsNullKey = false;
                    this.f.value[this.f.n] = null;
                } else {
                    if (this.a >= 0) {
                        i i2 = this;
                        int n2 = i2.b;
                        i i3 = i2;
                        double[] dArray = i2.f.key;
                        while (true) {
                            double d2;
                            int n3 = n2;
                            n2 = n3 + 1 & i3.f.mask;
                            while (true) {
                                if (Double.doubleToLongBits(d2 = dArray[n2]) == 0L) {
                                    dArray[n3] = 0.0;
                                    i3.f.value[n3] = null;
                                    break block9;
                                }
                                int n4 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & i3.f.mask;
                                if (n3 > n2 ? n3 >= n4 && n4 > n2 : n3 >= n4 || n4 > n2) break;
                                n2 = n2 + 1 & i3.f.mask;
                            }
                            if (n2 < n3) {
                                if (i3.e == null) {
                                    i3.e = new DoubleArrayList(2);
                                }
                                ((it.unimi.dsi.fastutil.doubles.c)i3.e).add(dArray[n2]);
                            }
                            dArray[n3] = d2;
                            i3.f.value[n3] = i3.f.value[n2];
                        }
                    }
                    this.f.remove(this.e.getDouble(-this.a - 1));
                    this.b = -1;
                    return;
                }
            }
            --this.f.size;
            this.b = -1;
        }

        /* synthetic */ i(Double2ObjectOpenHashMap double2ObjectOpenHashMap, byte by) {
            this(double2ObjectOpenHashMap);
        }
    }

    final class g
    implements Double2ObjectMap.Entry<V>,
    Z<V>,
    Map.Entry<Double, V> {
        int a;
        private /* synthetic */ Double2ObjectOpenHashMap b;

        g(Double2ObjectOpenHashMap double2ObjectOpenHashMap, int n2) {
            this.b = double2ObjectOpenHashMap;
            this.a = n2;
        }

        g(Double2ObjectOpenHashMap double2ObjectOpenHashMap) {
            this.b = double2ObjectOpenHashMap;
        }

        @Override
        public final double getDoubleKey() {
            return this.b.key[this.a];
        }

        @Override
        public final double b() {
            return this.b.key[this.a];
        }

        @Override
        public final V getValue() {
            return this.b.value[this.a];
        }

        @Override
        public final V o_() {
            return this.b.value[this.a];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V v2) {
            void var1_1;
            Object v3 = this.b.value[this.a];
            this.b.value[this.a] = var1_1;
            return v3;
        }

        @Override
        @Deprecated
        public final Double getKey() {
            return this.b.key[this.a];
        }

        @Override
        public final boolean equals(Object o2) {
            Map.Entry entry;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            entry = entry;
            return Double.doubleToLongBits(this.b.key[this.a]) == Double.doubleToLongBits((Double)entry.getKey()) && Objects.equals(this.b.value[this.a], entry.getValue());
        }

        @Override
        public final int hashCode() {
            return HashCommon.double2int(this.b.key[this.a]) ^ (this.b.value[this.a] == null ? 0 : this.b.value[this.a].hashCode());
        }

        public final String toString() {
            return this.b.key[this.a] + "=>" + this.b.value[this.a];
        }
    }
}

