/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import it.unimi.dsi.fastutil.doubles.J;
import it.unimi.dsi.fastutil.doubles.R;
import it.unimi.dsi.fastutil.doubles.X;
import it.unimi.dsi.fastutil.doubles.c;
import it.unimi.dsi.fastutil.doubles.f;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;

public class DoubleOpenHashSet
extends f
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient double[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        DoubleOpenHashSet doubleOpenHashSet = this;
        doubleOpenHashSet.minN = doubleOpenHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new double[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public DoubleOpenHashSet() {
        this(16, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(Collection<? extends Double> c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((AbstractCollection)this).addAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(Collection<? extends Double> c2) {
        this((Collection<? extends Double>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(DoubleCollection c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        ((c)this).addAll((DoubleCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(DoubleCollection c2) {
        this((DoubleCollection)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(DoubleIterator i2, float f2) {
        this(16, (float)var2_2);
        void var2_2;
        while (i2.hasNext()) {
            ((c)this).add(i2.nextDouble());
        }
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(DoubleIterator i2) {
        this((DoubleIterator)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(Iterator<?> i2, float f2) {
        this(X.a((Iterator)var1_1), (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(Iterator<?> i2) {
        this(X.a((Iterator)var1_1));
        void var1_1;
    }

    public DoubleOpenHashSet(double[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0 : length, f2);
        J.c(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            ((c)this).add(a2[offset + i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(double[] a2, int offset, int length) {
        this((double[])var1_1, (int)var2_2, (int)var3_3, 0.75f);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(double[] a2, float f2) {
        this(a2, 0, ((void)var1_1).length, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DoubleOpenHashSet(double[] a2) {
        this((double[])var1_1, 0.75f);
        void var1_1;
    }

    public static DoubleOpenHashSet of() {
        return new DoubleOpenHashSet();
    }

    public static DoubleOpenHashSet of(double e2) {
        double d2;
        DoubleOpenHashSet doubleOpenHashSet = new DoubleOpenHashSet(1, 0.75f);
        ((c)doubleOpenHashSet).add(d2);
        return doubleOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static DoubleOpenHashSet of(double e0, double e1) {
        double d2;
        DoubleOpenHashSet doubleOpenHashSet = new DoubleOpenHashSet(2, 0.75f);
        ((c)doubleOpenHashSet).add(d2);
        if (!((c)doubleOpenHashSet).add(e1)) {
            void var2_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((double)var2_1)));
        }
        return doubleOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static DoubleOpenHashSet of(double e0, double e1, double e2) {
        double d2;
        DoubleOpenHashSet doubleOpenHashSet = new DoubleOpenHashSet(3, 0.75f);
        ((c)doubleOpenHashSet).add(d2);
        if (!((c)doubleOpenHashSet).add(e1)) {
            void var2_2;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf((double)var2_2)));
        }
        if (!((c)doubleOpenHashSet).add(e2)) {
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf(e2)));
        }
        return doubleOpenHashSet;
    }

    public static DoubleOpenHashSet of(double ... a2) {
        double[] dArray;
        DoubleOpenHashSet doubleOpenHashSet = new DoubleOpenHashSet(a2.length, 0.75f);
        for (double d2 : dArray) {
            if (((c)doubleOpenHashSet).add(d2)) continue;
            throw new IllegalArgumentException("Duplicate element ".concat(String.valueOf(d2)));
        }
        return doubleOpenHashSet;
    }

    public static DoubleOpenHashSet toSet(DoubleStream stream) {
        return stream.collect(DoubleOpenHashSet::new, DoubleOpenHashSet::add, DoubleOpenHashSet::addAll);
    }

    /*
     * WARNING - void declaration
     */
    public static DoubleOpenHashSet toSetWithExpectedSize(DoubleStream stream, int expectedSize) {
        void var1_1;
        DoubleStream doubleStream;
        if (expectedSize <= 16) {
            return DoubleOpenHashSet.toSet(stream);
        }
        return doubleStream.collect(new R.b<DoubleOpenHashSet>((int)var1_1, n2 -> {
            if (n2 <= 16) {
                return new DoubleOpenHashSet();
            }
            return new DoubleOpenHashSet(n2);
        }), DoubleOpenHashSet::add, DoubleOpenHashSet::addAll);
    }

    private int a() {
        if (this.containsNull) {
            return this.size - 1;
        }
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private void a(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(DoubleCollection c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            DoubleOpenHashSet doubleOpenHashSet = this;
            doubleOpenHashSet.a((long)(((AbstractCollection)doubleOpenHashSet).size() + c2.size()));
        }
        return super.addAll((DoubleCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            DoubleOpenHashSet doubleOpenHashSet = this;
            doubleOpenHashSet.a((long)(((AbstractCollection)doubleOpenHashSet).size() + c2.size()));
        }
        return super.addAll((Collection<? extends Double>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(double k2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            void var1_1;
            double[] dArray = this.key;
            int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
            double d2 = this.key[n2];
            if (Double.doubleToLongBits(d2) != 0L) {
                if (Double.doubleToLongBits(d2) == Double.doubleToLongBits(k2)) {
                    return false;
                }
                while (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) {
                    if (Double.doubleToLongBits(d2) != Double.doubleToLongBits(k2)) continue;
                    return false;
                }
            }
            dArray[n2] = var1_1;
        }
        if (this.size++ >= this.maxFill) {
            DoubleOpenHashSet doubleOpenHashSet = this;
            doubleOpenHashSet.rehash(HashCommon.arraySize(doubleOpenHashSet.size + 1, this.f));
        }
        return true;
    }

    private boolean a(int n2) {
        --this.size;
        int n3 = n2;
        DoubleOpenHashSet doubleOpenHashSet = this;
        double[] dArray = doubleOpenHashSet.key;
        block0: while (true) {
            double d2;
            int n4 = n3;
            n3 = n4 + 1 & doubleOpenHashSet.mask;
            while (true) {
                if (Double.doubleToLongBits(d2 = dArray[n3]) == 0L) break block0;
                int n5 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & doubleOpenHashSet.mask;
                if (n4 > n3 ? n4 >= n5 && n5 > n3 : n4 >= n5 || n5 > n3) break;
                n3 = n3 + 1 & doubleOpenHashSet.mask;
            }
            dArray[n4] = d2;
        }
        dArray[n4] = 0.0;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            DoubleOpenHashSet doubleOpenHashSet2 = this;
            doubleOpenHashSet2.rehash(doubleOpenHashSet2.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(double k222) {
        double k222;
        if (Double.doubleToLongBits(k222) == 0L) {
            if (this.containsNull) {
                DoubleOpenHashSet k222 = this;
                this.containsNull = false;
                k222.key[k222.n] = 0.0;
                --k222.size;
                if (k222.n > k222.minN && k222.size < k222.maxFill / 4 && k222.n > 16) {
                    DoubleOpenHashSet doubleOpenHashSet = k222;
                    doubleOpenHashSet.rehash(doubleOpenHashSet.n / 2);
                }
                return true;
            }
            return false;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k222)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return false;
        }
        if (Double.doubleToLongBits(k222) == Double.doubleToLongBits(d2)) {
            return this.a(n2);
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToLongBits(k222) != Double.doubleToLongBits(d2));
        return this.a(n2);
    }

    @Override
    public boolean contains(double k2) {
        if (Double.doubleToLongBits(k2) == 0L) {
            return this.containsNull;
        }
        double[] dArray = this.key;
        int n2 = (int)HashCommon.mix(Double.doubleToRawLongBits(k2)) & this.mask;
        double d2 = this.key[n2];
        if (Double.doubleToLongBits(d2) == 0L) {
            return false;
        }
        if (Double.doubleToLongBits(k2) == Double.doubleToLongBits(d2)) {
            return true;
        }
        do {
            if (Double.doubleToLongBits(d2 = dArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToLongBits(k2) != Double.doubleToLongBits(d2));
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0.0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public DoubleIterator iterator() {
        return new a(this, 0);
    }

    @Override
    public DoubleSpliterator spliterator() {
        return new b(this);
    }

    @Override
    public void forEach(DoubleConsumer action) {
        if (this.containsNull) {
            action.accept(this.key[this.n]);
        }
        double[] dArray = this.key;
        int n2 = this.n;
        while (n2-- != 0) {
            if (Double.doubleToLongBits(dArray[n2]) == 0L) continue;
            action.accept(dArray[n2]);
        }
    }

    public boolean trim() {
        DoubleOpenHashSet doubleOpenHashSet = this;
        return doubleOpenHashSet.trim(doubleOpenHashSet.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        double[] dArray = this.key;
        int n2 = newN - 1;
        double[] dArray2 = new double[newN + 1];
        int n3 = this.n;
        int n4 = this.a();
        while (n4-- != 0) {
            while (Double.doubleToLongBits(dArray[--n3]) == 0L) {
            }
            int n5 = (int)HashCommon.mix(Double.doubleToRawLongBits(dArray[n3])) & n2;
            if (Double.doubleToLongBits(dArray2[n5]) != 0L) {
                while (Double.doubleToLongBits(dArray2[n5 = n5 + 1 & n2]) != 0L) {
                }
            }
            dArray2[n5] = dArray[n3];
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = dArray2;
    }

    public DoubleOpenHashSet clone() {
        DoubleOpenHashSet doubleOpenHashSet;
        try {
            doubleOpenHashSet = (DoubleOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        doubleOpenHashSet.key = (double[])this.key.clone();
        doubleOpenHashSet.containsNull = this.containsNull;
        return doubleOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.a();
        int n4 = 0;
        while (n3-- != 0) {
            while (Double.doubleToLongBits(this.key[n4]) == 0L) {
                ++n4;
            }
            n2 += HashCommon.double2int(this.key[n4]);
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        DoubleIterator doubleIterator = ((c)this).iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeDouble(doubleIterator.nextDouble());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n + 1];
        double[] dArray = this.key;
        int n2 = this.size;
        while (n2-- != 0) {
            int n3;
            double d2 = s2.readDouble();
            if (Double.doubleToLongBits(d2) == 0L) {
                n3 = this.n;
                this.containsNull = true;
            } else {
                n3 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & this.mask;
                if (Double.doubleToLongBits(dArray[n3]) != 0L) {
                    while (Double.doubleToLongBits(dArray[n3 = n3 + 1 & this.mask]) != 0L) {
                    }
                }
            }
            dArray[n3] = d2;
        }
    }

    final class a
    implements DoubleIterator {
        private int a;
        private int b;
        private int c;
        private boolean d;
        private DoubleArrayList e;
        private /* synthetic */ DoubleOpenHashSet f;

        private a(DoubleOpenHashSet doubleOpenHashSet) {
            this.f = doubleOpenHashSet;
            this.a = this.f.n;
            this.b = -1;
            this.c = this.f.size;
            this.d = this.f.containsNull;
        }

        @Override
        public final boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public final double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                return this.f.key[this.f.n];
            }
            double[] dArray = this.f.key;
            do {
                if (--this.a >= 0) continue;
                this.b = Integer.MIN_VALUE;
                return this.e.getDouble(-this.a - 1);
            } while (Double.doubleToLongBits(dArray[this.a]) == 0L);
            this.b = this.a;
            return dArray[this.b];
        }

        @Override
        public final void remove() {
            block9: {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                if (this.b == this.f.n) {
                    this.f.containsNull = false;
                    this.f.key[this.f.n] = 0.0;
                } else {
                    if (this.a >= 0) {
                        a a2 = this;
                        int n2 = a2.b;
                        a a3 = a2;
                        double[] dArray = a2.f.key;
                        while (true) {
                            double d2;
                            int n3 = n2;
                            n2 = n3 + 1 & a3.f.mask;
                            while (true) {
                                if (Double.doubleToLongBits(d2 = dArray[n2]) == 0L) {
                                    dArray[n3] = 0.0;
                                    break block9;
                                }
                                int n4 = (int)HashCommon.mix(Double.doubleToRawLongBits(d2)) & a3.f.mask;
                                if (n3 > n2 ? n3 >= n4 && n4 > n2 : n3 >= n4 || n4 > n2) break;
                                n2 = n2 + 1 & a3.f.mask;
                            }
                            if (n2 < n3) {
                                if (a3.e == null) {
                                    a3.e = new DoubleArrayList(2);
                                }
                                ((c)a3.e).add(dArray[n2]);
                            }
                            dArray[n3] = d2;
                        }
                    }
                    ((f)this.f).remove(this.e.getDouble(-this.a - 1));
                    this.b = -1;
                    return;
                }
            }
            --this.f.size;
            this.b = -1;
        }

        @Override
        public final void forEachRemaining(DoubleConsumer action) {
            double[] dArray = this.f.key;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                action.accept(dArray[this.f.n]);
                --this.c;
            }
            while (this.c != 0) {
                if (--this.a < 0) {
                    this.b = Integer.MIN_VALUE;
                    action.accept(this.e.getDouble(-this.a - 1));
                    --this.c;
                    continue;
                }
                if (Double.doubleToLongBits(dArray[this.a]) == 0L) continue;
                this.b = this.a;
                action.accept(dArray[this.b]);
                --this.c;
            }
        }

        /* synthetic */ a(DoubleOpenHashSet doubleOpenHashSet, byte by) {
            this(doubleOpenHashSet);
        }
    }

    final class b
    implements DoubleSpliterator {
        private int a = 0;
        private int b;
        private int c;
        private boolean d;
        private boolean e;
        private /* synthetic */ DoubleOpenHashSet f;

        b(DoubleOpenHashSet doubleOpenHashSet) {
            this.f = doubleOpenHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
        }

        private b(DoubleOpenHashSet doubleOpenHashSet, int n2, int n3, boolean bl2) {
            this.f = doubleOpenHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
            this.a = n2;
            this.b = n3;
            this.d = bl2;
            this.e = true;
        }

        @Override
        public final boolean tryAdvance(DoubleConsumer action) {
            if (this.d) {
                this.d = false;
                ++this.c;
                action.accept(this.f.key[this.f.n]);
                return true;
            }
            double[] dArray = this.f.key;
            while (this.a < this.b) {
                if (Double.doubleToLongBits(dArray[this.a]) != 0L) {
                    ++this.c;
                    action.accept(dArray[this.a++]);
                    return true;
                }
                ++this.a;
            }
            return false;
        }

        @Override
        public final void forEachRemaining(DoubleConsumer action) {
            double[] dArray = this.f.key;
            if (this.d) {
                this.d = false;
                action.accept(dArray[this.f.n]);
                ++this.c;
            }
            while (this.a < this.b) {
                if (Double.doubleToLongBits(dArray[this.a]) != 0L) {
                    action.accept(dArray[this.a]);
                    ++this.c;
                }
                ++this.a;
            }
        }

        @Override
        public final int characteristics() {
            if (this.e) {
                return 257;
            }
            return 321;
        }

        @Override
        public final long estimateSize() {
            if (!this.e) {
                return this.f.size - this.c;
            }
            return Math.min((long)(this.f.size - this.c), (long)((double)this.f.a() / (double)this.f.n * (double)(this.b - this.a)) + (long)(this.d ? 1 : 0));
        }

        private b c() {
            if (this.a >= this.b - 1) {
                return null;
            }
            int n2 = this.b - this.a >> 1;
            if (n2 <= 1) {
                return null;
            }
            n2 = this.a + n2;
            int n3 = this.a;
            int n4 = n2;
            b b2 = new b(this.f, n3, n4, this.d);
            this.a = n2;
            this.d = false;
            this.e = true;
            return b2;
        }

        @Override
        public final /* synthetic */ DoubleSpliterator i_() {
            return this.c();
        }

        @Override
        public final /* synthetic */ Spliterator.OfDouble trySplit() {
            return this.c();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.c();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.c();
        }
    }
}

